/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.WriteListener;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.jaxrs.nio.NioOutputStream;
import org.apache.cxf.jaxrs.nio.NioWriteEntity;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

public final class NioWriteListenerImpl
implements WriteListener {
    private static final Logger LOG = LogUtils.getL7dLogger(NioWriteListenerImpl.class);
    private Continuation cont;
    private final NioWriteEntity entity;
    private final NioOutputStream out;

    public NioWriteListenerImpl(Continuation cont, NioWriteEntity entity, OutputStream out) {
        this.cont = cont;
        this.entity = entity;
        this.out = new NioOutputStream(out);
    }

    @Override
    public void onWritePossible() throws IOException {
        while (this.cont.isReadyForWrite()) {
            if (this.entity.getWriter().write(this.out)) continue;
            this.cont.reset();
            return;
        }
    }

    @Override
    public void onError(Throwable t) {
        block6: {
            try {
                if (this.entity.getError() != null) {
                    this.entity.getError().error(t);
                    break block6;
                }
                throw t;
            }
            catch (Throwable ex) {
                LOG.warning("NIO WriteListener error: " + ExceptionUtils.getStackTrace(ex));
            }
            finally {
                this.cont.resume();
            }
        }
    }
}

