/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

@Provider
public class DataSourceProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    protected static final Logger LOG = LogUtils.getL7dLogger(DataSourceProvider.class);
    private boolean useDataSourceContentType;

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return DataSourceProvider.isSupported(type);
    }

    @Override
    public T readFrom(Class<T> cls, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        DataSource ds = null;
        if (cls == FileDataSource.class) {
            File file = new BinaryDataProvider<File>().readFrom(File.class, (Type)((Object)File.class), annotations, type, headers, is);
            ds = new FileDataSource(file);
        } else if (cls == DataSource.class || cls == DataHandler.class) {
            ds = new InputStreamDataSource(is, type.toString());
        } else {
            LOG.warning("Unsupported DataSource class: " + cls.getName());
            throw ExceptionUtils.toWebApplicationException(null, null);
        }
        return cls.cast(DataSource.class.isAssignableFrom(cls) ? ds : new DataHandler(ds));
    }

    @Override
    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return DataSourceProvider.isSupported(type);
    }

    private static boolean isSupported(Class<?> type) {
        return DataSource.class.isAssignableFrom(type) || DataHandler.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(T src, Class<?> cls, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        DataSource ds;
        DataSource dataSource = ds = DataSource.class.isAssignableFrom(cls) ? (DataSource)src : ((DataHandler)src).getDataSource();
        if (this.useDataSourceContentType) {
            this.setContentTypeIfNeeded(type, headers, ds.getContentType());
        }
        IOUtils.copyAndCloseInput(ds.getInputStream(), os);
    }

    private void setContentTypeIfNeeded(MediaType type, MultivaluedMap<String, Object> headers, String ct) {
        if (!StringUtils.isEmpty(ct) && !type.equals(JAXRSUtils.toMediaType(ct))) {
            headers.putSingle("Content-Type", ct);
        }
    }

    public void setUseDataSourceContentType(boolean useDataSourceContentType) {
        this.useDataSourceContentType = useDataSourceContentType;
    }
}

