/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.dataformat.DataFormatEndpoint;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.StringHelper;

@Component(value="dataformat")
public class DataFormatComponent
extends DefaultComponent {
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String operation = StringHelper.after(remaining, ":");
        if (!"marshal".equals(operation) && !"unmarshal".equals(operation)) {
            throw new IllegalArgumentException("Operation must be either marshal or unmarshal, was: " + operation);
        }
        String name = StringHelper.before(remaining, ":");
        DataFormat df = this.getCamelContext().createDataFormat(name);
        if (df == null) {
            df = this.getCamelContext().resolveDataFormat(name);
        }
        if (df == null) {
            throw new IllegalArgumentException("Cannot find data format with name: " + name);
        }
        PropertyConfigurer configurer = this.getCamelContext().adapt(ExtendedCamelContext.class).getConfigurerResolver().resolvePropertyConfigurer(name + "-dataformat", this.getCamelContext());
        PropertyBindingSupport.Builder builder = new PropertyBindingSupport.Builder();
        builder.withConfigurer(configurer);
        builder.bind(this.getCamelContext(), df, parameters);
        DataFormatEndpoint endpoint = new DataFormatEndpoint(uri, this, df);
        endpoint.setOperation(operation);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }
}

