/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.document;

import com.datasonnet.Utils;
import com.datasonnet.document.InvalidMediaTypeException;
import com.datasonnet.document.MediaType;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class MediaTypeUtils {
    private static final byte[] BOUNDARY_CHARS = new byte[]{45, 95, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    public static final Comparator<MediaType> SPECIFICITY_COMPARATOR = new MediaType.SpecificityComparator<MediaType>();
    private static final ConcurrentLruCache<String, MediaType> cachedMimeTypes = new ConcurrentLruCache<String, MediaType>(64, MediaTypeUtils::parseMediaTypeInternal);
    @Nullable
    private static volatile Random random;

    public static MediaType parseMediaType(String mediaType) {
        if (mediaType == null || mediaType.isEmpty()) {
            throw new InvalidMediaTypeException(mediaType, "'mimeType' must not be empty");
        }
        if (mediaType.startsWith("multipart")) {
            return MediaTypeUtils.parseMediaTypeInternal(mediaType);
        }
        return cachedMimeTypes.get(mediaType);
    }

    private static MediaType parseMediaTypeInternal(String mimeType) {
        int nextIndex;
        int subIndex;
        int index = mimeType.indexOf(59);
        String fullType = (index >= 0 ? mimeType.substring(0, index) : mimeType).trim();
        if (fullType.isEmpty()) {
            throw new InvalidMediaTypeException(mimeType, "'mimeType' must not be empty");
        }
        if ("*".equals(fullType)) {
            fullType = "*/*";
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new InvalidMediaTypeException(mimeType, "does not contain '/'");
        }
        if (subIndex == fullType.length() - 1) {
            throw new InvalidMediaTypeException(mimeType, "does not contain subtype after '/'");
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1);
        if ("*".equals(type) && !"*".equals(subtype)) {
            throw new InvalidMediaTypeException(mimeType, "wildcard type is legal only in '*/*' (all mime types)");
        }
        LinkedHashMap<String, String> parameters = null;
        do {
            int eqIndex;
            String parameter;
            boolean quoted = false;
            for (nextIndex = index + 1; nextIndex < mimeType.length(); ++nextIndex) {
                char ch = mimeType.charAt(nextIndex);
                if (ch == ';') {
                    if (quoted) continue;
                    break;
                }
                if (ch == '\"') {
                    quoted = !quoted;
                    continue;
                }
                if (ch != '\\') continue;
                ++nextIndex;
            }
            if ((parameter = mimeType.substring(index + 1, nextIndex).trim()).length() <= 0) continue;
            if (parameters == null) {
                parameters = new LinkedHashMap<String, String>(4);
            }
            if ((eqIndex = parameter.indexOf(61)) < 0) continue;
            String attribute = parameter.substring(0, eqIndex).trim();
            String value = parameter.substring(eqIndex + 1).trim();
            try {
                MediaType.checkParameters(attribute, value);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidMediaTypeException(mimeType, ex.getMessage());
            }
            parameters.put(attribute, value);
        } while ((index = nextIndex) < mimeType.length());
        try {
            return new MediaType(type, subtype, parameters);
        }
        catch (UnsupportedCharsetException ex) {
            throw new InvalidMediaTypeException(mimeType, "unsupported charset '" + ex.getCharsetName() + "'");
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidMediaTypeException(mimeType, ex.getMessage());
        }
    }

    public static List<MediaType> parseMediaTypes(String mimeTypes) {
        if (mimeTypes == null || mimeTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return MediaTypeUtils.tokenize(mimeTypes).stream().filter(Utils::hasText).map(MediaTypeUtils::parseMediaType).collect(Collectors.toList());
    }

    public static List<String> tokenize(String mediaTypes) {
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        boolean inQuotes = false;
        int startIndex = 0;
        block5: for (int i = 0; i < mediaTypes.length(); ++i) {
            switch (mediaTypes.charAt(i)) {
                case '\"': {
                    inQuotes = !inQuotes;
                    continue block5;
                }
                case ',': {
                    if (inQuotes) continue block5;
                    tokens.add(mediaTypes.substring(startIndex, i));
                    startIndex = i + 1;
                    continue block5;
                }
                case '\\': {
                    ++i;
                }
            }
        }
        tokens.add(mediaTypes.substring(startIndex));
        return tokens;
    }

    public static String toString(Collection<? extends MediaType> mimeTypes) {
        StringBuilder builder = new StringBuilder();
        Iterator<? extends MediaType> iterator2 = mimeTypes.iterator();
        while (iterator2.hasNext()) {
            MediaType mimeType = iterator2.next();
            mimeType.appendTo(builder);
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static void sortBySpecificity(List<MediaType> mimeTypes) {
        Objects.requireNonNull(mimeTypes, "'mimeTypes' must not be null");
        if (mimeTypes.size() > 1) {
            mimeTypes.sort(SPECIFICITY_COMPARATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Random initRandom() {
        Random randomToUse = random;
        if (randomToUse != null) return randomToUse;
        Class<MediaTypeUtils> clazz = MediaTypeUtils.class;
        synchronized (MediaTypeUtils.class) {
            randomToUse = random;
            if (randomToUse != null) return randomToUse;
            random = randomToUse = new SecureRandom();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return randomToUse;
        }
    }

    public static byte[] generateMultipartBoundary() {
        Random randomToUse = MediaTypeUtils.initRandom();
        byte[] boundary = new byte[randomToUse.nextInt(11) + 30];
        for (int i = 0; i < boundary.length; ++i) {
            boundary[i] = BOUNDARY_CHARS[randomToUse.nextInt(BOUNDARY_CHARS.length)];
        }
        return boundary;
    }

    public static String generateMultipartBoundaryString() {
        return new String(MediaTypeUtils.generateMultipartBoundary(), StandardCharsets.US_ASCII);
    }

    private static class ConcurrentLruCache<K, V> {
        private final int maxSize;
        private final ConcurrentLinkedDeque<K> queue = new ConcurrentLinkedDeque();
        private final ConcurrentHashMap<K, V> cache = new ConcurrentHashMap();
        private final ReadWriteLock lock;
        private final Function<K, V> generator;
        private volatile int size;

        public ConcurrentLruCache(int maxSize, Function<K, V> generator) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("LRU max size should be positive");
            }
            Objects.requireNonNull(generator, "Generator function should not be null");
            this.maxSize = maxSize;
            this.generator = generator;
            this.lock = new ReentrantReadWriteLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) {
            V cached = this.cache.get(key);
            if (cached != null) {
                if (this.size < this.maxSize) {
                    return cached;
                }
                this.lock.readLock().lock();
                try {
                    if (this.queue.removeLastOccurrence(key)) {
                        this.queue.offer(key);
                    }
                    V v = cached;
                    return v;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            this.lock.writeLock().lock();
            try {
                K leastUsed;
                cached = this.cache.get(key);
                if (cached != null) {
                    if (this.queue.removeLastOccurrence(key)) {
                        this.queue.offer(key);
                    }
                    V v = cached;
                    return v;
                }
                V value = this.generator.apply(key);
                int cacheSize = this.size;
                if (cacheSize == this.maxSize && (leastUsed = this.queue.poll()) != null) {
                    this.cache.remove(leastUsed);
                    --cacheSize;
                }
                this.queue.offer(key);
                this.cache.put(key, value);
                this.size = cacheSize + 1;
                V v = value;
                return v;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

