/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.ViewMatcher;
import com.fasterxml.jackson.dataformat.csv.CsvFactory;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.impl.LRUMap;
import java.util.Collection;

public class CsvMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    protected final LRUMap<JavaType, CsvSchema> _untypedSchemas;
    protected final LRUMap<JavaType, CsvSchema> _typedSchemas;

    public CsvMapper() {
        this(new CsvFactory());
    }

    public CsvMapper(CsvFactory f) {
        super(f);
        this.enable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
        this._untypedSchemas = new LRUMap(8, 32);
        this._typedSchemas = new LRUMap(8, 32);
    }

    protected CsvMapper(CsvMapper src) {
        super(src);
        this._untypedSchemas = new LRUMap(8, 32);
        this._typedSchemas = new LRUMap(8, 32);
    }

    public static Builder csvBuilder() {
        return new Builder(new CsvMapper());
    }

    public static Builder builder() {
        return new Builder(new CsvMapper());
    }

    public static Builder builder(CsvFactory streamFactory) {
        return new Builder(new CsvMapper(streamFactory));
    }

    @Override
    public CsvMapper copy() {
        this._checkInvalidCopy(CsvMapper.class);
        return new CsvMapper(this);
    }

    public CsvMapper configure(CsvGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public CsvMapper configure(CsvParser.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public CsvMapper enable(CsvGenerator.Feature f) {
        ((CsvFactory)this._jsonFactory).enable(f);
        return this;
    }

    public CsvMapper enable(CsvParser.Feature f) {
        ((CsvFactory)this._jsonFactory).enable(f);
        return this;
    }

    public CsvMapper disable(CsvGenerator.Feature f) {
        ((CsvFactory)this._jsonFactory).disable(f);
        return this;
    }

    public CsvMapper disable(CsvParser.Feature f) {
        ((CsvFactory)this._jsonFactory).disable(f);
        return this;
    }

    @Override
    public CsvFactory getFactory() {
        return (CsvFactory)this._jsonFactory;
    }

    public ObjectReader readerWithSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.readerFor(type).with(this.schemaFor(type));
    }

    public ObjectReader readerWithTypedSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.readerFor(type).with(this.typedSchemaFor(type));
    }

    public ObjectWriter writerWithSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.writerFor(type).with(this.schemaFor(type));
    }

    public ObjectWriter writerWithTypedSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.writerFor(type).with(this.typedSchemaFor(type));
    }

    public CsvSchema schemaWithHeader() {
        return CsvSchema.emptySchema().withHeader();
    }

    public CsvSchema schema() {
        return CsvSchema.emptySchema();
    }

    public CsvSchema schemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._untypedSchemas, false, null);
    }

    public CsvSchema schemaForWithView(JavaType pojoType, Class<?> view) {
        return this._schemaFor(pojoType, this._untypedSchemas, false, view);
    }

    public final CsvSchema schemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._untypedSchemas, false, null);
    }

    public final CsvSchema schemaForWithView(Class<?> pojoType, Class<?> view) {
        return this._schemaFor(this.constructType(pojoType), this._untypedSchemas, false, view);
    }

    public final CsvSchema schemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._untypedSchemas, false, null);
    }

    public final CsvSchema schemaForWithView(TypeReference<?> pojoTypeRef, Class<?> view) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._untypedSchemas, false, view);
    }

    public CsvSchema typedSchemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._typedSchemas, true, null);
    }

    public CsvSchema typedSchemaForWithView(JavaType pojoType, Class<?> view) {
        return this._schemaFor(pojoType, this._typedSchemas, true, view);
    }

    public final CsvSchema typedSchemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._typedSchemas, true, null);
    }

    public final CsvSchema typedSchemaForWithView(Class<?> pojoType, Class<?> view) {
        return this._schemaFor(this.constructType(pojoType), this._typedSchemas, true, view);
    }

    public final CsvSchema typedSchemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._typedSchemas, true, null);
    }

    public final CsvSchema typedSchemaForWithView(TypeReference<?> pojoTypeRef, Class<?> view) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._typedSchemas, true, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CsvSchema _schemaFor(JavaType pojoType, LRUMap<JavaType, CsvSchema> schemas, boolean typed, Class<?> view) {
        if (view == null) {
            LRUMap<JavaType, CsvSchema> lRUMap = schemas;
            synchronized (lRUMap) {
                CsvSchema s2 = (CsvSchema)schemas.get(pojoType);
                if (s2 != null) {
                    return s2;
                }
            }
        }
        AnnotationIntrospector intr = this._deserializationConfig.getAnnotationIntrospector();
        CsvSchema.Builder builder = CsvSchema.builder();
        this._addSchemaProperties(builder, intr, typed, pojoType, null, view);
        CsvSchema result2 = builder.build();
        if (view == null) {
            LRUMap<JavaType, CsvSchema> lRUMap = schemas;
            synchronized (lRUMap) {
                schemas.put(pojoType, result2);
            }
        }
        return result2;
    }

    @Deprecated
    protected CsvSchema _schemaFor(JavaType pojoType, LRUMap<JavaType, CsvSchema> schemas, boolean typed) {
        return this._schemaFor(pojoType, schemas, typed, null);
    }

    protected boolean _nonPojoType(JavaType t) {
        if (t.isPrimitive() || t.isEnumType()) {
            return true;
        }
        Class<?> raw2 = t.getRawClass();
        if (Number.class.isAssignableFrom(raw2) && (raw2 == Byte.class || raw2 == Short.class || raw2 == Character.class || raw2 == Integer.class || raw2 == Long.class || raw2 == Float.class || raw2 == Double.class)) {
            return true;
        }
        return raw2 == Boolean.class || raw2 == String.class;
    }

    protected void _addSchemaProperties(CsvSchema.Builder builder, AnnotationIntrospector intr, boolean typed, JavaType pojoType, NameTransformer unwrapper, Class<?> view) {
        if (this._nonPojoType(pojoType)) {
            return;
        }
        BeanDescription beanDesc = this.getSerializationConfig().introspect(pojoType);
        boolean includeByDefault = this.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        for (BeanPropertyDefinition prop : beanDesc.findProperties()) {
            NameTransformer nextUnwrapper;
            if (view != null) {
                Class<?>[] views = prop.findViews();
                if (views == null) {
                    views = beanDesc.findDefaultViews();
                }
                if ((views != null || !includeByDefault) && !ViewMatcher.construct(views).isVisibleForView(view)) continue;
            }
            if (!prop.couldSerialize()) continue;
            AnnotatedMember m = prop.getPrimaryMember();
            if (m != null && (nextUnwrapper = intr.findUnwrappingNameTransformer(prop.getPrimaryMember())) != null) {
                if (unwrapper != null) {
                    nextUnwrapper = NameTransformer.chainedTransformer(unwrapper, nextUnwrapper);
                }
                JavaType nextType = m.getType();
                this._addSchemaProperties(builder, intr, typed, nextType, nextUnwrapper, view);
                continue;
            }
            String name = prop.getName();
            if (unwrapper != null) {
                name = unwrapper.transform(name);
            }
            if (typed && m != null) {
                builder.addColumn(name, this._determineType(m.getRawType()));
                continue;
            }
            builder.addColumn(name);
        }
    }

    protected CsvSchema.ColumnType _determineType(Class<?> propType) {
        if (propType.isArray()) {
            if (propType == byte[].class) {
                return CsvSchema.ColumnType.STRING;
            }
            return CsvSchema.ColumnType.ARRAY;
        }
        if (propType == String.class || propType == Character.TYPE || propType == Character.class) {
            return CsvSchema.ColumnType.STRING;
        }
        if (propType == Boolean.class || propType == Boolean.TYPE) {
            return CsvSchema.ColumnType.BOOLEAN;
        }
        if (propType.isPrimitive()) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (Number.class.isAssignableFrom(propType)) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (Collection.class.isAssignableFrom(propType)) {
            return CsvSchema.ColumnType.ARRAY;
        }
        return CsvSchema.ColumnType.NUMBER_OR_STRING;
    }

    public static class Builder
    extends MapperBuilder<CsvMapper, Builder> {
        public Builder(CsvMapper m) {
            super(m);
        }

        public Builder enable(CsvParser.Feature ... features) {
            for (CsvParser.Feature f : features) {
                ((CsvMapper)this._mapper).enable(f);
            }
            return this;
        }

        public Builder disable(CsvParser.Feature ... features) {
            for (CsvParser.Feature f : features) {
                ((CsvMapper)this._mapper).disable(f);
            }
            return this;
        }

        public Builder configure(CsvParser.Feature f, boolean state) {
            if (state) {
                ((CsvMapper)this._mapper).enable(f);
            } else {
                ((CsvMapper)this._mapper).disable(f);
            }
            return this;
        }

        public Builder enable(CsvGenerator.Feature ... features) {
            for (CsvGenerator.Feature f : features) {
                ((CsvMapper)this._mapper).enable(f);
            }
            return this;
        }

        public Builder disable(CsvGenerator.Feature ... features) {
            for (CsvGenerator.Feature f : features) {
                ((CsvMapper)this._mapper).disable(f);
            }
            return this;
        }

        public Builder configure(CsvGenerator.Feature f, boolean state) {
            if (state) {
                ((CsvMapper)this._mapper).enable(f);
            } else {
                ((CsvMapper)this._mapper).disable(f);
            }
            return this;
        }
    }
}

