/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    private static Object getFieldVal(Class<?> cls, Object obj, String fieldName, boolean throwException) throws IllegalArgumentException {
        block10: {
            Field field2 = null;
            for (Class<?> currClass = cls; currClass != null; currClass = currClass.getSuperclass()) {
                try {
                    field2 = currClass.getDeclaredField(fieldName);
                    break;
                }
                catch (ReflectiveOperationException | SecurityException exception) {
                    continue;
                }
            }
            if (field2 == null) {
                if (throwException) {
                    throw new IllegalArgumentException((obj == null ? "Static field " : "Field ") + "\"" + fieldName + "\" not found or not accessible");
                }
            } else {
                try {
                    field2.setAccessible(true);
                }
                catch (RuntimeException currClass) {
                    // empty catch block
                }
                try {
                    return field2.get(obj);
                }
                catch (IllegalAccessException e) {
                    if (!throwException) break block10;
                    throw new IllegalArgumentException("Can't read " + (obj == null ? "static " : "") + " field \"" + fieldName + "\": " + e);
                }
            }
        }
        return null;
    }

    public static Object getFieldVal(Object obj, String fieldName, boolean throwException) throws IllegalArgumentException {
        if (obj == null || fieldName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.getFieldVal(obj.getClass(), obj, fieldName, throwException);
    }

    public static Object getStaticFieldVal(Class<?> cls, String fieldName, boolean throwException) throws IllegalArgumentException {
        if (cls == null || fieldName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.getFieldVal(cls, null, fieldName, throwException);
    }

    private static List<Class<?>> getReverseMethodAttemptOrder(Class<?> cls) {
        ArrayList reverseAttemptOrder = new ArrayList();
        for (Class<?> c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
            reverseAttemptOrder.add(c);
        }
        HashSet addedIfaces = new HashSet();
        LinkedList ifaceQueue = new LinkedList();
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            if (c.isInterface() && addedIfaces.add(c)) {
                ifaceQueue.add(c);
            }
            for (Class<?> iface : c.getInterfaces()) {
                if (!addedIfaces.add(iface)) continue;
                ifaceQueue.add(iface);
            }
        }
        while (!ifaceQueue.isEmpty()) {
            Class iface = (Class)ifaceQueue.remove();
            reverseAttemptOrder.add(iface);
            Class<?>[] superIfaces = iface.getInterfaces();
            if (superIfaces.length <= 0) continue;
            for (Class<?> superIface : superIfaces) {
                if (!addedIfaces.add(superIface)) continue;
                ifaceQueue.add(superIface);
            }
        }
        return reverseAttemptOrder;
    }

    private static Object invokeMethod(Class<?> cls, Object obj, String methodName, boolean oneArg, Class<?> argType, Object param2, boolean throwException) throws IllegalArgumentException {
        block12: {
            Method method = null;
            List<Class<?>> reverseAttemptOrder = ReflectionUtils.getReverseMethodAttemptOrder(cls);
            for (int i = reverseAttemptOrder.size() - 1; i >= 0; --i) {
                Class<?> classOrInterface = reverseAttemptOrder.get(i);
                try {
                    method = oneArg ? classOrInterface.getDeclaredMethod(methodName, argType) : classOrInterface.getDeclaredMethod(methodName, new Class[0]);
                    break;
                }
                catch (ReflectiveOperationException | SecurityException exception) {
                    continue;
                }
            }
            if (method == null) {
                if (throwException) {
                    throw new IllegalArgumentException((obj == null ? "Static method " : "Method ") + "\"" + methodName + "\" not found or not accesible");
                }
            } else {
                try {
                    method.setAccessible(true);
                }
                catch (RuntimeException i) {
                    // empty catch block
                }
                try {
                    return oneArg ? method.invoke(obj, param2) : method.invoke(obj, new Object[0]);
                }
                catch (IllegalAccessException | SecurityException e) {
                    if (throwException) {
                        throw new IllegalArgumentException("Can't call " + (obj == null ? "static " : "") + "method \"" + methodName + "\": " + e);
                    }
                }
                catch (InvocationTargetException e) {
                    if (!throwException) break block12;
                    throw new IllegalArgumentException("Exception while invoking " + (obj == null ? "static " : "") + "method \"" + methodName + "\"", e);
                }
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, boolean throwException) throws IllegalArgumentException {
        if (obj == null || methodName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.invokeMethod(obj.getClass(), obj, methodName, false, null, null, throwException);
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?> argType, Object param2, boolean throwException) throws IllegalArgumentException {
        if (obj == null || methodName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.invokeMethod(obj.getClass(), obj, methodName, true, argType, param2, throwException);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, boolean throwException) throws IllegalArgumentException {
        if (cls == null || methodName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.invokeMethod(cls, null, methodName, false, null, null, throwException);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Class<?> argType, Object param2, boolean throwException) throws IllegalArgumentException {
        if (cls == null || methodName == null) {
            if (throwException) {
                throw new NullPointerException();
            }
            return null;
        }
        return ReflectionUtils.invokeMethod(cls, null, methodName, true, argType, param2, throwException);
    }

    public static Class<?> classForNameOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (LinkageError | ReflectiveOperationException e) {
            return null;
        }
    }
}

