/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.spi.BulkTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;

@DeferredContextBinding
public final class StreamCacheBulkConverterLoader
implements TypeConverterLoader,
BulkTypeConverters,
CamelContextAware {
    private CamelContext camelContext;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public int size() {
        return 6;
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registry.addBulkTypeConverters(this);
    }

    @Override
    public <T> T convertTo(Class<?> from2, Class<T> to2, Exchange exchange, Object value) throws TypeConversionException {
        try {
            Object obj = this.doConvertTo(from2, to2, exchange, value);
            if (obj == Void.class) {
                return null;
            }
            return (T)obj;
        }
        catch (TypeConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeConversionException(value, to2, e);
        }
    }

    private Object doConvertTo(Class<?> from2, Class<?> to2, Exchange exchange, Object value) throws Exception {
        if (to2 == byte[].class) {
            if (value instanceof StreamCache) {
                return StreamCacheConverter.convertToByteArray((StreamCache)value, exchange);
            }
        } else if (to2 == ByteBuffer.class) {
            if (value instanceof StreamCache) {
                return StreamCacheConverter.convertToByteBuffer((StreamCache)value, exchange);
            }
        } else if (to2 == StreamCache.class) {
            if (value instanceof ByteArrayInputStream) {
                return StreamCacheConverter.convertToStreamCache((ByteArrayInputStream)value, exchange);
            }
            if (value instanceof InputStream) {
                return StreamCacheConverter.convertToStreamCache((InputStream)value, exchange);
            }
            if (value instanceof CachedOutputStream) {
                return StreamCacheConverter.convertToStreamCache((CachedOutputStream)value, exchange);
            }
            if (value instanceof Reader) {
                return StreamCacheConverter.convertToStreamCache((Reader)value, exchange);
            }
        }
        return null;
    }

    @Override
    public TypeConverter lookup(Class<?> to2, Class<?> from2) {
        if (to2 == byte[].class) {
            if (from2 == StreamCache.class) {
                return this;
            }
        } else if (to2 == ByteBuffer.class) {
            if (from2 == StreamCache.class) {
                return this;
            }
        } else if (to2 == StreamCache.class) {
            if (from2 == ByteArrayInputStream.class) {
                return this;
            }
            if (from2 == InputStream.class) {
                return this;
            }
            if (from2 == CachedOutputStream.class) {
                return this;
            }
            if (from2 == Reader.class) {
                return this;
            }
        }
        return null;
    }
}

