/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.health;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckFilter;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HealthCheckHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckHelper.class);

    private HealthCheckHelper() {
    }

    public static String getGroup(HealthCheck check) {
        return ObjectHelper.supplyIfEmpty(check.getGroup(), () -> "");
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext) {
        return HealthCheckHelper.invoke(camelContext, (HealthCheck check) -> Collections.emptyMap(), (HealthCheck check) -> false);
    }

    public static Collection<HealthCheck.Result> invokeReadiness(CamelContext camelContext) {
        return HealthCheckHelper.invoke(camelContext, (HealthCheck check) -> Collections.emptyMap(), (HealthCheck check) -> !check.isReadiness());
    }

    public static Collection<HealthCheck.Result> invokeLiveness(CamelContext camelContext) {
        return HealthCheckHelper.invoke(camelContext, (HealthCheck check) -> Collections.emptyMap(), (HealthCheck check) -> !check.isLiveness());
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, Function<HealthCheck, Map<String, Object>> optionsSupplier) {
        return HealthCheckHelper.invoke(camelContext, optionsSupplier, (HealthCheck check) -> false);
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, HealthCheckFilter filter2) {
        return HealthCheckHelper.invoke(camelContext, (HealthCheck check) -> Collections.emptyMap(), filter2);
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, Function<HealthCheck, Map<String, Object>> optionsSupplier, HealthCheckFilter filter2) {
        HealthCheckRegistry registry = HealthCheckRegistry.get(camelContext);
        if (registry != null) {
            return registry.stream().collect(Collectors.groupingBy(HealthCheckHelper::getGroup)).entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).filter(check -> !filter2.test((HealthCheck)check)).sorted(Comparator.comparingInt(HealthCheck::getOrder)).distinct().map(check -> check.call((Map)optionsSupplier.apply((HealthCheck)check))).collect(Collectors.toList());
        }
        LOGGER.debug("No health check source found");
        return Collections.emptyList();
    }

    public static Optional<HealthCheck.Result> query(CamelContext camelContext, String id, Map<String, Object> options) {
        HealthCheckRegistry registry = HealthCheckRegistry.get(camelContext);
        if (registry != null) {
            return registry.getCheck(id).map(check -> check.call(options));
        }
        LOGGER.debug("No health check source found");
        return Optional.empty();
    }

    public static Optional<HealthCheck.Result> invoke(CamelContext camelContext, String id, Map<String, Object> options) {
        HealthCheckRegistry registry = HealthCheckRegistry.get(camelContext);
        if (registry != null) {
            return registry.getCheck(id).map(check -> check.call(options));
        }
        LOGGER.debug("No health check source found");
        return Optional.empty();
    }
}

