/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.datasonnet;

import com.datasonnet.Mapper;
import com.datasonnet.document.MediaType;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.datasonnet.DatasonnetExpression;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Language(value="datasonnet")
public class DatasonnetLanguage
extends LanguageSupport
implements PropertyConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(DatasonnetLanguage.class);
    private static final Map<String, String> CLASSPATH_IMPORTS = new HashMap<String, String>();
    private final Map<String, Mapper> mapperCache = LRUCacheFactory.newLRUSoftCache(16, 1000, true);
    private MediaType bodyMediaType;
    private MediaType outputMediaType;
    private Class<?> resultType;
    private Collection<String> libraryPaths;

    @Override
    public Predicate createPredicate(String expression) {
        return this.createPredicate(expression, null);
    }

    @Override
    public Expression createExpression(String expression) {
        return this.createExpression(expression, null);
    }

    @Override
    public Predicate createPredicate(String expression, Object[] properties) {
        return (Predicate)((Object)this.createExpression(expression, properties));
    }

    @Override
    public Expression createExpression(String expression, Object[] properties) {
        expression = this.loadResource(expression);
        DatasonnetExpression answer = new DatasonnetExpression(expression);
        answer.setResultType(this.property(Class.class, properties, 0, this.resultType));
        String stringBodyMediaType = this.property(String.class, properties, 1, null);
        answer.setBodyMediaType(stringBodyMediaType != null ? MediaType.valueOf(stringBodyMediaType) : this.bodyMediaType);
        String stringOutputMediaType = this.property(String.class, properties, 2, null);
        answer.setOutputMediaType(stringOutputMediaType != null ? MediaType.valueOf(stringOutputMediaType) : this.outputMediaType);
        return answer;
    }

    Optional<Mapper> lookup(String script) {
        return Optional.ofNullable(this.mapperCache.get(script));
    }

    Mapper computeIfMiss(String script, Supplier<Mapper> mapperSupplier) {
        return this.mapperCache.computeIfAbsent(script, k -> (Mapper)mapperSupplier.get());
    }

    public Map<String, String> getClasspathImports() {
        return CLASSPATH_IMPORTS;
    }

    @Override
    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bodyMediaType": 
            case "bodymediatype": {
                this.setBodyMediaType(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "outputMediaType": 
            case "outputmediatype": {
                this.setOutputMediaType(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "resultType": 
            case "resulttype": {
                this.setResultType(PropertyConfigurerSupport.property(camelContext, Class.class, value));
                return true;
            }
        }
        return false;
    }

    public MediaType getBodyMediaType() {
        return this.bodyMediaType;
    }

    public void setBodyMediaType(MediaType bodyMediaType) {
        this.bodyMediaType = bodyMediaType;
    }

    public void setBodyMediaType(String bodyMediaType) {
        this.bodyMediaType = MediaType.valueOf(bodyMediaType);
    }

    public MediaType getOutputMediaType() {
        return this.outputMediaType;
    }

    public void setOutputMediaType(MediaType outputMediaType) {
        this.outputMediaType = outputMediaType;
    }

    public void setOutputMediaType(String outputMediaType) {
        this.outputMediaType = MediaType.valueOf(outputMediaType);
    }

    public Collection<String> getLibraryPaths() {
        return this.libraryPaths;
    }

    public void setLibraryPaths(Collection<String> libraryPaths) {
        this.libraryPaths = libraryPaths;
    }

    public void setResultType(Class<?> targetType) {
        this.resultType = targetType;
    }

    static {
        LOG.debug("One time classpath search...");
        try (ScanResult scanResult = new ClassGraph().whitelistPaths("/").scan();){
            scanResult.getResourcesWithExtension("libsonnet").forEachByteArray((resource, bytes) -> {
                LOG.debug("Loading DataSonnet library: {}", (Object)resource.getPath());
                CLASSPATH_IMPORTS.put(resource.getPath(), new String(bytes, StandardCharsets.UTF_8));
            });
        }
        LOG.debug("One time classpath search done");
    }
}

