/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;

public class DefaultMessage
extends MessageSupport {
    private Map<String, Object> headers;

    public DefaultMessage(Exchange exchange) {
        this.setExchange(exchange);
        if (exchange != null) {
            this.setCamelContext(exchange.getContext());
        }
    }

    public DefaultMessage(CamelContext camelContext) {
        this.camelContext = (ExtendedCamelContext)camelContext;
        this.typeConverter = camelContext.getTypeConverter();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    @Override
    public Object getHeader(String name) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        if (!this.headers.isEmpty()) {
            return this.headers.get(name);
        }
        return null;
    }

    @Override
    public Object getHeader(String name, Object defaultValue) {
        Object answer = null;
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        if (!this.headers.isEmpty()) {
            answer = this.headers.get(name);
        }
        return answer != null ? answer : defaultValue;
    }

    @Override
    public Object getHeader(String name, Supplier<Object> defaultValueSupplier) {
        Object answer = null;
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        if (!this.headers.isEmpty()) {
            answer = this.headers.get(name);
        }
        return answer != null ? answer : defaultValueSupplier.get();
    }

    @Override
    public <T> T getHeader(String name, Class<T> type) {
        Object value = null;
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        if (!this.headers.isEmpty()) {
            value = this.headers.get(name);
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return this.typeConverter.convertTo(type, e, value);
        }
        return this.typeConverter.convertTo(type, value);
    }

    @Override
    public <T> T getHeader(String name, Object defaultValue, Class<T> type) {
        Object value = null;
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        if (!this.headers.isEmpty()) {
            value = this.headers.get(name);
        }
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return this.typeConverter.convertTo(type, e, value);
        }
        return this.typeConverter.convertTo(type, value);
    }

    @Override
    public <T> T getHeader(String name, Supplier<Object> defaultValueSupplier, Class<T> type) {
        Object value = this.getHeader(name, defaultValueSupplier);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            return this.typeConverter.convertTo(type, e, value);
        }
        return this.typeConverter.convertTo(type, value);
    }

    @Override
    public void setHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        this.headers.put(name, value);
    }

    @Override
    public Object removeHeader(String name) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        if (this.headers.isEmpty()) {
            return null;
        }
        return this.headers.remove(name);
    }

    @Override
    public boolean removeHeaders(String pattern) {
        return this.removeHeaders(pattern, null);
    }

    @Override
    public boolean removeHeaders(String pattern, String ... excludePatterns) {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        if (this.headers.isEmpty()) {
            return false;
        }
        if (excludePatterns == null && "*".equals(pattern)) {
            this.headers.clear();
            return true;
        }
        boolean matches = false;
        HashSet<String> toBeRemoved = null;
        for (String key : this.headers.keySet()) {
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            if (toBeRemoved == null) {
                toBeRemoved = new HashSet<String>();
            }
            toBeRemoved.add(key);
        }
        if (matches) {
            if (toBeRemoved.size() == this.headers.size()) {
                this.headers.clear();
            } else {
                for (String key : toBeRemoved) {
                    this.headers.remove(key);
                }
            }
        }
        return matches;
    }

    @Override
    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, Object> headers) {
        HeadersMapFactory factory = this.camelContext.getHeadersMapFactory();
        this.headers = factory != null ? (factory.isInstanceOf(headers) ? headers : this.camelContext.getHeadersMapFactory().newMap(headers)) : new HashMap<String, Object>(headers);
    }

    @Override
    public boolean hasHeaders() {
        if (this.headers == null) {
            this.headers = this.createHeaders();
        }
        return !this.headers.isEmpty();
    }

    @Override
    public DefaultMessage newInstance() {
        return new DefaultMessage(this.camelContext);
    }

    protected Map<String, Object> createHeaders() {
        HeadersMapFactory factory = this.camelContext.getHeadersMapFactory();
        Map<String, Object> map2 = factory != null ? factory.newMap() : new HashMap<String, Object>();
        this.populateInitialHeaders(map2);
        return map2;
    }

    protected void populateInitialHeaders(Map<String, Object> map2) {
    }

    protected Boolean isTransactedRedelivered() {
        return null;
    }

    protected boolean hasPopulatedHeaders() {
        return this.headers != null;
    }
}

