/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.support.SimpleRegistry;

public class SupplierRegistry
extends SimpleRegistry {
    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object value;
        Map map2 = (Map)this.get(name);
        if (map2 == null) {
            return null;
        }
        Object answer = map2.get(type);
        if (answer instanceof Supplier) {
            answer = ((Supplier)answer).get();
        }
        if (answer == null) {
            for (Map.Entry entry : map2.entrySet()) {
                if (!type.isAssignableFrom((Class)entry.getKey())) continue;
                value = entry.getValue();
                if (value instanceof Supplier) {
                    value = ((Supplier)value).get();
                }
                answer = value;
                break;
            }
        }
        if (answer == null) {
            for (Map.Entry entry : map2.entrySet()) {
                if (Object.class != entry.getKey()) continue;
                value = entry.getValue();
                if (value instanceof Supplier) {
                    value = ((Supplier)value).get();
                }
                if (!type.isInstance(value)) continue;
                answer = value;
                break;
            }
        }
        if (answer == null) {
            return null;
        }
        try {
            answer = this.unwrap(answer);
            return type.cast(answer);
        }
        catch (Throwable e) {
            String msg = "Found bean: " + name + " in SupplierRegistry: " + this + " of type: " + answer.getClass().getName() + " expected type was: " + type;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        LinkedHashSet<T> result2 = new LinkedHashSet<T>();
        for (Map.Entry entry : this.entrySet()) {
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                if (!type.isAssignableFrom((Class)subEntry.getKey())) continue;
                Object value = subEntry.getValue();
                if (value instanceof Supplier) {
                    value = ((Supplier)value).get();
                }
                result2.add(type.cast(value));
            }
        }
        return result2;
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry entry : this.entrySet()) {
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                if (!type.isAssignableFrom((Class)subEntry.getKey())) continue;
                Object value = subEntry.getValue();
                if (value instanceof Supplier) {
                    value = ((Supplier)value).get();
                }
                result2.put(entry.getKey(), type.cast(value));
            }
        }
        return result2;
    }

    @Override
    public void bind(String id, Class<?> type, Supplier<Object> bean) {
        if (bean != null) {
            this.computeIfAbsent(id, k -> new LinkedHashMap()).put(type, this.wrap(bean));
        }
    }
}

