/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ConstantExpressionAdapter;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.GroupIterator;
import org.apache.camel.support.GroupTokenIterator;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.builder.Namespaces;
import org.apache.camel.support.builder.TokenPairExpressionIterator;
import org.apache.camel.support.builder.TokenXMLExpressionIterator;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.StringHelper;

public class ExpressionBuilder {
    public static Expression headerExpression(String headerName) {
        return ExpressionBuilder.headerExpression(ExpressionBuilder.simpleExpression(headerName));
    }

    public static Expression headerExpression(final Expression headerName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = headerName.evaluate(exchange, String.class);
                Object header = exchange.getIn().getHeader(name);
                if (header == null) {
                    header = exchange.getProperty(name);
                }
                return header;
            }

            @Override
            public void init(CamelContext context) {
                headerName.init(context);
            }

            public String toString() {
                return "header(" + headerName + ")";
            }
        };
    }

    public static <T> Expression headerExpression(String headerName, Class<T> type) {
        return ExpressionBuilder.headerExpression(ExpressionBuilder.simpleExpression(headerName), ExpressionBuilder.constantExpression(type.getName()));
    }

    public static Expression headerExpression(String headerName, String typeName) {
        return ExpressionBuilder.headerExpression(ExpressionBuilder.simpleExpression(headerName), ExpressionBuilder.simpleExpression(typeName));
    }

    public static Expression headerExpression(final Expression headerName, final Expression typeName) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text;
                try {
                    text = typeName.evaluate(exchange, String.class);
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                text = headerName.evaluate(exchange, String.class);
                Object header = exchange.getIn().getHeader(text, type);
                if (header == null) {
                    header = exchange.getProperty(text, type);
                }
                return header;
            }

            @Override
            public void init(CamelContext context) {
                headerName.init(context);
                typeName.init(context);
                this.classResolver = context.getClassResolver();
            }

            public String toString() {
                return "headerAs(" + headerName + ", " + typeName + ")";
            }
        };
    }

    public static Expression headersExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeaders();
            }

            public String toString() {
                return "headers";
            }
        };
    }

    public static Expression exchangePatternExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getPattern();
            }

            public String toString() {
                return "exchangePattern";
            }
        };
    }

    public static Expression exchangeExceptionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException";
            }
        };
    }

    public static Expression exchangeExceptionExpression(final Class<Exception> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = (Exception)exchange.getException(type);
                if (exception == null) {
                    exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
                    return ObjectHelper.getException(type, exception);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException[" + type + "]";
            }
        };
    }

    public static Expression typeConverterExpression() {
        return new ExpressionAdapter(){
            private TypeConverter typeConverter;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.typeConverter;
            }

            @Override
            public void init(CamelContext context) {
                this.typeConverter = context.getTypeConverter();
            }

            public String toString() {
                return "typeConverter";
            }
        };
    }

    public static Expression registryExpression() {
        return new ExpressionAdapter(){
            private Registry registry;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.registry;
            }

            @Override
            public void init(CamelContext context) {
                this.registry = context.getRegistry();
            }

            public String toString() {
                return "registry";
            }
        };
    }

    public static Expression refExpression(String ref) {
        if (LanguageSupport.hasSimpleFunction(ref)) {
            return ExpressionBuilder.refExpression(ExpressionBuilder.simpleExpression(ref));
        }
        return ExpressionBuilder.refExpression(ExpressionBuilder.constantExpression(ref));
    }

    public static Expression refExpression(final Expression ref) {
        return new ExpressionAdapter(){
            private Registry registry;

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ref.evaluate(exchange, String.class);
                return this.registry.lookupByName(text);
            }

            @Override
            public void init(CamelContext context) {
                ref.init(context);
                this.registry = context.getRegistry();
            }

            public String toString() {
                return "ref(" + ref + ")";
            }
        };
    }

    public static Expression camelContextExpression() {
        return new ExpressionAdapter(){
            private CamelContext context;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.context;
            }

            @Override
            public void init(CamelContext context) {
                this.context = context;
            }

            public String toString() {
                return "camelContext";
            }
        };
    }

    public static Expression camelContextNameExpression() {
        return new ConstantExpressionAdapter(){
            private String name;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.name;
            }

            @Override
            public void init(CamelContext context) {
                this.name = context.getName();
                this.setValue(this.name);
            }

            public String toString() {
                return "camelContextName";
            }
        };
    }

    public static Expression exchangeExceptionMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
                }
                return exception != null ? exception.getMessage() : null;
            }

            public String toString() {
                return "exchangeExceptionMessage";
            }
        };
    }

    public static Expression exchangeExceptionStackTraceExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
                }
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    IOHelper.close(pw, sw);
                    return sw.toString();
                }
                return null;
            }

            public String toString() {
                return "exchangeExceptionStackTrace";
            }
        };
    }

    public static Expression exchangePropertyExpression(String propertyName) {
        return ExpressionBuilder.exchangePropertyExpression(ExpressionBuilder.simpleExpression(propertyName));
    }

    public static Expression exchangePropertyExpression(final Expression propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = propertyName.evaluate(exchange, String.class);
                return exchange.getProperty(text);
            }

            @Override
            public void init(CamelContext context) {
                propertyName.init(context);
            }

            public String toString() {
                return "exchangeProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression exchangePropertiesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getProperties();
            }

            public String toString() {
                return "exchangeProperties";
            }
        };
    }

    public static Expression camelContextPropertiesExpression() {
        return new ExpressionAdapter(){
            private Map<String, String> globalOptions;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.globalOptions;
            }

            @Override
            public void init(CamelContext context) {
                this.globalOptions = context.getGlobalOptions();
            }

            public String toString() {
                return "camelContextProperties";
            }
        };
    }

    public static Expression camelContextPropertyExpression(String propertyName) {
        return ExpressionBuilder.camelContextPropertyExpression(ExpressionBuilder.simpleExpression(propertyName));
    }

    public static Expression camelContextPropertyExpression(final Expression propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = propertyName.evaluate(exchange, String.class);
                return exchange.getContext().getGlobalOption(text);
            }

            @Override
            public void init(CamelContext context) {
                propertyName.init(context);
            }

            public String toString() {
                return "camelContextProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression systemPropertyExpression(String propertyName) {
        return ExpressionBuilder.systemPropertyExpression(propertyName, null);
    }

    public static Expression systemPropertyExpression(String propertyName, String defaultValue) {
        Expression exprName = ExpressionBuilder.simpleExpression(propertyName);
        Expression exprDefault = ExpressionBuilder.simpleExpression(defaultValue);
        return ExpressionBuilder.systemPropertyExpression(exprName, exprDefault);
    }

    public static Expression systemPropertyExpression(final Expression exprName, final Expression defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = exprName.evaluate(exchange, String.class);
                String text2 = defaultValue.evaluate(exchange, String.class);
                return System.getProperty(text, text2);
            }

            @Override
            public void init(CamelContext context) {
                exprName.init(context);
                defaultValue.init(context);
            }

            public String toString() {
                return "systemProperty(" + exprName + ")";
            }
        };
    }

    public static Expression systemEnvironmentExpression(String propertyName) {
        return ExpressionBuilder.systemEnvironmentExpression(propertyName, null);
    }

    public static Expression systemEnvironmentExpression(String propertyName, String defaultValue) {
        Expression exprName = ExpressionBuilder.simpleExpression(propertyName);
        Expression expDefault = ExpressionBuilder.simpleExpression(defaultValue);
        return ExpressionBuilder.systemEnvironmentExpression(exprName, expDefault);
    }

    public static Expression systemEnvironmentExpression(final Expression propertyName, final Expression defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = propertyName.evaluate(exchange, String.class);
                String answer = null;
                if (text != null && (answer = System.getenv(text = text.toUpperCase())) == null) {
                    String noDashKey = text.replace('-', '_');
                    answer = System.getenv(noDashKey);
                }
                if (answer == null) {
                    answer = defaultValue.evaluate(exchange, String.class);
                }
                return answer;
            }

            @Override
            public void init(CamelContext context) {
                propertyName.init(context);
                defaultValue.init(context);
            }

            public String toString() {
                return "systemEnvironment(" + propertyName + ")";
            }
        };
    }

    public static Expression constantExpression(final Object value) {
        return new ConstantExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return value;
            }

            @Override
            public void init(CamelContext context) {
                this.setValue(value);
            }

            public String toString() {
                return "" + value;
            }
        };
    }

    public static Expression languageExpression(final String languageName, final Language language2, final String expression) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = language2.createExpression(expression);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            public String toString() {
                return languageName + "(" + expression + ")";
            }
        };
    }

    public static Expression languageExpression(final String language2, final String expression) {
        return new ExpressionAdapter(){
            private Expression expr;
            private Predicate pred;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.expr.evaluate(exchange, Object.class);
            }

            @Override
            public boolean matches(Exchange exchange) {
                return this.pred.matches(exchange);
            }

            @Override
            public void init(CamelContext context) {
                Language lan = context.resolveLanguage(language2);
                if (lan == null) {
                    throw new NoSuchLanguageException(language2);
                }
                this.pred = lan.createPredicate(expression);
                this.pred.init(context);
                this.expr = lan.createExpression(expression);
                this.expr.init(context);
            }

            public String toString() {
                return "language[" + language2 + ":" + expression + "]";
            }
        };
    }

    public static Expression bodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "body";
            }
        };
    }

    public static Expression bodyExpression(final Function<Object, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody());
            }

            public String toString() {
                return "bodyExpression";
            }
        };
    }

    public static Expression bodyExpression(final BiFunction<Object, Map<String, Object>, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(), exchange.getIn().getHeaders());
            }

            public String toString() {
                return "bodyExpression";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> bodyType, final Function<T, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(bodyType));
            }

            public String toString() {
                return "bodyExpression (" + bodyType + ")";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> bodyType, final BiFunction<T, Map<String, Object>, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(bodyType), exchange.getIn().getHeaders());
            }

            public String toString() {
                return "bodyExpression (" + bodyType + ")";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyExpression(String name) {
        return ExpressionBuilder.bodyExpression(ExpressionBuilder.simpleExpression(name));
    }

    public static Expression bodyExpression(final Expression name) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                try {
                    String text = name.evaluate(exchange, String.class);
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                return exchange.getIn().getBody(type);
            }

            @Override
            public void init(CamelContext context) {
                name.init(context);
                this.classResolver = context.getClassResolver();
            }

            public String toString() {
                return "bodyAs[" + name + "]";
            }
        };
    }

    public static Expression threadNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return Thread.currentThread().getName();
            }

            public String toString() {
                return "threadName";
            }
        };
    }

    public static Expression hostnameExpression() {
        return new ConstantExpressionAdapter(){
            private String hostname;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.hostname;
            }

            @Override
            public void init(CamelContext context) {
                this.hostname = InetAddressUtil.getLocalHostNameSafe();
                this.setValue(this.hostname);
            }

            public String toString() {
                return "hostname";
            }
        };
    }

    public static Expression stepIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getProperty(ExchangePropertyKey.STEP_ID);
            }

            public String toString() {
                return "stepId";
            }
        };
    }

    public static <T> Expression mandatoryBodyExpression(Class<T> type) {
        return ExpressionBuilder.mandatoryBodyExpression(type, false);
    }

    public static <T> Expression mandatoryBodyExpression(final Class<T> type, final boolean nullBodyAllowed) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (nullBodyAllowed && exchange.getIn().getBody() == null) {
                    return null;
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
            }

            public String toString() {
                return "mandatoryBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyTypeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object body = exchange.getIn().getBody();
                return body != null ? body.getClass() : null;
            }

            public String toString() {
                return "bodyType";
            }
        };
    }

    public static Expression exchangeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange;
            }

            public String toString() {
                return "exchange";
            }
        };
    }

    public static Expression exchangeExpression(final Function<Exchange, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange);
            }

            public String toString() {
                return "exchangeExpression";
            }
        };
    }

    public static Expression messageExpression() {
        return ExpressionBuilder.inMessageExpression();
    }

    public static Expression messageExpression(Function<Message, Object> function) {
        return ExpressionBuilder.inMessageExpression(function);
    }

    public static Expression inMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn();
            }

            public String toString() {
                return "inMessage";
            }
        };
    }

    public static Expression inMessageExpression(final Function<Message, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn());
            }

            public String toString() {
                return "inMessageExpression";
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Class<?> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (type != null) {
                    return expression.evaluate(exchange, type);
                }
                return expression;
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
            }

            public String toString() {
                return "" + expression;
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Expression type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object result2 = type.evaluate(exchange, Object.class);
                if (result2 != null) {
                    return expression.evaluate(exchange, result2.getClass());
                }
                return expression;
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
                type.init(context);
            }

            public String toString() {
                return "" + expression;
            }
        };
    }

    public static Expression tokenizeExpression(Expression expression, String token) {
        return ExpressionBuilder.tokenizeExpression(expression, ExpressionBuilder.simpleExpression(token));
    }

    public static Expression tokenizeExpression(final Expression expression, final Expression token) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = token.evaluate(exchange, String.class);
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ExchangeHelper.getScanner(exchange, value, text);
                return scanner;
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
                token.init(context);
            }

            public String toString() {
                return "tokenize(" + expression + ", " + token + ")";
            }
        };
    }

    public static Expression skipFirstExpression(final Expression expression) {
        return new ExpressionAdapter(){
            private TypeConverter typeConverter;

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Iterator it = this.typeConverter.tryConvertTo(Iterator.class, exchange, value);
                if (it != null) {
                    it.next();
                    return it;
                }
                return value;
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
                this.typeConverter = context.getTypeConverter();
            }

            public String toString() {
                return "skipFirst(" + expression + ")";
            }
        };
    }

    public static Expression regexTokenizeExpression(final Expression expression, final String regexTokenizer) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ExchangeHelper.getScanner(exchange, value, regexTokenizer);
                return scanner;
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
            }

            public String toString() {
                return "regexTokenize(" + expression + ", " + regexTokenizer + ")";
            }
        };
    }

    public static Expression groupXmlIteratorExpression(final Expression expression, final String group2) {
        return new ExpressionAdapter(){
            private Expression groupExp;

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + expression + " evaluated on " + exchange + " must return an java.util.Iterator");
                Integer parts = this.groupExp.evaluate(exchange, Integer.class);
                if (parts == null) {
                    throw new RuntimeExchangeException("Group evaluated as null, must be evaluated as a positive Integer value from expression: " + group2, exchange);
                }
                if (parts <= 0) {
                    throw new RuntimeExchangeException("Group must be a positive number, was: " + parts, exchange);
                }
                return new GroupTokenIterator(exchange, it, null, parts, false);
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
                this.groupExp = context.resolveLanguage("simple").createExpression(group2);
                this.groupExp.init(context);
            }

            public String toString() {
                return "group " + expression + " " + group2 + " times";
            }
        };
    }

    public static Expression groupIteratorExpression(final Expression expression, final String token, final String group2, final boolean skipFirst) {
        return new ExpressionAdapter(){
            private Expression groupExp;

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + expression + " evaluated on " + exchange + " must return an java.util.Iterator");
                Integer parts = this.groupExp.evaluate(exchange, Integer.class);
                if (parts == null) {
                    throw new RuntimeExchangeException("Group evaluated as null, must be evaluated as a positive Integer value from expression: " + group2, exchange);
                }
                if (parts <= 0) {
                    throw new RuntimeExchangeException("Group must be a positive number, was: " + parts, exchange);
                }
                if (token != null) {
                    return new GroupTokenIterator(exchange, it, token, parts, skipFirst);
                }
                return new GroupIterator(exchange, it, parts, skipFirst);
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
                this.groupExp = context.resolveLanguage("simple").createExpression(group2);
                this.groupExp.init(context);
            }

            public String toString() {
                return "group " + expression + " " + group2 + " times";
            }
        };
    }

    public static Expression sortExpression(final Expression expression, final Comparator comparator) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                List list2 = expression.evaluate(exchange, List.class);
                list2.sort(comparator);
                return list2;
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
            }

            public String toString() {
                return "sort(" + expression + " by: " + comparator + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final String replacement) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                if (text == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final Expression replacementExpression) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                String replacement = replacementExpression.evaluate(exchange, String.class);
                if (text == null || replacement == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            @Override
            public void init(CamelContext context) {
                expression.init(context);
                replacementExpression.init(context);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression append(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return left.evaluate(exchange, String.class) + right.evaluate(exchange, String.class);
            }

            @Override
            public void init(CamelContext context) {
                left.init(context);
                right.init(context);
            }

            public String toString() {
                return "append(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression prepend(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return right.evaluate(exchange, String.class) + left.evaluate(exchange, String.class);
            }

            @Override
            public void init(CamelContext context) {
                left.init(context);
                right.init(context);
            }

            public String toString() {
                return "prepend(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression concatExpression(Collection<Expression> expressions) {
        return ExpressionBuilder.concatExpression(expressions, null);
    }

    public static Expression concatExpression(final Collection<Expression> expressions, final String description) {
        return new ExpressionAdapter(){
            private Collection<Object> col;

            @Override
            public Object evaluate(Exchange exchange) {
                StringBuilder buffer = new StringBuilder();
                if (this.col != null) {
                    for (Object obj : this.col) {
                        if (obj instanceof Expression) {
                            Expression expression = (Expression)obj;
                            String text = expression.evaluate(exchange, String.class);
                            if (text == null) continue;
                            buffer.append(text);
                            continue;
                        }
                        buffer.append((String)obj);
                    }
                } else {
                    for (Expression expression : expressions) {
                        String text = expression.evaluate(exchange, String.class);
                        if (text == null) continue;
                        buffer.append(text);
                    }
                }
                return buffer.toString();
            }

            @Override
            public void init(CamelContext context) {
                boolean constant = false;
                for (Expression expression : expressions) {
                    expression.init(context);
                    constant |= expression instanceof ConstantExpressionAdapter;
                }
                if (constant) {
                    this.col = new ArrayList<Object>(expressions.size());
                    for (Expression expression : expressions) {
                        if (expression instanceof ConstantExpressionAdapter) {
                            Object value = ((ConstantExpressionAdapter)expression).getValue();
                            this.col.add(value.toString());
                            continue;
                        }
                        this.col.add(expression);
                    }
                }
            }

            public String toString() {
                if (description != null) {
                    return description;
                }
                return "concat(" + expressions + ")";
            }
        };
    }

    public static Expression messageIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getMessageId();
            }

            public String toString() {
                return "messageId";
            }
        };
    }

    public static Expression messageTimestampExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getMessageTimestamp();
            }

            public String toString() {
                return "messageTimestamp";
            }
        };
    }

    public static Expression exchangeIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getExchangeId();
            }

            public String toString() {
                return "exchangeId";
            }
        };
    }

    public static Expression routeIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return ExchangeHelper.getRouteId(exchange);
            }

            public String toString() {
                return "routeId";
            }
        };
    }

    public static Expression simpleExpression(final String expression) {
        if (LanguageSupport.hasSimpleFunction(expression)) {
            return new ExpressionAdapter(){
                private Expression exp;
                private Language language;

                @Override
                public Object evaluate(Exchange exchange) {
                    return this.exp.evaluate(exchange, Object.class);
                }

                @Override
                public void init(CamelContext context) {
                    this.language = context.resolveLanguage("simple");
                    this.exp = this.language.createExpression(expression);
                    this.exp.init(context);
                }

                public String toString() {
                    return "simple(" + expression + ")";
                }
            };
        }
        return ExpressionBuilder.constantExpression(expression);
    }

    public static Expression beanExpression(final String expression) {
        return new ExpressionAdapter(){
            private Expression exp;
            private Language language;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.language = context.resolveLanguage("bean");
                this.exp = this.language.createExpression(expression);
                this.exp.init(context);
            }

            public String toString() {
                return "bean(" + expression + ")";
            }
        };
    }

    public static Expression beanExpression(final Object bean, final String method) {
        return new ExpressionAdapter(){
            private Language language;
            private Expression exp;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.language = context.resolveLanguage("bean");
                this.exp = this.language.createExpression(null, new Object[]{bean, method});
                this.exp.init(context);
            }

            public String toString() {
                return "bean(" + bean + ", " + method + ")";
            }
        };
    }

    public static Expression propertiesComponentExpression(final String key, final String defaultValue) {
        return new ExpressionAdapter(){
            private Expression exp;
            private PropertiesComponent pc;

            @Override
            public Object evaluate(Exchange exchange) {
                String text = this.exp.evaluate(exchange, String.class);
                try {
                    return this.pc.parseUri("{{" + text + "}}");
                }
                catch (Exception e) {
                    if (defaultValue != null) {
                        return defaultValue;
                    }
                    throw RuntimeCamelException.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public void init(CamelContext context) {
                this.exp = ExpressionBuilder.simpleExpression(key);
                this.exp.init(context);
                this.pc = context.getPropertiesComponent();
            }

            public String toString() {
                return "properties(" + key + ")";
            }
        };
    }

    public static Expression tokenizePairExpression(String startToken, String endToken, boolean includeTokens) {
        return new TokenPairExpressionIterator(startToken, endToken, includeTokens);
    }

    public static Expression tokenizeXMLExpression(String tagName, String inheritNamespaceTagName) {
        StringHelper.notEmpty(tagName, "tagName");
        return new TokenXMLExpressionIterator(tagName, inheritNamespaceTagName);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode) {
        return ExpressionBuilder.tokenizeXMLAwareExpression(null, path, mode, 1, null);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode, int group2) {
        return ExpressionBuilder.tokenizeXMLAwareExpression(null, path, mode, group2, null);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode, int group2, Namespaces namespaces) {
        return ExpressionBuilder.tokenizeXMLAwareExpression(null, path, mode, group2, namespaces);
    }

    public static Expression tokenizeXMLAwareExpression(final String headerName, final String path, final char mode, final int group2, final Namespaces namespaces) {
        StringHelper.notEmpty(path, "path");
        return new ExpressionAdapter(){
            private Language language;
            private Expression exp;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.language = context.resolveLanguage("xtokenize");
                this.exp = this.language.createExpression(path, new Object[]{headerName, Character.valueOf(mode), group2, namespaces});
                this.exp.init(context);
            }

            public String toString() {
                return "xtokenize(" + path + ")";
            }
        };
    }

    public static Expression bodyOneLine() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String body = exchange.getIn().getBody(String.class);
                if (body == null) {
                    return null;
                }
                body = StringHelper.replaceAll(body, System.lineSeparator(), "");
                return body;
            }

            public String toString() {
                return "bodyOneLine()";
            }
        };
    }
}

