/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.URISupport;

public abstract class SendDynamicAwareSupport
extends ServiceSupport
implements SendDynamicAware {
    private CamelContext camelContext;
    private Set<String> knownProperties;
    private String scheme;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public boolean resolveRawParameterValues() {
        return true;
    }

    @Override
    protected void doInit() throws Exception {
        if (this.knownProperties == null) {
            EndpointUriFactory factory = this.getCamelContext().adapt(ExtendedCamelContext.class).getEndpointUriFactory(this.getScheme());
            if (factory == null) {
                throw new IllegalStateException("Cannot find EndpointUriFactory for component: " + this.getScheme());
            }
            this.knownProperties = factory.propertyNames();
        }
    }

    public Map<String, Object> endpointProperties(Exchange exchange, String uri) throws Exception {
        Map<String, Object> properties;
        Map<String, Object> map2 = URISupport.parseQuery(URISupport.extractQuery(uri));
        if (map2 != null && !map2.isEmpty() && this.isLenientProperties()) {
            if (this.resolveRawParameterValues()) {
                URISupport.resolveRawParameterValues(map2);
            }
            properties = new LinkedHashMap<String, Object>();
            map2.forEach((k, v) -> {
                if (this.knownProperties.contains(k)) {
                    properties.put((String)k, v);
                }
            });
        } else {
            properties = map2;
        }
        return properties;
    }

    public Map<String, Object> endpointLenientProperties(Exchange exchange, String uri) throws Exception {
        Map<String, Object> properties;
        Map<String, Object> map2 = URISupport.parseQuery(URISupport.extractQuery(uri));
        if (map2 != null && !map2.isEmpty()) {
            if (this.resolveRawParameterValues()) {
                URISupport.resolveRawParameterValues(map2);
            }
            properties = new LinkedHashMap<String, Object>();
            map2.forEach((k, v) -> {
                if (!this.knownProperties.contains(k)) {
                    properties.put((String)k, v.toString());
                }
            });
        } else {
            properties = map2;
        }
        return properties;
    }

    public String asEndpointUri(Exchange exchange, String uri, Map<String, Object> properties) throws Exception {
        String query = URISupport.createQueryString(properties, false);
        int pos = uri.indexOf(63);
        String answer = pos != -1 ? uri.substring(0, pos) + "?" + query : uri + "?" + query;
        return answer;
    }
}

