/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.NodeList;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static Integer size(Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return collection.size();
            }
            if (value instanceof Map) {
                Map map2 = (Map)value;
                return map2.size();
            }
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                return array.length;
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value);
            }
            if (value instanceof NodeList) {
                NodeList nodeList = (NodeList)value;
                return nodeList.getLength();
            }
        }
        return null;
    }

    public static void appendValue(Map<String, Object> map2, String key, Object value) {
        Object oldValue = map2.get(key);
        if (oldValue != null) {
            ArrayList<Object> list2;
            if (oldValue instanceof List) {
                list2 = (ArrayList<Object>)oldValue;
            } else {
                list2 = new ArrayList<Object>();
                list2.add(oldValue);
                map2.remove(key);
                map2.put(key, list2);
            }
            list2.add(value);
        } else {
            map2.put(key, value);
        }
    }

    @SafeVarargs
    public static <T> Set<T> createSetContaining(T ... contents) {
        return new HashSet<T>(Arrays.asList(contents));
    }

    public static String collectionAsCommaDelimitedString(Collection<?> col) {
        if (col == null || col.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = col.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static Map<String, Object> flattenKeysInMap(Map<String, Object> map2, String separator) {
        LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>();
        CollectionHelper.doFlattenKeysInMap(map2, "", ObjectHelper.isNotEmpty(separator) ? separator : "", answer);
        return answer;
    }

    private static void doFlattenKeysInMap(Map<String, Object> source, String prefix, String separator, Map<String, Object> target) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String newKey;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string2 = newKey = prefix.isEmpty() ? key : prefix + separator + key;
            if (value instanceof Map) {
                Map map2 = (Map)value;
                CollectionHelper.doFlattenKeysInMap(map2, newKey, separator, target);
                continue;
            }
            target.put(newKey, value);
        }
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map2) {
        return map2 == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<K, V>(map2));
    }

    public static <K, V> Map<K, V> mapOf(Supplier<Map<K, V>> creator, K key, V value, Object ... keyVals) {
        Map<Object, Object> map2 = creator.get();
        map2.put(key, value);
        for (int i = 0; i < keyVals.length; i += 2) {
            map2.put(keyVals[i], keyVals[i + 1]);
        }
        return map2;
    }

    public static <K, V> Map<K, V> immutableMapOf(Supplier<Map<K, V>> creator, K key, V value, Object ... keyVals) {
        return Collections.unmodifiableMap(CollectionHelper.mapOf(creator, key, value, keyVals));
    }

    public static <K, V> Map<K, V> mapOf(K key, V value, Object ... keyVals) {
        return CollectionHelper.mapOf(HashMap::new, key, value, keyVals);
    }

    public static <K, V> Map<K, V> immutableMapOf(K key, V value, Object ... keyVals) {
        return Collections.unmodifiableMap(CollectionHelper.mapOf(HashMap::new, key, value, keyVals));
    }

    public static Properties propertiesOf(String key, String value, String ... keyVals) {
        Properties properties = new Properties();
        properties.setProperty(key, value);
        for (int i = 0; i < keyVals.length; i += 2) {
            properties.setProperty(keyVals[i], keyVals[i + 1]);
        }
        return properties;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mergeMaps(Map<K, V> map2, Map<K, V> ... maps) {
        HashMap<K, V> answer = new HashMap<K, V>();
        if (map2 != null) {
            answer.putAll(map2);
        }
        for (Map<K, V> m : maps) {
            answer.putAll(m);
        }
        return answer;
    }
}

