/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObjectHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectHelper.class);
    private static final Float FLOAT_NAN = Float.valueOf(Float.NaN);
    private static final Double DOUBLE_NAN = Double.NaN;

    private ObjectHelper() {
    }

    public static boolean equal(Object a, Object b) {
        return ObjectHelper.equal(a, b, false);
    }

    public static boolean equalIgnoreCase(Object a, Object b) {
        return ObjectHelper.equal(a, b, true);
    }

    public static boolean equal(Object a, Object b, boolean ignoreCase) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (ignoreCase && a instanceof String && b instanceof String) {
            return ((String)a).equalsIgnoreCase((String)b);
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            return Objects.deepEquals(a, b);
        }
        return a.equals(b);
    }

    public static boolean equalByteArray(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean isEqualToAny(Object object, Object ... values) {
        for (Object value : values) {
            if (!ObjectHelper.equal(object, value)) continue;
            return true;
        }
        return false;
    }

    public static Boolean toBoolean(Object value) {
        String str;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String && ("true".equalsIgnoreCase(str = (String)value) || "false".equalsIgnoreCase(str))) {
            return Boolean.valueOf(str);
        }
        if (value instanceof Integer) {
            return (Integer)value > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public static <T> T notNull(T value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(name + " must be specified");
        }
        return value;
    }

    public static <T> T notNull(T value, String name, Object on) {
        if (on == null) {
            ObjectHelper.notNull(value, name);
        } else if (value == null) {
            throw new IllegalArgumentException(name + " must be specified on: " + on);
        }
        return value;
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).trim().isEmpty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        return false;
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            return !((String)value).trim().isEmpty();
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        return true;
    }

    public static Optional<Object> firstNotNull(Object ... values) {
        for (Object value : values) {
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static <T> T supplyIfEmpty(T value, Supplier<T> supplier) {
        ObjectHelper.notNull(supplier, "Supplier");
        if (ObjectHelper.isNotEmpty(value)) {
            return value;
        }
        return supplier.get();
    }

    public static <T> void ifNotEmpty(T value, Consumer<T> consumer) {
        if (ObjectHelper.isNotEmpty(value)) {
            consumer.accept(value);
        }
    }

    public static boolean matches(List<?> list2) {
        if (!list2.isEmpty()) {
            Object value = list2.get(0);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return true;
        }
        return false;
    }

    public static String getSystemProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (Exception e) {
            LOG.debug("Caught security exception accessing system property: {}. Will use default value: {}", new Object[]{name, defaultValue, e});
            return defaultValue;
        }
    }

    public static boolean getSystemProperty(String name, Boolean defaultValue) {
        String result2 = ObjectHelper.getSystemProperty(name, defaultValue.toString());
        return Boolean.parseBoolean(result2);
    }

    public static String name(Class<?> type) {
        return type != null ? type.getName() : null;
    }

    public static String className(Object value) {
        return ObjectHelper.name(value != null ? value.getClass() : null);
    }

    public static String classCanonicalName(Object value) {
        if (value != null) {
            return value.getClass().getCanonicalName();
        }
        return null;
    }

    public static Class<?> loadClass(String name) {
        return ObjectHelper.loadClass(name, ObjectHelper.class.getClassLoader());
    }

    public static Class<?> loadClass(String name, ClassLoader loader) {
        return ObjectHelper.loadClass(name, loader, false);
    }

    public static Class<?> loadClass(String name, ClassLoader loader, boolean needToWarn) {
        if (ObjectHelper.isEmpty(name = StringHelper.normalizeClassName(name))) {
            return null;
        }
        boolean array = false;
        Class<?> clazz = ObjectHelper.loadSimpleType(name);
        if (clazz == null && name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
            array = true;
        }
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, Thread.currentThread().getContextClassLoader());
        }
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, loader);
        }
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, ObjectHelper.class.getClassLoader());
        }
        if (clazz != null && array) {
            Object arr = Array.newInstance(clazz, 0);
            clazz = arr.getClass();
        }
        if (clazz == null) {
            if (needToWarn) {
                LOG.warn("Cannot find class: {}", (Object)name);
            } else {
                LOG.debug("Cannot find class: {}", (Object)name);
            }
        }
        return clazz;
    }

    public static Class<?> loadSimpleType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return byte[].class;
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return Byte[].class;
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return Object[].class;
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return String[].class;
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return String.class;
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return Boolean.class;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return Integer.class;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return Long.class;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return Short.class;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return Byte.class;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return Float.class;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return Double.class;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name)) {
            return Character.class;
        }
        if ("char".equals(name)) {
            return Character.TYPE;
        }
        return null;
    }

    private static Class<?> doLoadClass(String name, ClassLoader loader) {
        StringHelper.notEmpty(name, "name");
        if (loader == null) {
            return null;
        }
        try {
            LOG.trace("Loading class: {} using classloader: {}", (Object)name, (Object)loader);
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cannot load class: {} using classloader: {}", new Object[]{name, loader, e});
            }
            return null;
        }
    }

    public static InputStream loadResourceAsStream(String name) {
        return ObjectHelper.loadResourceAsStream(name, null);
    }

    public static InputStream loadResourceAsStream(String name, ClassLoader loader) {
        try {
            URL res = ObjectHelper.loadResourceAsURL(name, loader);
            return res != null ? res.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL loadResourceAsURL(String name) {
        return ObjectHelper.loadResourceAsURL(name, null);
    }

    public static URL loadResourceAsURL(String name, ClassLoader loader) {
        URL url = null;
        String resolvedName = ObjectHelper.resolveUriPath(name);
        if (loader != null && (url = loader.getResource(resolvedName)) != null) {
            return url;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            url = tccl.getResource(resolvedName);
            if (url != null) {
                return url;
            }
            try {
                Class<?> clazz = tccl.loadClass("org.apache.camel.impl.DefaultCamelContext");
                url = clazz.getClassLoader().getResource(resolvedName);
                if (url != null) {
                    return url;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((url = ObjectHelper.class.getClassLoader().getResource(resolvedName)) != null) {
            return url;
        }
        url = ObjectHelper.class.getResource(resolvedName);
        return url;
    }

    public static Enumeration<URL> loadResourcesAsURL(String uri) {
        return ObjectHelper.loadResourcesAsURL(uri, null);
    }

    public static Enumeration<URL> loadResourcesAsURL(String uri, ClassLoader loader) {
        ClassLoader tccl;
        Enumeration<URL> res = null;
        if (loader != null) {
            try {
                res = loader.getResources(uri);
                if (res != null) {
                    return res;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((tccl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                res = tccl.getResources(uri);
                if (res != null) {
                    return res;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Class<?> clazz = tccl.loadClass("org.apache.camel.impl.DefaultCamelContext");
                res = clazz.getClassLoader().getResources(uri);
                if (res != null) {
                    return res;
                }
            }
            catch (IOException | ClassNotFoundException exception) {
                // empty catch block
            }
        }
        try {
            res = ObjectHelper.class.getClassLoader().getResources(uri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    private static String resolveUriPath(String name) {
        return FileUtil.compactPath(name, '/');
    }

    public static boolean isOverridingMethod(Method source, Method target) {
        return ObjectHelper.isOverridingMethod(source, target, true);
    }

    public static boolean isOverridingMethod(Method source, Method target, boolean exact) {
        return ObjectHelper.isOverridingMethod(target.getDeclaringClass(), source, target, exact);
    }

    public static boolean isOverridingMethod(Class<?> inheritingClass, Method source, Method target, boolean exact) {
        if (source.equals(target)) {
            return true;
        }
        if (target.getDeclaringClass().isAssignableFrom(source.getDeclaringClass())) {
            return false;
        }
        if (!source.getDeclaringClass().isAssignableFrom(inheritingClass) || !target.getDeclaringClass().isAssignableFrom(inheritingClass)) {
            return false;
        }
        if (!source.getName().equals(target.getName())) {
            return false;
        }
        if (exact) {
            if (!source.getReturnType().equals(target.getReturnType())) {
                return false;
            }
        } else if (!source.getReturnType().isAssignableFrom(target.getReturnType())) {
            boolean b1 = source.isBridge();
            boolean b2 = target.isBridge();
            if (!b1 && !b2) {
                return false;
            }
        }
        if (source.getParameterCount() != target.getParameterCount()) {
            return false;
        }
        Class<?>[] sourceTypes = source.getParameterTypes();
        Class<?>[] targetTypes = target.getParameterTypes();
        for (int i = 0; i < source.getParameterCount(); ++i) {
            if (exact) {
                if (sourceTypes[i].equals(targetTypes[i])) continue;
                return false;
            }
            if (sourceTypes[i].isAssignableFrom(targetTypes[i])) continue;
            boolean b1 = source.isBridge();
            boolean b2 = target.isBridge();
            if (b1 || b2) continue;
            return false;
        }
        return true;
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        return ObjectHelper.findMethodsWithAnnotation(type, annotationType, false);
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        ArrayList<Method> answer = new ArrayList<Method>();
        do {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                if (!ObjectHelper.hasAnnotation(method, annotationType, checkMetaAnnotations)) continue;
                answer.add(method);
            }
        } while ((type = type.getSuperclass()) != null);
        return answer;
    }

    public static boolean hasAnnotation(AnnotatedElement elem, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        if (elem.isAnnotationPresent(annotationType)) {
            return true;
        }
        if (checkMetaAnnotations) {
            for (Annotation a : elem.getAnnotations()) {
                for (Annotation meta : a.annotationType().getAnnotations()) {
                    if (!meta.annotationType().getName().equals(annotationType.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String asString(Object[] objects) {
        if (objects == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder("{");
        int counter = 0;
        for (Object object : objects) {
            if (counter++ > 0) {
                buffer.append(", ");
            }
            String text = object == null ? "null" : object.toString();
            buffer.append(text);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static boolean isAssignableFrom(Class<?> a, Class<?> b) {
        a = ObjectHelper.convertPrimitiveTypeToWrapperType(a);
        b = ObjectHelper.convertPrimitiveTypeToWrapperType(b);
        return a.isAssignableFrom(b);
    }

    public static boolean isPrimitiveArrayType(Class<?> clazz) {
        if (clazz != null && clazz.isArray()) {
            return clazz.getComponentType().isPrimitive();
        }
        return false;
    }

    public static int arrayLength(Object[] pojo) {
        return pojo.length;
    }

    public static Class<?> convertPrimitiveTypeToWrapperType(Class<?> type) {
        Class<Object> rc = type;
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                rc = Integer.class;
            } else if (type == Long.TYPE) {
                rc = Long.class;
            } else if (type == Double.TYPE) {
                rc = Double.class;
            } else if (type == Float.TYPE) {
                rc = Float.class;
            } else if (type == Short.TYPE) {
                rc = Short.class;
            } else if (type == Byte.TYPE) {
                rc = Byte.class;
            } else if (type == Boolean.TYPE) {
                rc = Boolean.class;
            } else if (type == Character.TYPE) {
                rc = Character.class;
            }
        }
        return rc;
    }

    public static String getDefaultCharacterSet() {
        return Charset.defaultCharset().name();
    }

    public static String getPropertyName(Method method) {
        String propertyName = method.getName();
        if (propertyName.startsWith("set") && method.getParameterCount() == 1) {
            propertyName = propertyName.substring(3, 4).toLowerCase(Locale.ENGLISH) + propertyName.substring(4);
        }
        return propertyName;
    }

    public static boolean hasAnnotation(Annotation[] annotations, Class<?> type) {
        for (Annotation annotation : annotations) {
            if (!type.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public static <A extends Annotation> A getAnnotation(Object instance, Class<A> type) {
        return instance.getClass().getAnnotation(type);
    }

    public static <T> T cast(Class<T> toType, Object value) {
        Class<?> newType;
        if (toType == Boolean.TYPE) {
            return (T)ObjectHelper.cast(Boolean.class, value);
        }
        if (toType.isPrimitive() && (newType = ObjectHelper.convertPrimitiveTypeToWrapperType(toType)) != toType) {
            return (T)ObjectHelper.cast(newType, value);
        }
        try {
            return toType.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Failed to convert: " + value + " to type: " + toType.getName() + " due to: " + e, e);
        }
    }

    public static boolean hasDefaultPublicNoArgConstructor(Class<?> type) {
        for (Constructor<?> ctr : type.getConstructors()) {
            if (ctr.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    public static Object type(Object bean) {
        return bean != null ? bean.getClass() : null;
    }

    public static boolean evaluateValuePredicate(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String str = ((String)value).trim();
            if (str.isEmpty()) {
                return false;
            }
            if ("true".equalsIgnoreCase(str)) {
                return true;
            }
            if ("false".equalsIgnoreCase(str)) {
                return false;
            }
        } else {
            if (value instanceof NodeList) {
                if (value instanceof Node && ((Node)value).hasAttributes()) {
                    return true;
                }
                NodeList list2 = (NodeList)value;
                return list2.getLength() > 0;
            }
            if (value instanceof Collection) {
                return !((Collection)value).isEmpty();
            }
        }
        return value != null;
    }

    public static Iterable<Throwable> createExceptionIterable(Throwable exception) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (Throwable current = exception; current != null; current = current.getCause()) {
            throwables.add(current);
        }
        Collections.reverse(throwables);
        return throwables;
    }

    public static Iterator<Throwable> createExceptionIterator(Throwable exception) {
        return ObjectHelper.createExceptionIterable(exception).iterator();
    }

    public static <T> T getException(Class<T> type, Throwable exception) {
        if (exception == null) {
            return null;
        }
        for (Throwable throwable : exception.getSuppressed()) {
            if (!type.isInstance(throwable)) continue;
            return type.cast(throwable);
        }
        for (Throwable throwable : ObjectHelper.createExceptionIterable(exception)) {
            if (!type.isInstance(throwable)) continue;
            return type.cast(throwable);
        }
        return null;
    }

    public static String getIdentityHashCode(Object object) {
        return "0x" + Integer.toHexString(System.identityHashCode(object));
    }

    public static String lookupConstantFieldValue(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        if (name.startsWith(".")) {
            name = name.substring(1);
        }
        for (Field field2 : clazz.getFields()) {
            if (!field2.getName().equals(name)) continue;
            try {
                Object v = field2.get(null);
                return v.toString();
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isNaN(Object value) {
        return value instanceof Number && (FLOAT_NAN.equals(value) || DOUBLE_NAN.equals(value));
    }

    @Deprecated
    public static RuntimeException wrapRuntimeCamelException(Throwable e) {
        try {
            Class<?> clazz = Class.forName("org.apache.camel.RuntimeException");
            if (clazz.isInstance(e)) {
                return (RuntimeException)clazz.cast(e);
            }
            return (RuntimeException)clazz.getConstructor(Throwable.class).newInstance(e);
        }
        catch (Throwable throwable) {
            if (e instanceof RuntimeException) {
                return (RuntimeException)e;
            }
            return new RuntimeException(e);
        }
    }

    public static List<Object> asList(Object[] objects) {
        return objects != null ? Arrays.asList(objects) : Collections.emptyList();
    }
}

