/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TimeUtils.class);

    private TimeUtils() {
    }

    public static boolean isPositive(Duration dur) {
        return dur.getSeconds() > 0L || dur.getNano() != 0;
    }

    public static String printDuration(Duration uptime) {
        return TimeUtils.printDuration(uptime.toMillis(), true);
    }

    public static String printDuration(long uptime) {
        return TimeUtils.printDuration(uptime, false);
    }

    public static String printDuration(long uptime, boolean precise) {
        if (uptime <= 0L) {
            return "0ms";
        }
        StringBuilder sb = new StringBuilder();
        long seconds = uptime / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        long millis = 0L;
        if (uptime > 1000L) {
            millis = uptime % 1000L;
        } else if (uptime < 1000L) {
            millis = uptime;
        }
        if (days > 0L) {
            sb.append(days).append("d").append(hours % 24L).append("h").append(minutes % 60L).append("m").append(seconds % 60L).append("s");
        } else if (hours > 0L) {
            sb.append(hours % 24L).append("h").append(minutes % 60L).append("m").append(seconds % 60L).append("s");
        } else if (minutes > 0L) {
            sb.append(minutes % 60L).append("m").append(seconds % 60L).append("s");
        } else if (seconds > 0L) {
            sb.append(seconds % 60L).append("s");
            precise = true;
        } else if (millis > 0L) {
            precise = false;
            sb.append(millis).append("ms");
        }
        if (precise & millis > 0L) {
            sb.append(millis).append("ms");
        }
        return sb.toString();
    }

    public static Duration toDuration(String source) throws IllegalArgumentException {
        return Duration.ofMillis(TimeUtils.toMilliSeconds(source));
    }

    public static long toMilliSeconds(String source) throws IllegalArgumentException {
        String s2;
        boolean digit = true;
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if (i == 0 && ch == '-' || ch >= '0' && ch <= '9') continue;
            digit = false;
            break;
        }
        if (digit) {
            return Long.parseLong(source);
        }
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long millis = 0L;
        int pos = source.indexOf(100);
        if (pos != -1) {
            s2 = source.substring(0, pos);
            days = Long.parseLong(s2);
            source = source.substring(pos + 1);
        }
        if ((pos = source.indexOf(104)) != -1) {
            s2 = source.substring(0, pos);
            hours = Long.parseLong(s2);
            source = source.substring(pos + 1);
        }
        if ((pos = source.indexOf(109)) != -1) {
            boolean valid;
            if (source.length() - 1 <= pos) {
                valid = true;
            } else {
                boolean bl = valid = source.charAt(pos + 1) != 's';
            }
            if (valid) {
                String s3 = source.substring(0, pos);
                minutes = Long.parseLong(s3);
                source = source.substring(pos + 1);
            }
        }
        if ((pos = source.indexOf(115)) != -1 && source.charAt(pos - 1) != 'm') {
            String s4 = source.substring(0, pos);
            seconds = Long.parseLong(s4);
            source = source.substring(pos + 1);
        }
        if ((pos = source.indexOf("ms")) != -1) {
            String s5 = source.substring(0, pos);
            millis = Long.parseLong(s5);
        }
        long answer = millis;
        if (seconds > 0L) {
            answer += 1000L * seconds;
        }
        if (minutes > 0L) {
            answer += 60000L * minutes;
        }
        if (hours > 0L) {
            answer += 3600000L * hours;
        }
        if (days > 0L) {
            answer += 86400000L * days;
        }
        LOG.trace("source: [{}], milliseconds: {}", (Object)source, (Object)answer);
        return answer;
    }
}

