/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.CRC24;
import org.bouncycastle.util.StringList;
import org.bouncycastle.util.Strings;

public class ArmoredInputStream
extends InputStream {
    private static final byte[] decodingTable;
    InputStream in;
    boolean start = true;
    int[] outBuf = new int[3];
    int bufPtr = 3;
    CRC24 crc = new CRC24();
    boolean crcFound = false;
    boolean hasHeaders = true;
    String header = null;
    boolean newLineFound = false;
    boolean clearText = false;
    boolean restart = false;
    StringList headerList = Strings.newList();
    int lastC = 0;
    boolean isEndOfStream;

    private int decode(int n, int n2, int n3, int n4, int[] nArray) throws IOException {
        if (n4 < 0) {
            throw new EOFException("unexpected end of file in armored stream.");
        }
        if (n3 == 61) {
            int n5 = decodingTable[n] & 0xFF;
            int n6 = decodingTable[n2] & 0xFF;
            if ((n5 | n6) < 0) {
                throw new IOException("invalid armor");
            }
            nArray[2] = (n5 << 2 | n6 >> 4) & 0xFF;
            return 2;
        }
        if (n4 == 61) {
            byte by2 = decodingTable[n];
            byte by3 = decodingTable[n2];
            byte by4 = decodingTable[n3];
            if ((by2 | by3 | by4) < 0) {
                throw new IOException("invalid armor");
            }
            nArray[1] = (by2 << 2 | by3 >> 4) & 0xFF;
            nArray[2] = (by3 << 4 | by4 >> 2) & 0xFF;
            return 1;
        }
        byte by5 = decodingTable[n];
        byte by6 = decodingTable[n2];
        byte by7 = decodingTable[n3];
        byte by8 = decodingTable[n4];
        if ((by5 | by6 | by7 | by8) < 0) {
            throw new IOException("invalid armor");
        }
        nArray[0] = (by5 << 2 | by6 >> 4) & 0xFF;
        nArray[1] = (by6 << 4 | by7 >> 2) & 0xFF;
        nArray[2] = (by7 << 6 | by8) & 0xFF;
        return 0;
    }

    public ArmoredInputStream(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public ArmoredInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.in = inputStream;
        this.hasHeaders = bl;
        if (bl) {
            this.parseHeaders();
        }
        this.start = false;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    private boolean parseHeaders() throws IOException {
        int n;
        this.header = null;
        int n2 = 0;
        boolean bl = false;
        this.headerList = Strings.newList();
        if (this.restart) {
            bl = true;
        } else {
            while ((n = this.in.read()) >= 0) {
                if (n == 45 && (n2 == 0 || n2 == 10 || n2 == 13)) {
                    bl = true;
                    break;
                }
                n2 = n;
            }
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("-");
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.restart) {
                stringBuffer.append('-');
            }
            while ((n = this.in.read()) >= 0) {
                if (n2 == 13 && n == 10) {
                    bl3 = true;
                }
                if (bl2 && n2 != 13 && n == 10 || bl2 && n == 13) break;
                if (n == 13 || n2 != 13 && n == 10) {
                    String string2 = stringBuffer.toString();
                    if (string2.trim().length() == 0) break;
                    this.headerList.add(string2);
                    stringBuffer.setLength(0);
                }
                if (n != 10 && n != 13) {
                    stringBuffer.append((char)n);
                    bl2 = false;
                } else if (n == 13 || n2 != 13 && n == 10) {
                    bl2 = true;
                }
                n2 = n;
            }
            if (bl3) {
                this.in.read();
            }
        }
        if (this.headerList.size() > 0) {
            this.header = this.headerList.get(0);
        }
        this.clearText = "-----BEGIN PGP SIGNED MESSAGE-----".equals(this.header);
        this.newLineFound = true;
        return bl;
    }

    public boolean isClearText() {
        return this.clearText;
    }

    public boolean isEndOfStream() {
        return this.isEndOfStream;
    }

    public String getArmorHeaderLine() {
        return this.header;
    }

    public String[] getArmorHeaders() {
        if (this.headerList.size() <= 1) {
            return null;
        }
        return this.headerList.toStringArray(1, this.headerList.size());
    }

    private int readIgnoreSpace() throws IOException {
        int n = this.in.read();
        while (n == 32 || n == 9) {
            n = this.in.read();
        }
        if (n >= 128) {
            throw new IOException("invalid armor");
        }
        return n;
    }

    public int read() throws IOException {
        int n;
        if (this.start) {
            if (this.hasHeaders) {
                this.parseHeaders();
            }
            this.crc.reset();
            this.start = false;
        }
        if (this.clearText) {
            int n2 = this.in.read();
            if (n2 == 13 || n2 == 10 && this.lastC != 13) {
                this.newLineFound = true;
            } else if (this.newLineFound && n2 == 45) {
                n2 = this.in.read();
                if (n2 == 45) {
                    this.clearText = false;
                    this.start = true;
                    this.restart = true;
                } else {
                    n2 = this.in.read();
                }
                this.newLineFound = false;
            } else if (n2 != 10 && this.lastC != 13) {
                this.newLineFound = false;
            }
            this.lastC = n2;
            if (n2 < 0) {
                this.isEndOfStream = true;
            }
            return n2;
        }
        if (this.bufPtr > 2 || this.crcFound) {
            n = this.readIgnoreSpace();
            if (n == 13 || n == 10) {
                n = this.readIgnoreSpace();
                while (n == 10 || n == 13) {
                    n = this.readIgnoreSpace();
                }
                if (n < 0) {
                    this.isEndOfStream = true;
                    return -1;
                }
                if (n == 61) {
                    this.bufPtr = this.decode(this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
                    if (this.bufPtr == 0) {
                        int n3 = (this.outBuf[0] & 0xFF) << 16 | (this.outBuf[1] & 0xFF) << 8 | this.outBuf[2] & 0xFF;
                        this.crcFound = true;
                        if (n3 != this.crc.getValue()) {
                            throw new IOException("crc check failed in armored message.");
                        }
                        return this.read();
                    }
                    throw new IOException("no crc found in armored message.");
                }
                if (n == 45) {
                    while ((n = this.in.read()) >= 0 && n != 10 && n != 13) {
                    }
                    if (!this.crcFound) {
                        throw new IOException("crc check not found.");
                    }
                    this.crcFound = false;
                    this.start = true;
                    this.bufPtr = 3;
                    if (n < 0) {
                        this.isEndOfStream = true;
                    }
                    return -1;
                }
                this.bufPtr = this.decode(n, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            } else if (n >= 0) {
                this.bufPtr = this.decode(n, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            } else {
                this.isEndOfStream = true;
                return -1;
            }
        }
        n = this.outBuf[this.bufPtr++];
        this.crc.update(n);
        return n;
    }

    public void close() throws IOException {
        this.in.close();
    }

    static {
        int n;
        decodingTable = new byte[128];
        for (n = 0; n < decodingTable.length; ++n) {
            ArmoredInputStream.decodingTable[n] = -1;
        }
        for (n = 65; n <= 90; ++n) {
            ArmoredInputStream.decodingTable[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            ArmoredInputStream.decodingTable[n] = (byte)(n - 97 + 26);
        }
        for (n = 48; n <= 57; ++n) {
            ArmoredInputStream.decodingTable[n] = (byte)(n - 48 + 52);
        }
        ArmoredInputStream.decodingTable[43] = 62;
        ArmoredInputStream.decodingTable[47] = 63;
    }
}

