/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class PGPKeyRingGenerator {
    List keys = new ArrayList();
    private PBESecretKeyEncryptor keyEncryptor;
    private PGPDigestCalculator checksumCalculator;
    private PGPKeyPair masterKey;
    private PGPSignatureSubpacketVector hashedPcks;
    private PGPSignatureSubpacketVector unhashedPcks;
    private PGPContentSignerBuilder keySignerBuilder;

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string2, PGPDigestCalculator pGPDigestCalculator, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this.masterKey = pGPKeyPair;
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        this.hashedPcks = pGPSignatureSubpacketVector;
        this.unhashedPcks = pGPSignatureSubpacketVector2;
        this.keys.add(new PGPSecretKey(n, pGPKeyPair, string2, pGPDigestCalculator, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, pGPContentSignerBuilder, pBESecretKeyEncryptor));
    }

    public PGPKeyRingGenerator(PGPSecretKeyRing pGPSecretKeyRing, PBESecretKeyDecryptor pBESecretKeyDecryptor, PGPDigestCalculator pGPDigestCalculator, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this.masterKey = new PGPKeyPair(pGPSecretKeyRing.getPublicKey(), pGPSecretKeyRing.getSecretKey().extractPrivateKey(pBESecretKeyDecryptor));
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        PGPSignature pGPSignature = (PGPSignature)pGPSecretKeyRing.getPublicKey().getSignatures().next();
        ArrayList<SignatureSubpacket> arrayList = new ArrayList<SignatureSubpacket>();
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets();
        for (int i = 0; i != pGPSignatureSubpacketVector.size(); ++i) {
            if (pGPSignatureSubpacketVector.packets[i].getType() == 2) continue;
            arrayList.add(pGPSignatureSubpacketVector.packets[i]);
        }
        this.hashedPcks = new PGPSignatureSubpacketVector(arrayList.toArray(new SignatureSubpacket[arrayList.size()]));
        this.unhashedPcks = pGPSignature.getUnhashedSubPackets();
        this.keys.addAll(pGPSecretKeyRing.keys);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair) throws PGPException {
        this.addSubKey(pGPKeyPair, this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2) throws PGPException {
        try {
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.keySignerBuilder);
            pGPSignatureGenerator.init(24, this.masterKey.getPrivateKey());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
            pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            arrayList.add(pGPSignatureGenerator.generateCertification(this.masterKey.getPublicKey(), pGPKeyPair.getPublicKey()));
            PGPPublicKey pGPPublicKey = new PGPPublicKey(pGPKeyPair.getPublicKey(), null, arrayList);
            pGPPublicKey.publicPk = new PublicSubkeyPacket(pGPPublicKey.getAlgorithm(), pGPPublicKey.getCreationTime(), pGPPublicKey.publicPk.getKey());
            this.keys.add(new PGPSecretKey(pGPKeyPair.getPrivateKey(), pGPPublicKey, this.checksumCalculator, this.keyEncryptor));
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception adding subkey: ", exception);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator iterator2 = this.keys.iterator();
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        arrayList.add(((PGPSecretKey)iterator2.next()).getPublicKey());
        while (iterator2.hasNext()) {
            arrayList.add(((PGPSecretKey)iterator2.next()).getPublicKey());
        }
        return new PGPPublicKeyRing(arrayList);
    }
}

