/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPPublicKeyRing
extends PGPKeyRing
implements Iterable<PGPPublicKey> {
    List keys;

    public PGPPublicKeyRing(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    private static List checkKeys(List list2) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(list2.size());
        for (int i = 0; i != list2.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)list2.get(i);
            if (i == 0) {
                if (!pGPPublicKey.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (pGPPublicKey.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            arrayList.add(pGPPublicKey);
        }
        return arrayList;
    }

    public PGPPublicKeyRing(List list2) {
        this.keys = PGPPublicKeyRing.checkKeys(list2);
    }

    public PGPPublicKeyRing(InputStream inputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this.keys = new ArrayList();
        BCPGInputStream bCPGInputStream = PGPPublicKeyRing.wrap(inputStream);
        int n = bCPGInputStream.nextPacketTag();
        if (n != 6 && n != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(n));
        }
        PublicKeyPacket publicKeyPacket = PGPPublicKeyRing.readPublicKeyPacket(bCPGInputStream);
        TrustPacket trustPacket = PGPPublicKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list2 = PGPPublicKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        PGPPublicKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        try {
            this.keys.add(new PGPPublicKey(publicKeyPacket, trustPacket, list2, arrayList, arrayList2, arrayList3, keyFingerPrintCalculator));
            while (bCPGInputStream.nextPacketTag() == 14) {
                this.keys.add(PGPPublicKeyRing.readSubkey(bCPGInputStream, keyFingerPrintCalculator));
            }
        }
        catch (PGPException pGPException) {
            throw new IOException("processing exception: " + pGPException.toString());
        }
    }

    @Override
    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    @Override
    public PGPPublicKey getPublicKey(long l) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            if (l != pGPPublicKey.getKeyID()) continue;
            return pGPPublicKey;
        }
        return null;
    }

    @Override
    public PGPPublicKey getPublicKey(byte[] byArray) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            if (!Arrays.areEqual(byArray, pGPPublicKey.getFingerprint())) continue;
            return pGPPublicKey;
        }
        return null;
    }

    @Override
    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long l) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            Iterator<PGPSignature> iterator2 = pGPPublicKey.getSignaturesForKeyID(l);
            if (!iterator2.hasNext()) continue;
            arrayList.add(pGPPublicKey);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<PGPPublicKey> getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    @Override
    public Iterator<PGPPublicKey> iterator() {
        return this.getPublicKeys();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(i);
            pGPPublicKey.encode(outputStream, bl);
        }
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(pGPPublicKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i != arrayList.size(); ++i) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(i);
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                bl = true;
                arrayList.set(i, pGPPublicKey);
            }
            if (!pGPPublicKey2.isMasterKey()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (pGPPublicKey.isMasterKey()) {
                if (bl2) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                arrayList.add(0, pGPPublicKey);
            } else {
                arrayList.add(pGPPublicKey);
            }
        }
        return new PGPPublicKeyRing(arrayList);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList arrayList = new ArrayList(pGPPublicKeyRing.keys);
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(i);
            if (pGPPublicKey2.getKeyID() != pGPPublicKey.getKeyID()) continue;
            bl = true;
            arrayList.remove(i);
        }
        if (!bl) {
            return null;
        }
        return new PGPPublicKeyRing(arrayList);
    }

    static PublicKeyPacket readPublicKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof PublicKeyPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (PublicKeyPacket)packet;
    }

    static PGPPublicKey readSubkey(BCPGInputStream bCPGInputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        PublicKeyPacket publicKeyPacket = PGPPublicKeyRing.readPublicKeyPacket(bCPGInputStream);
        TrustPacket trustPacket = PGPPublicKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list2 = PGPPublicKeyRing.readSignaturesAndTrust(bCPGInputStream);
        return new PGPPublicKey(publicKeyPacket, trustPacket, list2, keyFingerPrintCalculator);
    }
}

