/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.header;

import com.datasonnet.document.Document;
import com.datasonnet.document.InvalidMediaTypeException;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.header.HeaderParseException;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropNode;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropPathSplitter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Header {
    public static final String DATASONNET_HEADER = "/** DataSonnet";
    public static final String COMMENT_PREFIX = "//";
    public static final Pattern VERSION_LINE = Pattern.compile("^version *= *(?<version>[a-zA-Z0-9.+-]+) *(\\r?\\n|$)");
    public static final String DATASONNET_DEFAULT_PREFIX = "default ";
    public static final String DATASONNET_INPUT = "input";
    public static final Pattern INPUT_LINE = Pattern.compile("^(?:input (?<name>\\w+)|input (?<all>\\*)) (?<mediatype>\\S.*)$");
    public static final String DATASONNET_OUTPUT = "output";
    public static final Pattern OUTPUT_LINE = Pattern.compile("^output (?<mediatype>\\S.*)$");
    public static final String DATASONNET_PRESERVE_ORDER = "preserveOrder";
    public static final String DATAFORMAT_PREFIX = "dataformat";
    public static final String DATAFORMAT_ALL = "*";
    public static final String LATEST_RELEASE_VERSION = "2.0";
    private final String versionMajor;
    private final String versionMinor;
    private final boolean preserveOrder;
    private final Map<String, Map<Integer, MediaType>> namedInputs;
    private final Map<Integer, MediaType> outputs;
    private final Map<Integer, MediaType> allInputs;
    private final Map<Integer, MediaType> dataFormats;
    private final HashMap<String, MediaType> defaultInputs;
    private final MediaType defaultOutput;
    private static final Header EMPTY = new Header("2.0", true, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    public Header(String version, boolean preserveOrder, Map<String, Collection<MediaType>> namedInputs, List<MediaType> outputs, Iterable<MediaType> allInputs, Iterable<MediaType> dataFormats) {
        String[] versions = version.split("\\.", 2);
        this.versionMajor = versions[0];
        this.versionMinor = versions[1];
        this.preserveOrder = preserveOrder;
        this.defaultInputs = new HashMap();
        this.namedInputs = new HashMap<String, Map<Integer, MediaType>>();
        for (Map.Entry<String, Collection<MediaType>> entry : namedInputs.entrySet()) {
            Collection<MediaType> types = entry.getValue();
            if (types.size() <= 0) continue;
            Map<Integer, MediaType> indexed = this.indexMediaTypes(types);
            this.namedInputs.put(entry.getKey(), indexed);
            ArrayList<MediaType> sorted2 = new ArrayList<MediaType>(indexed.values());
            MediaType.sortByQualityValue(sorted2);
            this.defaultInputs.put(entry.getKey(), (MediaType)sorted2.get(0));
        }
        this.outputs = this.indexMediaTypes(outputs);
        if (outputs.size() > 0) {
            ArrayList<MediaType> sorted3 = new ArrayList<MediaType>(outputs);
            MediaType.sortByQualityValue(sorted3);
            this.defaultOutput = (MediaType)sorted3.get(0);
        } else {
            this.defaultOutput = MediaTypes.ANY;
        }
        this.allInputs = this.indexMediaTypes(allInputs);
        this.dataFormats = this.indexMediaTypes(dataFormats);
    }

    private Map<Integer, MediaType> indexMediaTypes(Iterable<MediaType> mediaTypes) {
        HashMap<Integer, MediaType> indexed = new HashMap<Integer, MediaType>();
        for (MediaType mediaType : mediaTypes) {
            indexed.put(this.calculateIndex(mediaType), mediaType);
        }
        return indexed;
    }

    private Integer calculateIndex(MediaType mediaType) {
        return mediaType.getType().hashCode() + mediaType.getSubtype().hashCode();
    }

    public static Header parseHeader(String script) throws HeaderParseException {
        if (!script.trim().startsWith(DATASONNET_HEADER)) {
            return EMPTY;
        }
        String headerSection = Header.extractHeader(script);
        Matcher versionMatcher = VERSION_LINE.matcher(headerSection);
        if (!versionMatcher.find()) {
            throw new HeaderParseException("The first line of the header must be a version line, but is not");
        }
        String version = versionMatcher.group("version");
        String headerWithoutVersion = headerSection.substring(versionMatcher.end());
        String[] splitVersion = version.split("\\.", 2);
        switch (splitVersion[0]) {
            case "1": {
                if ("0".equals(splitVersion[1])) {
                    return Header.parseHeader10(headerWithoutVersion);
                }
                throw new HeaderParseException("Version must be 1.0 but is " + version);
            }
            case "2": {
                if ("0".equals(splitVersion[1])) {
                    return Header.parseHeader20(headerWithoutVersion);
                }
                System.err.println("WARNING: You are using a version that is still in development. The latest release version is: 2.0");
                return Header.parseHeader20(headerWithoutVersion, version);
            }
        }
        throw new HeaderParseException("Major version must be one of [1,2] but is " + splitVersion[0]);
    }

    @NotNull
    private static String extractHeader(String script) throws HeaderParseException {
        int terminus = script.indexOf("*/");
        if (terminus == -1) {
            throw new HeaderParseException("Unterminated header. Headers must end with */");
        }
        String headerSection = script.substring(0, terminus).replace(DATASONNET_HEADER, "").trim();
        return headerSection;
    }

    @NotNull
    private static Header parseHeader10(String headerSection) throws HeaderParseException {
        JavaPropsMapper mapper = new JavaPropsMapper();
        JavaPropsSchema schema = new JavaPropsSchema(){

            @Override
            public JPropPathSplitter pathSplitter() {
                return new HeaderSplitter();
            }

            class HeaderSplitter
            extends JPropPathSplitter {
                protected final char _pathSeparatorChar = '.';

                public HeaderSplitter() {
                    super(true);
                    this._pathSeparatorChar = (char)46;
                }

                @Override
                public JPropNode splitAndAdd(JPropNode parent, String key, String value) {
                    String[] segments;
                    JPropNode curr = parent;
                    for (String segment : segments = key.split("(?<!\\\\)" + Pattern.quote("."))) {
                        curr = this._addSegment(curr, segment.replaceAll("\\\\", ""));
                    }
                    return curr.setValue(value);
                }
            }
        };
        try {
            Properties props = new Properties();
            props.load(new StringReader(headerSection));
            Map propsMap = mapper.readPropertiesAs(props, schema, Map.class);
            Map originalInputs = Header.getOrEmpty(propsMap, DATASONNET_INPUT);
            HashMap<String, Collection<MediaType>> inputs = new HashMap<String, Collection<MediaType>>();
            for (Map.Entry entry : originalInputs.entrySet()) {
                if (entry.getKey().equals(DATAFORMAT_ALL)) continue;
                List<MediaType> mediaTypes = Header.extractMediaTypes((Map)entry.getValue());
                inputs.put(entry.getKey(), mediaTypes);
            }
            List<MediaType> allInputs = Header.extractMediaTypes(Header.getOrEmpty(originalInputs, DATAFORMAT_ALL));
            List<MediaType> output = Header.extractMediaTypes(Header.getOrEmpty(propsMap, DATASONNET_OUTPUT));
            List<MediaType> dataFormat = Header.extractMediaTypes(Header.getOrEmpty(propsMap, DATAFORMAT_PREFIX));
            return new Header("1.0", Header.getBoolean(propsMap, DATASONNET_PRESERVE_ORDER, true), inputs, output, allInputs, dataFormat);
        }
        catch (IOException | IllegalArgumentException exc) {
            throw new HeaderParseException("Error parsing DataSonnet Header: " + exc.getMessage(), exc);
        }
        catch (ClassCastException exc) {
            throw new HeaderParseException("Error parsing DataSonnet Header, make sure type parameters are nested properly");
        }
    }

    private static MediaType extractMediaType(String type, Map<String, String> params) {
        return new MediaType(MediaType.valueOf(type), params);
    }

    private static List<MediaType> extractMediaTypes(Map<String, Map<String, String>> originals) {
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (Map.Entry<String, Map<String, String>> entry : originals.entrySet()) {
            types.add(Header.extractMediaType(entry.getKey(), entry.getValue()));
        }
        return types;
    }

    private static <T> Map<String, T> getOrEmpty(Map<String, Map<String, T>> map2, String key) {
        return map2.getOrDefault(key, Collections.emptyMap());
    }

    private static boolean getBoolean(Map<String, ?> propsMap, String key, boolean defaultTo) {
        if (propsMap.containsKey(key)) {
            return Boolean.parseBoolean(propsMap.get(key).toString());
        }
        return defaultTo;
    }

    @NotNull
    private static Header parseHeader20(String headerSection, String version) throws HeaderParseException {
        boolean preserve = true;
        ArrayList<MediaType> outputs = new ArrayList<MediaType>(4);
        HashMap inputs = new HashMap(4);
        ArrayList<MediaType> allInputs = new ArrayList<MediaType>(4);
        ArrayList<MediaType> dataformat = new ArrayList<MediaType>(4);
        for (String line : headerSection.split("\\r?\\n")) {
            line = line.trim();
            try {
                Matcher matcher;
                String[] tokens;
                if (line.startsWith(DATASONNET_PRESERVE_ORDER)) {
                    tokens = line.split("=", 2);
                    preserve = Boolean.parseBoolean(tokens[1]);
                    continue;
                }
                if (line.startsWith(DATASONNET_INPUT)) {
                    matcher = INPUT_LINE.matcher(line);
                    if (!matcher.matches()) {
                        throw new HeaderParseException("Unable to parse header line " + line + ", it must follow the input line format");
                    }
                    String name = matcher.group("name");
                    MediaType mediaType = MediaType.valueOf(matcher.group("mediatype"));
                    if (matcher.group("all") != null) {
                        allInputs.add(mediaType);
                        continue;
                    }
                    if (!inputs.containsKey(name)) {
                        inputs.put(name, new ArrayList());
                    }
                    ((List)inputs.get(name)).add(mediaType);
                    continue;
                }
                if (line.startsWith(DATASONNET_OUTPUT)) {
                    matcher = OUTPUT_LINE.matcher(line);
                    if (!matcher.matches()) {
                        throw new HeaderParseException("Unable to parse header line " + line + ", it must follow the output line format");
                    }
                    MediaType mediaType = MediaType.valueOf(matcher.group("mediatype"));
                    outputs.add(mediaType);
                    continue;
                }
                if (line.startsWith(DATAFORMAT_PREFIX)) {
                    tokens = line.split(" ", 2);
                    MediaType toAdd = MediaType.valueOf(tokens[1]);
                    dataformat.add(toAdd);
                    continue;
                }
                if (line.isEmpty() || line.startsWith(COMMENT_PREFIX)) continue;
                throw new HeaderParseException("Unable to parse header line: " + line);
            }
            catch (InvalidMediaTypeException exc) {
                throw new HeaderParseException("Could not parse media type from header in line " + line, exc);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                throw new HeaderParseException("Problem with header formatting in line " + line);
            }
        }
        return new Header(version, preserve, Collections.unmodifiableMap(inputs), outputs, allInputs, dataformat);
    }

    @NotNull
    private static Header parseHeader20(String headerSection) throws HeaderParseException {
        return Header.parseHeader20(headerSection, LATEST_RELEASE_VERSION);
    }

    public String getVersion() {
        return this.versionMajor + "." + this.versionMinor;
    }

    public String getVersionMajor() {
        return this.versionMajor;
    }

    public String getVersionMinor() {
        return this.versionMinor;
    }

    public Map<String, Iterable<MediaType>> getNamedInputs() {
        HashMap<String, Collection<MediaType>> namedInputs = new HashMap<String, Collection<MediaType>>(this.namedInputs.size());
        for (Map.Entry<String, Map<Integer, MediaType>> entry : this.namedInputs.entrySet()) {
            namedInputs.put(entry.getKey(), Collections.unmodifiableCollection(entry.getValue().values()));
        }
        return Collections.unmodifiableMap(namedInputs);
    }

    public Optional<MediaType> getDefaultNamedInput(String name) {
        return Optional.ofNullable(this.defaultInputs.get(name));
    }

    public Collection<MediaType> getOutputs() {
        return Collections.unmodifiableCollection(this.outputs.values());
    }

    public Optional<MediaType> getDefaultOutput() {
        return Optional.ofNullable(this.defaultOutput);
    }

    public Optional<MediaType> getDefaultPayload() {
        return Optional.ofNullable(this.defaultInputs.get("payload"));
    }

    public Collection<MediaType> getAllInputs() {
        return Collections.unmodifiableCollection(this.allInputs.values());
    }

    public Collection<MediaType> getDataFormats() {
        return Collections.unmodifiableCollection(this.dataFormats.values());
    }

    public boolean isPreserveOrder() {
        return this.preserveOrder;
    }

    public <T> Document<T> combineInputParams(String inputName, Document<T> doc) {
        Map<Integer, MediaType> inputTypes;
        HashMap<String, String> params = new HashMap<String, String>(4);
        MediaType mediaType = doc.getMediaType();
        Integer key = this.calculateIndex(mediaType);
        if (this.dataFormats.containsKey(key)) {
            params.putAll(this.dataFormats.get(key).getParameters());
        }
        if (this.allInputs.containsKey(key)) {
            params.putAll(this.allInputs.get(key).getParameters());
        }
        if (this.namedInputs.containsKey(inputName) && (inputTypes = this.namedInputs.get(inputName)) != null && inputTypes.containsKey(key)) {
            params.putAll(inputTypes.get(key).getParameters());
        }
        params.putAll(mediaType.getParameters());
        return doc.withMediaType(new MediaType(mediaType, params));
    }

    public MediaType combineOutputParams(MediaType mediaType) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        Integer key = this.calculateIndex(mediaType);
        if (this.dataFormats.containsKey(key)) {
            params.putAll(this.dataFormats.get(key).getParameters());
        }
        if (this.outputs.containsKey(key)) {
            params.putAll(this.outputs.get(key).getParameters());
        }
        params.putAll(mediaType.getParameters());
        return new MediaType(mediaType, params);
    }
}

