/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.plugins;

import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.spi.AbstractDataFormatPlugin;
import com.datasonnet.spi.PluginException;
import com.datasonnet.spi.ujsonUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import ujson.Null$;
import ujson.Readable;
import ujson.Value;

public class DefaultJSONFormatPlugin
extends AbstractDataFormatPlugin {
    public DefaultJSONFormatPlugin() {
        this.supportedTypes.add(MediaTypes.APPLICATION_JSON);
        this.supportedTypes.add(new MediaType("application", "*+json"));
        this.writerParams.add("indent");
        this.readerSupportedClasses.add(String.class);
        this.readerSupportedClasses.add(CharSequence.class);
        this.readerSupportedClasses.add(Path.class);
        this.readerSupportedClasses.add(File.class);
        this.readerSupportedClasses.add(ByteBuffer.class);
        this.readerSupportedClasses.add(byte[].class);
        this.writerSupportedClasses.add(String.class);
        this.writerSupportedClasses.add(CharSequence.class);
        this.writerSupportedClasses.add(ByteBuffer.class);
        this.writerSupportedClasses.add(OutputStream.class);
        this.writerSupportedClasses.add(byte[].class);
    }

    @Override
    public Value read(Document<?> doc) throws PluginException {
        if (doc.getContent() == null) {
            return Null$.MODULE$;
        }
        Class<?> targetType = doc.getContent().getClass();
        if (String.class.isAssignableFrom(targetType)) {
            return ujsonUtils.read(Readable.fromString((String)doc.getContent()), false);
        }
        if (CharSequence.class.isAssignableFrom(targetType)) {
            return ujsonUtils.read(Readable.fromCharSequence((CharSequence)doc.getContent()), false);
        }
        if (Path.class.isAssignableFrom(targetType)) {
            return ujsonUtils.read(Readable.fromPath((Path)doc.getContent()), false);
        }
        if (File.class.isAssignableFrom(targetType)) {
            return ujsonUtils.read(Readable.fromFile((File)doc.getContent()), false);
        }
        if (ByteBuffer.class.isAssignableFrom(targetType)) {
            return ujsonUtils.read(Readable.fromByteBuffer((ByteBuffer)doc.getContent()), false);
        }
        if (byte[].class.isAssignableFrom(targetType)) {
            return ujsonUtils.read(Readable.fromByteArray((byte[])doc.getContent()), false);
        }
        throw new PluginException(new IllegalArgumentException("Unsupported document content class, use the test method canRead before invoking read"));
    }

    @Override
    public <T> Document<T> write(Value input2, MediaType mediaType, Class<T> targetType) throws PluginException {
        int indent;
        Charset charset = mediaType.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        int n = indent = mediaType.getParameters().containsKey("indent") ? 4 : -1;
        if (targetType.isAssignableFrom(String.class)) {
            return new DefaultDocument<String>(ujsonUtils.write(input2, indent, false), MediaTypes.APPLICATION_JSON);
        }
        if (targetType.isAssignableFrom(CharSequence.class)) {
            return new DefaultDocument<String>(ujsonUtils.write(input2, indent, false), MediaTypes.APPLICATION_JSON);
        }
        if (targetType.isAssignableFrom(OutputStream.class)) {
            BufferedOutputStream out = new BufferedOutputStream(new ByteArrayOutputStream());
            ujsonUtils.writeTo(input2, new OutputStreamWriter((OutputStream)out, charset), indent, false);
            return new DefaultDocument<BufferedOutputStream>(out, MediaTypes.APPLICATION_JSON);
        }
        if (targetType.isAssignableFrom(ByteBuffer.class)) {
            return new DefaultDocument<ByteBuffer>(ByteBuffer.wrap(ujsonUtils.write(input2, indent, false).getBytes(charset)), MediaTypes.APPLICATION_JSON);
        }
        if (targetType.isAssignableFrom(byte[].class)) {
            return new DefaultDocument<byte[]>(ujsonUtils.write(input2, indent, false).getBytes(charset), MediaTypes.APPLICATION_JSON);
        }
        throw new PluginException(new IllegalArgumentException("Unsupported document content class, use the test method canRead before invoking read"));
    }
}

