/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.spi;

import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.spi.DataFormatPlugin;
import com.datasonnet.spi.PluginException;
import java.util.LinkedHashSet;
import java.util.Set;
import ujson.Value;

public abstract class AbstractDataFormatPlugin
implements DataFormatPlugin {
    public static final String DS_PARAM_INDENT = "indent";
    protected final Set<MediaType> supportedTypes = new LinkedHashSet<MediaType>(4);
    protected final Set<String> readerParams = new LinkedHashSet<String>();
    protected final Set<String> writerParams = new LinkedHashSet<String>();
    protected final Set<Class<?>> readerSupportedClasses = new LinkedHashSet(8);
    protected final Set<Class<?>> writerSupportedClasses = new LinkedHashSet(8);

    @Override
    public Value read(Document<?> doc) throws PluginException {
        throw new UnsupportedOperationException("not implemented!");
    }

    @Override
    public <T> Document<T> write(Value input2, MediaType mediaType, Class<T> targetType) throws PluginException {
        throw new UnsupportedOperationException("not implemented!");
    }

    @Override
    public boolean canRead(Document<?> doc) {
        MediaType requestedType = doc.getMediaType();
        for (MediaType supportedType : this.supportedTypes) {
            if (!supportedType.includes(requestedType) || !this.parametersAreSupported(requestedType, this.readerParams) || doc.getContent() != null && !this.canReadClass(doc.getContent().getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite(MediaType requestedType, Class<?> clazz) {
        for (MediaType supportedType : this.supportedTypes) {
            if (!supportedType.includes(requestedType) || !this.parametersAreSupported(requestedType, this.writerParams) || !this.canWriteClass(clazz)) continue;
            return true;
        }
        return false;
    }

    protected boolean canReadClass(Class<?> cls) {
        for (Class<?> supported : this.readerSupportedClasses) {
            if (!supported.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    protected boolean canWriteClass(Class<?> clazz) {
        for (Class<?> supported : this.writerSupportedClasses) {
            if (!clazz.isAssignableFrom(supported)) continue;
            return true;
        }
        return false;
    }

    private boolean parametersAreSupported(MediaType requestedType, Set<String> supported) {
        for (String param2 : requestedType.getParameters().keySet()) {
            if ("q".equals(param2) || "charset".equals(param2)) continue;
            boolean matched = false;
            for (String supportedParam : supported) {
                if (!param2.matches(supportedParam)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }
}

