/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.catalog.PropertiesValidationResult;

public class EndpointValidationResult
extends PropertiesValidationResult
implements Serializable {
    private final String uri;
    private Set<String> lenient;
    private Set<String> notConsumerOnly;
    private Set<String> notProducerOnly;

    public EndpointValidationResult() {
        this(null);
    }

    public EndpointValidationResult(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public boolean isSuccess() {
        boolean ok = super.isSuccess();
        if (ok) {
            ok = this.notConsumerOnly == null && this.notProducerOnly == null;
        }
        return ok;
    }

    public void addLenient(String name) {
        if (this.lenient == null) {
            this.lenient = new LinkedHashSet<String>();
        }
        if (!this.lenient.contains(name)) {
            this.lenient.add(name);
        }
    }

    public void addNotConsumerOnly(String name) {
        if (this.notConsumerOnly == null) {
            this.notConsumerOnly = new LinkedHashSet<String>();
        }
        if (!this.notConsumerOnly.contains(name)) {
            this.notConsumerOnly.add(name);
            ++this.errors;
        }
    }

    public void addNotProducerOnly(String name) {
        if (this.notProducerOnly == null) {
            this.notProducerOnly = new LinkedHashSet<String>();
        }
        if (!this.notProducerOnly.contains(name)) {
            this.notProducerOnly.add(name);
            ++this.errors;
        }
    }

    public Set<String> getNotConsumerOnly() {
        return this.notConsumerOnly;
    }

    public Set<String> getNotProducerOnly() {
        return this.notProducerOnly;
    }

    public Set<String> getLenient() {
        return this.lenient;
    }

    public String summaryErrorMessage(boolean includeHeader) {
        return this.summaryErrorMessage(includeHeader, true, false);
    }

    public String summaryErrorMessage(boolean includeHeader, boolean ignoreDeprecated, boolean includeWarnings) {
        boolean ok = this.isSuccess();
        if (ok && !ignoreDeprecated) {
            boolean bl = ok = this.deprecated == null;
        }
        if (includeWarnings) {
            if (this.incapable != null) {
                return "\tIncapable of parsing uri: " + this.incapable;
            }
            if (this.syntaxError != null) {
                return "\tSyntax error: " + this.syntaxError;
            }
            if (this.unknownComponent != null) {
                return "\tUnknown component: " + this.unknownComponent;
            }
        }
        if (ok) {
            return null;
        }
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        if (this.unknown != null) {
            for (String string2 : this.unknown) {
                if (this.unknownSuggestions != null && this.unknownSuggestions.containsKey(string2)) {
                    String[] suggestions = (String[])this.unknownSuggestions.get(string2);
                    if (suggestions != null && suggestions.length > 0) {
                        String str = Arrays.asList(suggestions).toString();
                        options.put(string2, "Unknown option. Did you mean: " + str);
                        continue;
                    }
                    options.put(string2, "Unknown option");
                    continue;
                }
                options.put(string2, "Unknown option");
            }
        }
        if (this.notConsumerOnly != null) {
            for (String string3 : this.notConsumerOnly) {
                options.put(string3, "Option not applicable in consumer only mode");
            }
        }
        if (this.notProducerOnly != null) {
            for (String string4 : this.notProducerOnly) {
                options.put(string4, "Option not applicable in producer only mode");
            }
        }
        if (this.required != null) {
            for (String string5 : this.required) {
                options.put(string5, "Missing required option");
            }
        }
        if (this.deprecated != null) {
            for (String string6 : this.deprecated) {
                options.put(string6, "Deprecated option");
            }
        }
        if (this.invalidEnum != null) {
            for (Map.Entry entry : this.invalidEnum.entrySet()) {
                String[] suggestions;
                String name = (String)entry.getKey();
                String[] choices = (String[])this.invalidEnumChoices.get(name);
                String defaultValue = this.defaultValues != null ? (String)this.defaultValues.get(entry.getKey()) : null;
                String str = Arrays.asList(choices).toString();
                String msg = "Invalid enum value: " + (String)entry.getValue() + ". Possible values: " + str;
                if (this.invalidEnumSuggestions != null && (suggestions = (String[])this.invalidEnumSuggestions.get(name)) != null && suggestions.length > 0) {
                    str = Arrays.asList(suggestions).toString();
                    msg = msg + ". Did you mean: " + str;
                }
                if (defaultValue != null) {
                    msg = msg + ". Default value: " + defaultValue;
                }
                options.put((String)entry.getKey(), msg);
            }
        }
        if (this.invalidReference != null) {
            for (Map.Entry entry : this.invalidReference.entrySet()) {
                boolean empty = EndpointValidationResult.isEmpty((String)entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty reference value");
                    continue;
                }
                if (!((String)entry.getValue()).startsWith("#")) {
                    options.put((String)entry.getKey(), "Invalid reference value: " + (String)entry.getValue() + " must start with #");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid reference value: " + (String)entry.getValue());
            }
        }
        if (this.invalidBoolean != null) {
            for (Map.Entry entry : this.invalidBoolean.entrySet()) {
                boolean empty = EndpointValidationResult.isEmpty((String)entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty boolean value");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid boolean value: " + (String)entry.getValue());
            }
        }
        if (this.invalidInteger != null) {
            for (Map.Entry entry : this.invalidInteger.entrySet()) {
                boolean empty = EndpointValidationResult.isEmpty((String)entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty integer value");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid integer value: " + (String)entry.getValue());
            }
        }
        if (this.invalidNumber != null) {
            for (Map.Entry entry : this.invalidNumber.entrySet()) {
                boolean empty = EndpointValidationResult.isEmpty((String)entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty number value");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid number value: " + (String)entry.getValue());
            }
        }
        int maxLen = 24;
        for (String key : options.keySet()) {
            maxLen = Math.max(maxLen, key.length());
        }
        String string7 = "%" + maxLen + "s    %s";
        StringBuilder sb = new StringBuilder();
        if (includeHeader) {
            sb.append("Endpoint validator error\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
            sb.append("\n");
        }
        if (this.uri != null) {
            sb.append("\t").append(this.uri).append("\n");
        } else {
            sb.append("\n");
        }
        for (Map.Entry option : options.entrySet()) {
            String out = String.format(string7, option.getKey(), option.getValue());
            sb.append("\n\t").append(out);
        }
        return sb.toString();
    }
}

