/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelContextTracker
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextTracker.class);
    private static final List<CamelContextTracker> TRACKERS = new CopyOnWriteArrayList<CamelContextTracker>();
    private final Filter filter;

    public CamelContextTracker() {
        this.filter = camelContext -> !camelContext.getClass().getName().contains("Proxy");
    }

    public CamelContextTracker(Filter filter2) {
        this.filter = filter2;
    }

    public boolean accept(CamelContext camelContext) {
        return this.filter == null || this.filter.accept(camelContext);
    }

    public void contextCreated(CamelContext camelContext) {
    }

    public void contextDestroyed(CamelContext camelContext) {
    }

    public final void open() {
        TRACKERS.add(this);
    }

    @Override
    public final void close() {
        TRACKERS.remove(this);
    }

    public static synchronized void notifyContextCreated(CamelContext camelContext) {
        for (CamelContextTracker tracker : TRACKERS) {
            try {
                if (!tracker.accept(camelContext)) continue;
                tracker.contextCreated(camelContext);
            }
            catch (Exception e) {
                LOG.warn("Error calling CamelContext tracker. This exception is ignored.", (Throwable)e);
            }
        }
    }

    public static synchronized void notifyContextDestroyed(CamelContext camelContext) {
        for (CamelContextTracker tracker : TRACKERS) {
            try {
                if (!tracker.accept(camelContext)) continue;
                tracker.contextDestroyed(camelContext);
            }
            catch (Exception e) {
                LOG.warn("Error calling CamelContext tracker. This exception is ignored.", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    public static interface Filter
    extends Predicate<CamelContext> {
        public boolean accept(CamelContext var1);

        @Override
        default public boolean test(CamelContext camelContext) {
            return this.accept(camelContext);
        }
    }
}

