/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicUuidGenerator
implements UuidGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ClassicUuidGenerator.class);
    private static final String UNIQUE_STUB;
    private static int instanceCount;
    private static String hostName;
    private String seed;
    private final AtomicLong sequence = new AtomicLong(1L);
    private final int length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassicUuidGenerator(String prefix) {
        String string2 = UNIQUE_STUB;
        synchronized (string2) {
            this.seed = prefix + UNIQUE_STUB + instanceCount++ + "-";
            this.seed = ClassicUuidGenerator.generateSanitizedId(this.seed);
            this.length = this.seed.length() + "9223372036854775807".length();
        }
    }

    public ClassicUuidGenerator() {
        this("ID-" + hostName);
    }

    public static String getHostName() {
        return hostName;
    }

    public static String sanitizeHostName(String hostName) {
        boolean changed = false;
        StringBuilder sb = new StringBuilder();
        for (char ch : hostName.toCharArray()) {
            if (ch < '\u007f') {
                sb.append(ch);
                continue;
            }
            changed = true;
        }
        if (changed) {
            String newHost = sb.toString();
            LOG.info("Sanitized hostname from: {} to: {}", (Object)hostName, (Object)newHost);
            return newHost;
        }
        return hostName;
    }

    @Override
    public String generateUuid() {
        StringBuilder sb = new StringBuilder(this.length);
        sb.append(this.seed);
        sb.append(this.sequence.getAndIncrement());
        return sb.toString();
    }

    public String generateSanitizedId() {
        return ClassicUuidGenerator.generateSanitizedId(this.generateUuid());
    }

    public static String generateSanitizedId(String id) {
        id = id.replace(':', '-');
        id = id.replace('_', '-');
        id = id.replace('.', '-');
        id = id.replace('/', '-');
        return id;
    }

    static {
        Object stub = "";
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            try {
                if (hostName == null) {
                    hostName = InetAddressUtil.getLocalHostName();
                }
                stub = "-" + System.currentTimeMillis() + "-";
            }
            catch (Exception e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Cannot generate unique stub by using DNS", (Throwable)e);
                }
                LOG.warn("Cannot generate unique stub by using DNS due {}. This exception is ignored.", (Object)e.getMessage());
            }
        }
        if (hostName == null) {
            hostName = "localhost";
        }
        hostName = ClassicUuidGenerator.sanitizeHostName(hostName);
        if (ObjectHelper.isEmpty((String)stub)) {
            stub = "-1-" + System.currentTimeMillis() + "-";
        }
        UNIQUE_STUB = stub;
    }
}

