/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.spi.HeaderFilterStrategy;

public class DefaultHeaderFilterStrategy
implements HeaderFilterStrategy {
    @Deprecated
    public static final Pattern CAMEL_FILTER_PATTERN = Pattern.compile("(?i)(Camel|org\\.apache\\.camel)[\\.|a-z|A-z|0-9]*");
    public static final String[] CAMEL_FILTER_STARTS_WITH = new String[]{"Camel", "camel", "org.apache.camel."};
    private Set<String> inFilter;
    private Pattern inFilterPattern;
    private String[] inFilterStartsWith;
    private Set<String> outFilter;
    private Pattern outFilterPattern;
    private String[] outFilterStartsWith;
    private boolean lowerCase;
    private boolean allowNullValues;
    private boolean caseInsensitive;
    private boolean filterOnMatch = true;

    @Override
    public boolean applyFilterToCamelHeaders(String headerName, Object headerValue, Exchange exchange) {
        return this.doFiltering(HeaderFilterStrategy.Direction.OUT, headerName, headerValue, exchange);
    }

    @Override
    public boolean applyFilterToExternalHeaders(String headerName, Object headerValue, Exchange exchange) {
        return this.doFiltering(HeaderFilterStrategy.Direction.IN, headerName, headerValue, exchange);
    }

    public Set<String> getOutFilter() {
        if (this.outFilter == null) {
            this.outFilter = new HashSet<String>();
        }
        return this.outFilter;
    }

    public void setOutFilter(Set<String> value) {
        this.outFilter = value;
    }

    public void setOutFilterStartsWith(String ... outFilterStartsWith) {
        this.outFilterStartsWith = outFilterStartsWith;
    }

    public String getOutFilterPattern() {
        return this.outFilterPattern == null ? null : this.outFilterPattern.pattern();
    }

    public void setOutFilterPattern(String value) {
        this.outFilterPattern = value == null ? null : Pattern.compile(value);
    }

    public void setOutFilterPattern(Pattern pattern) {
        this.outFilterPattern = pattern;
    }

    public Set<String> getInFilter() {
        if (this.inFilter == null) {
            this.inFilter = new HashSet<String>();
        }
        return this.inFilter;
    }

    public void setInFilter(Set<String> value) {
        this.inFilter = value;
    }

    public void setInFilterStartsWith(String ... inFilterStartsWith) {
        this.inFilterStartsWith = inFilterStartsWith;
    }

    public String getInFilterPattern() {
        return this.inFilterPattern == null ? null : this.inFilterPattern.pattern();
    }

    public void setInFilterPattern(String value) {
        this.inFilterPattern = value == null ? null : Pattern.compile(value);
    }

    public void setInFilterPattern(Pattern pattern) {
        this.inFilterPattern = pattern;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean value) {
        this.lowerCase = value;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public void setAllowNullValues(boolean value) {
        this.allowNullValues = value;
    }

    public boolean isFilterOnMatch() {
        return this.filterOnMatch;
    }

    public void setFilterOnMatch(boolean filterOnMatch) {
        this.filterOnMatch = filterOnMatch;
    }

    protected boolean extendedFilter(HeaderFilterStrategy.Direction direction, String key, Object value, Exchange exchange) {
        return !this.filterOnMatch;
    }

    private boolean doFiltering(HeaderFilterStrategy.Direction direction, String headerName, Object headerValue, Exchange exchange) {
        if (headerName == null) {
            return true;
        }
        if (headerValue == null && !this.allowNullValues) {
            return true;
        }
        Pattern pattern = null;
        Set<String> filter2 = null;
        String[] startsWith2 = null;
        if (HeaderFilterStrategy.Direction.OUT == direction) {
            pattern = this.outFilterPattern;
            filter2 = this.outFilter;
            startsWith2 = this.outFilterStartsWith;
        } else if (HeaderFilterStrategy.Direction.IN == direction) {
            pattern = this.inFilterPattern;
            filter2 = this.inFilter;
            startsWith2 = this.inFilterStartsWith;
        }
        if (startsWith2 != null) {
            for (String s2 : startsWith2) {
                boolean match = headerName.startsWith(s2);
                if (!match) continue;
                return this.filterOnMatch;
            }
        }
        if (pattern != null) {
            if (pattern == CAMEL_FILTER_PATTERN) {
                boolean match;
                boolean bl = match = headerName.startsWith("Camel") || headerName.startsWith("camel") || headerName.startsWith("org.apache.camel.");
                if (match) {
                    return this.filterOnMatch;
                }
            } else if (pattern.matcher(headerName).matches()) {
                return this.filterOnMatch;
            }
        }
        if (filter2 != null) {
            String lower;
            if (this.isCaseInsensitive()) {
                for (String filterString : filter2) {
                    if (!filterString.equalsIgnoreCase(headerName)) continue;
                    return this.filterOnMatch;
                }
            } else if (this.isLowerCase() ? filter2.contains(lower = headerName.toLowerCase(Locale.ENGLISH)) : filter2.contains(headerName)) {
                return this.filterOnMatch;
            }
        }
        return this.extendedFilter(direction, headerName, headerValue, exchange);
    }
}

