/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.management;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedNotification;
import org.apache.camel.api.management.ManagedNotifications;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanInfoAssembler
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanInfoAssembler.class);
    private final BeanIntrospection beanIntrospection;
    private Map<Class<?>, MBeanAttributesAndOperations> cache;

    public MBeanInfoAssembler(CamelContext camelContext) {
        ExtendedCamelContext ecc = camelContext.adapt(ExtendedCamelContext.class);
        this.beanIntrospection = ecc.getBeanIntrospection();
    }

    @Override
    public void start() {
        this.cache = LRUCacheFactory.newLRUWeakCache(1000);
    }

    @Override
    public void stop() {
        if (this.cache != null) {
            if (LOG.isDebugEnabled() && this.cache instanceof LRUCache) {
                LRUCache cache = (LRUCache)this.cache;
                LOG.debug("Clearing cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{cache.size(), cache.getHits(), cache.getMisses(), cache.getEvicted()});
            }
            this.cache.clear();
        }
    }

    public ModelMBeanInfo getMBeanInfo(CamelContext camelContext, Object defaultManagedBean, Object customManagedBean, String objectName) throws JMException {
        if (defaultManagedBean != null && Proxy.isProxyClass(defaultManagedBean.getClass())) {
            LOG.trace("Skip creating ModelMBeanInfo due proxy class {}", defaultManagedBean.getClass());
            return null;
        }
        LinkedHashMap<String, ManagedAttributeInfo> attributes = new LinkedHashMap<String, ManagedAttributeInfo>();
        LinkedHashSet<ManagedOperationInfo> operations = new LinkedHashSet<ManagedOperationInfo>();
        LinkedHashSet<ModelMBeanAttributeInfo> mBeanAttributes = new LinkedHashSet<ModelMBeanAttributeInfo>();
        LinkedHashSet<ModelMBeanOperationInfo> mBeanOperations = new LinkedHashSet<ModelMBeanOperationInfo>();
        LinkedHashSet<ModelMBeanNotificationInfo> mBeanNotifications = new LinkedHashSet<ModelMBeanNotificationInfo>();
        if (defaultManagedBean != null) {
            this.extractAttributesAndOperations(camelContext, defaultManagedBean.getClass(), attributes, operations);
            this.extractMbeanAttributes(defaultManagedBean, attributes, mBeanAttributes, mBeanOperations);
            this.extractMbeanOperations(defaultManagedBean, operations, mBeanOperations);
            this.extractMbeanNotifications(defaultManagedBean, mBeanNotifications);
        }
        if (customManagedBean != null) {
            this.extractAttributesAndOperations(camelContext, customManagedBean.getClass(), attributes, operations);
            this.extractMbeanAttributes(customManagedBean, attributes, mBeanAttributes, mBeanOperations);
            this.extractMbeanOperations(customManagedBean, operations, mBeanOperations);
            this.extractMbeanNotifications(customManagedBean, mBeanNotifications);
        }
        String name = this.getName(customManagedBean != null ? customManagedBean : defaultManagedBean, objectName);
        String description = this.getDescription(customManagedBean != null ? customManagedBean : defaultManagedBean, objectName);
        ModelMBeanAttributeInfo[] arrayAttributes = mBeanAttributes.toArray(new ModelMBeanAttributeInfo[mBeanAttributes.size()]);
        ModelMBeanOperationInfo[] arrayOperations = mBeanOperations.toArray(new ModelMBeanOperationInfo[mBeanOperations.size()]);
        ModelMBeanNotificationInfo[] arrayNotifications = mBeanNotifications.toArray(new ModelMBeanNotificationInfo[mBeanNotifications.size()]);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(name, description, arrayAttributes, null, arrayOperations, arrayNotifications);
        LOG.trace("Created ModelMBeanInfo {}", (Object)info);
        return info;
    }

    private void extractAttributesAndOperations(CamelContext camelContext, Class<?> managedClass, Map<String, ManagedAttributeInfo> attributes, Set<ManagedOperationInfo> operations) {
        MBeanAttributesAndOperations cached = this.cache.get(managedClass);
        if (cached == null) {
            this.doExtractAttributesAndOperations(camelContext, managedClass, attributes, operations);
            cached = new MBeanAttributesAndOperations();
            cached.attributes = new LinkedHashMap<String, ManagedAttributeInfo>(attributes);
            cached.operations = new LinkedHashSet<ManagedOperationInfo>(operations);
            attributes.clear();
            operations.clear();
            this.cache.put(managedClass, cached);
        }
        attributes.putAll(cached.attributes);
        operations.addAll(cached.operations);
    }

    private void doExtractAttributesAndOperations(CamelContext camelContext, Class<?> managedClass, Map<String, ManagedAttributeInfo> attributes, Set<ManagedOperationInfo> operations) {
        Class<?> clazz;
        this.doDoExtractAttributesAndOperations(camelContext, managedClass, attributes, operations);
        if (managedClass.getSuperclass() != null && !(clazz = managedClass.getSuperclass()).getName().startsWith("java")) {
            LOG.trace("Extracting attributes and operations from sub class: {}", clazz);
            this.doExtractAttributesAndOperations(camelContext, clazz, attributes, operations);
        }
        if (managedClass.getInterfaces() != null) {
            for (Class<?> clazz2 : managedClass.getInterfaces()) {
                if (clazz2.getName().startsWith("java")) continue;
                LOG.trace("Extracting attributes and operations from implemented interface: {}", clazz2);
                this.doExtractAttributesAndOperations(camelContext, clazz2, attributes, operations);
            }
        }
    }

    private void doDoExtractAttributesAndOperations(CamelContext camelContext, Class<?> managedClass, Map<String, ManagedAttributeInfo> attributes, Set<ManagedOperationInfo> operations) {
        LOG.trace("Extracting attributes and operations from class: {}", managedClass);
        BeanIntrospection.ClassInfo cache = this.beanIntrospection.cacheClass(managedClass);
        for (BeanIntrospection.MethodInfo cacheInfo : cache.methods) {
            ManagedOperation mo;
            String desc;
            if (cacheInfo.method.getDeclaringClass() != managedClass) continue;
            LOG.trace("Extracting attributes and operations from method: {}", (Object)cacheInfo.method);
            ManagedAttribute ma = cacheInfo.method.getAnnotation(ManagedAttribute.class);
            if (ma != null) {
                String key;
                desc = ma.description();
                Method getter2 = null;
                Method setter2 = null;
                boolean mask = ma.mask();
                if (cacheInfo.isGetter.booleanValue()) {
                    key = cacheInfo.getterOrSetterShorthandName;
                    getter2 = cacheInfo.method;
                } else if (cacheInfo.isSetter.booleanValue()) {
                    key = cacheInfo.getterOrSetterShorthandName;
                    setter2 = cacheInfo.method;
                } else {
                    throw new IllegalArgumentException("@ManagedAttribute can only be used on Java bean methods, was: " + cacheInfo.method + " on bean: " + managedClass);
                }
                key = StringHelper.capitalize(key);
                ManagedAttributeInfo info = attributes.get(key);
                if (info == null) {
                    info = new ManagedAttributeInfo(key, desc);
                }
                if (getter2 != null) {
                    info.setGetter(getter2);
                }
                if (setter2 != null) {
                    info.setSetter(setter2);
                }
                info.setMask(mask);
                attributes.put(key, info);
            }
            if ((mo = cacheInfo.method.getAnnotation(ManagedOperation.class)) == null) continue;
            desc = mo.description();
            Method operation = cacheInfo.method;
            boolean mask = mo.mask();
            operations.add(new ManagedOperationInfo(desc, operation, mask));
        }
    }

    private void extractMbeanAttributes(Object managedBean, Map<String, ManagedAttributeInfo> attributes, Set<ModelMBeanAttributeInfo> mBeanAttributes, Set<ModelMBeanOperationInfo> mBeanOperations) throws IntrospectionException {
        for (ManagedAttributeInfo info : attributes.values()) {
            ModelMBeanOperationInfo mbeanOperation;
            ModelMBeanAttributeInfo mbeanAttribute = new ModelMBeanAttributeInfo(info.getKey(), info.getDescription(), info.getGetter(), info.getSetter());
            Descriptor desc = mbeanAttribute.getDescriptor();
            desc.setField("mask", info.isMask() ? "true" : "false");
            if (info.getGetter() != null) {
                desc.setField("getMethod", info.getGetter().getName());
                mbeanOperation = new ModelMBeanOperationInfo(info.getKey(), info.getGetter());
                Descriptor opDesc = mbeanOperation.getDescriptor();
                opDesc.setField("mask", info.isMask() ? "true" : "false");
                mbeanOperation.setDescriptor(opDesc);
                mBeanOperations.add(mbeanOperation);
            }
            if (info.getSetter() != null) {
                desc.setField("setMethod", info.getSetter().getName());
                mbeanOperation = new ModelMBeanOperationInfo(info.getKey(), info.getSetter());
                mBeanOperations.add(mbeanOperation);
            }
            mbeanAttribute.setDescriptor(desc);
            mBeanAttributes.add(mbeanAttribute);
            LOG.trace("Assembled attribute: {}", (Object)mbeanAttribute);
        }
    }

    private void extractMbeanOperations(Object managedBean, Set<ManagedOperationInfo> operations, Set<ModelMBeanOperationInfo> mBeanOperations) {
        for (ManagedOperationInfo info : operations) {
            ModelMBeanOperationInfo mbean = new ModelMBeanOperationInfo(info.getDescription(), info.getOperation());
            Descriptor opDesc = mbean.getDescriptor();
            opDesc.setField("mask", info.isMask() ? "true" : "false");
            mbean.setDescriptor(opDesc);
            mBeanOperations.add(mbean);
            LOG.trace("Assembled operation: {}", (Object)mbean);
        }
    }

    private void extractMbeanNotifications(Object managedBean, Set<ModelMBeanNotificationInfo> mBeanNotifications) {
        ManagedNotifications notifications = managedBean.getClass().getAnnotation(ManagedNotifications.class);
        if (notifications != null) {
            for (ManagedNotification notification : notifications.value()) {
                ModelMBeanNotificationInfo info = new ModelMBeanNotificationInfo(notification.notificationTypes(), notification.name(), notification.description());
                mBeanNotifications.add(info);
                LOG.trace("Assembled notification: {}", (Object)info);
            }
        }
    }

    private String getDescription(Object managedBean, String objectName) {
        ManagedResource mr = ObjectHelper.getAnnotation(managedBean, ManagedResource.class);
        return mr != null ? mr.description() : "";
    }

    private String getName(Object managedBean, String objectName) {
        return managedBean.getClass().getName();
    }

    private static final class ManagedOperationInfo {
        private final String description;
        private final Method operation;
        private final boolean mask;

        private ManagedOperationInfo(String description, Method operation, boolean mask) {
            this.description = description;
            this.operation = operation;
            this.mask = mask;
        }

        public String getDescription() {
            return this.description;
        }

        public Method getOperation() {
            return this.operation;
        }

        public boolean isMask() {
            return this.mask;
        }

        public String toString() {
            return "ManagedOperationInfo: [" + this.operation + "]";
        }
    }

    private static final class ManagedAttributeInfo {
        private String key;
        private String description;
        private Method getter;
        private Method setter;
        private boolean mask;

        private ManagedAttributeInfo(String key, String description) {
            this.key = key;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public Method getGetter() {
            return this.getter;
        }

        public void setGetter(Method getter2) {
            this.getter = getter2;
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setSetter(Method setter2) {
            this.setter = setter2;
        }

        public boolean isMask() {
            return this.mask;
        }

        public void setMask(boolean mask) {
            this.mask = mask;
        }

        public String toString() {
            return "ManagedAttributeInfo: [" + this.key + " + getter: " + this.getter + ", setter: " + this.setter + "]";
        }
    }

    private static final class MBeanAttributesAndOperations {
        private Map<String, ManagedAttributeInfo> attributes;
        private Set<ManagedOperationInfo> operations;

        private MBeanAttributesAndOperations() {
        }
    }
}

