/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.resume;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.Resumable;
import org.apache.camel.support.resume.Offsets;

public final class Resumables {
    private Resumables() {
    }

    public static <K, V> Resumable of(K addressable, V offset) {
        return new AnonymousResumable<K, V>(addressable, offset);
    }

    public static <T> T[] resumeEach(T[] input2, Predicate<T> resumableCheck) {
        Object[] tmp = (Object[])Array.newInstance(input2.getClass().getComponentType(), input2.length);
        int count2 = 0;
        for (T entry : input2) {
            if (!resumableCheck.test(entry)) continue;
            tmp[count2] = entry;
            ++count2;
        }
        if (count2 != input2.length) {
            return Arrays.copyOf(tmp, count2);
        }
        return input2;
    }

    private static class AnonymousResumable<K, V>
    implements Resumable {
        private final K addressable;
        private V offset;

        public AnonymousResumable(K addressable) {
            this.addressable = addressable;
        }

        public AnonymousResumable(K addressable, V offset) {
            this.addressable = addressable;
            this.offset = offset;
        }

        public Offset<V> getLastOffset() {
            return Offsets.of(this.offset);
        }

        public OffsetKey<K> getOffsetKey() {
            return new OffsetKey<K>(){
                private final K key;
                {
                    this.key = addressable;
                }

                @Override
                public void setValue(K key) {
                    throw new UnsupportedOperationException("Setting offset keys for anonymous resumables is unsupported");
                }

                @Override
                public K getValue() {
                    return this.key;
                }
            };
        }
    }
}

