/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.util.BaseOrderedProperties;

public final class OrderedLocationProperties
extends BaseOrderedProperties {
    private final Map<Object, String> locations = new HashMap<Object, String>();
    private final Map<Object, Object> defaultValues = new HashMap<Object, Object>();

    public void put(String location, Object key, Object value) {
        this.locations.put(key, location);
        this.put(key, value);
    }

    public void put(String location, Object key, Object value, Object defaultValue) {
        this.put(location, key, value);
        if (defaultValue != null) {
            this.defaultValues.put(key, defaultValue);
        }
    }

    public void putAll(OrderedLocationProperties other) {
        for (Map.Entry entry : other.entrySet()) {
            this.put(other.getLocation(entry.getKey()), entry.getKey(), entry.getValue(), other.getDefaultValue(entry.getKey()));
        }
    }

    public void putAll(String location, Map<Object, Object> map2) {
        for (Map.Entry<Object, Object> entry : map2.entrySet()) {
            this.put(location, entry.getKey(), entry.getValue());
        }
    }

    public void putAll(String location, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.put(location, entry.getKey(), entry.getValue());
        }
    }

    public String getLocation(Object key) {
        return this.locations.get(key);
    }

    public Object getDefaultValue(Object key) {
        return this.defaultValues.get(key);
    }

    @Override
    public synchronized void clear() {
        this.locations.clear();
        this.defaultValues.clear();
        super.clear();
    }

    @Override
    public synchronized Object remove(Object key) {
        this.locations.remove(key);
        this.defaultValues.remove(key);
        return super.remove(key);
    }
}

