/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

public class PGPSignature {
    public static final int BINARY_DOCUMENT = 0;
    public static final int CANONICAL_TEXT_DOCUMENT = 1;
    public static final int STAND_ALONE = 2;
    public static final int DEFAULT_CERTIFICATION = 16;
    public static final int NO_CERTIFICATION = 17;
    public static final int CASUAL_CERTIFICATION = 18;
    public static final int POSITIVE_CERTIFICATION = 19;
    public static final int SUBKEY_BINDING = 24;
    public static final int PRIMARYKEY_BINDING = 25;
    public static final int DIRECT_KEY = 31;
    public static final int KEY_REVOCATION = 32;
    public static final int SUBKEY_REVOCATION = 40;
    public static final int CERTIFICATION_REVOCATION = 48;
    public static final int TIMESTAMP = 64;
    private SignaturePacket sigPck;
    private int signatureType;
    private TrustPacket trustPck;
    private PGPContentVerifier verifier;
    private byte lastb;
    private OutputStream sigOut;

    private static SignaturePacket cast(Packet packet) throws IOException {
        if (!(packet instanceof SignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (SignaturePacket)packet;
    }

    PGPSignature(BCPGInputStream bCPGInputStream) throws IOException, PGPException {
        this(PGPSignature.cast(bCPGInputStream.readPacket()));
    }

    PGPSignature(SignaturePacket signaturePacket) throws PGPException {
        this.sigPck = signaturePacket;
        this.signatureType = this.sigPck.getSignatureType();
        this.trustPck = null;
    }

    PGPSignature(SignaturePacket signaturePacket, TrustPacket trustPacket) throws PGPException {
        this(signaturePacket);
        this.trustPck = trustPacket;
    }

    public int getVersion() {
        return this.sigPck.getVersion();
    }

    public int getKeyAlgorithm() {
        return this.sigPck.getKeyAlgorithm();
    }

    public int getHashAlgorithm() {
        return this.sigPck.getHashAlgorithm();
    }

    public boolean isCertification() {
        return PGPSignature.isCertification(this.getSignatureType());
    }

    public void init(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, PGPPublicKey pGPPublicKey) throws PGPException {
        PGPContentVerifierBuilder pGPContentVerifierBuilder = pGPContentVerifierBuilderProvider.get(this.sigPck.getKeyAlgorithm(), this.sigPck.getHashAlgorithm());
        this.verifier = pGPContentVerifierBuilder.build(pGPPublicKey);
        this.lastb = 0;
        this.sigOut = this.verifier.getOutputStream();
    }

    public void update(byte by2) {
        if (this.signatureType == 1) {
            if (by2 == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (by2 == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(by2);
            }
            this.lastb = by2;
        } else {
            this.byteUpdate(by2);
        }
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.signatureType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.blockUpdate(byArray, n, n2);
        }
    }

    private void byteUpdate(byte by2) {
        try {
            this.sigOut.write(by2);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException(iOException.getMessage(), iOException);
        }
    }

    private void blockUpdate(byte[] byArray, int n, int n2) {
        try {
            this.sigOut.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException(iOException.getMessage(), iOException);
        }
    }

    public boolean verify() throws PGPException {
        try {
            this.sigOut.write(this.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException iOException) {
            throw new PGPException(iOException.getMessage(), iOException);
        }
        return this.verifier.verify(this.getSignature());
    }

    private void updateWithIdData(int n, byte[] byArray) {
        this.update((byte)n);
        this.update((byte)(byArray.length >> 24));
        this.update((byte)(byArray.length >> 16));
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }

    private void updateWithPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        byte[] byArray = this.getEncodedPublicKey(pGPPublicKey);
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }

    public boolean verifyCertification(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPPublicKey pGPPublicKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        this.updateWithPublicKey(pGPPublicKey);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            UserAttributeSubpacket[] userAttributeSubpacketArray = pGPUserAttributeSubpacketVector.toSubpacketArray();
            for (int i = 0; i != userAttributeSubpacketArray.length; ++i) {
                userAttributeSubpacketArray[i].encode(byteArrayOutputStream);
            }
            this.updateWithIdData(209, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new PGPException("cannot encode subpacket array", iOException);
        }
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(String string2, PGPPublicKey pGPPublicKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithIdData(180, Strings.toUTF8ByteArray(string2));
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(byte[] byArray, PGPPublicKey pGPPublicKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithIdData(180, byArray);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithPublicKey(pGPPublicKey2);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    private void addTrailer() {
        try {
            this.sigOut.write(this.sigPck.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException(iOException.getMessage(), iOException);
        }
    }

    public boolean verifyCertification(PGPPublicKey pGPPublicKey) throws PGPException {
        if (this.verifier == null) {
            throw new PGPException("PGPSignature not initialised - call init().");
        }
        if (this.getSignatureType() != 32 && this.getSignatureType() != 40 && this.getSignatureType() != 31) {
            throw new PGPException("signature is not a key signature");
        }
        this.updateWithPublicKey(pGPPublicKey);
        this.addTrailer();
        return this.verifier.verify(this.getSignature());
    }

    public int getSignatureType() {
        return this.sigPck.getSignatureType();
    }

    public long getKeyID() {
        return this.sigPck.getKeyID();
    }

    public Date getCreationTime() {
        return new Date(this.sigPck.getCreationTime());
    }

    public byte[] getSignatureTrailer() {
        return this.sigPck.getSignatureTrailer();
    }

    public boolean hasSubpackets() {
        return this.sigPck.getHashedSubPackets() != null || this.sigPck.getUnhashedSubPackets() != null;
    }

    public PGPSignatureSubpacketVector getHashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getHashedSubPackets());
    }

    public PGPSignatureSubpacketVector getUnhashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getUnhashedSubPackets());
    }

    private PGPSignatureSubpacketVector createSubpacketVector(SignatureSubpacket[] signatureSubpacketArray) {
        if (signatureSubpacketArray != null) {
            return new PGPSignatureSubpacketVector(signatureSubpacketArray);
        }
        return null;
    }

    public byte[] getSignature() throws PGPException {
        byte[] byArray;
        MPInteger[] mPIntegerArray = this.sigPck.getSignature();
        if (mPIntegerArray != null) {
            if (mPIntegerArray.length == 1) {
                byArray = BigIntegers.asUnsignedByteArray(mPIntegerArray[0].getValue());
            } else if (this.getKeyAlgorithm() == 22) {
                byArray = new byte[64];
                byte[] byArray2 = BigIntegers.asUnsignedByteArray(mPIntegerArray[0].getValue());
                byte[] byArray3 = BigIntegers.asUnsignedByteArray(mPIntegerArray[1].getValue());
                System.arraycopy(byArray2, 0, byArray, 32 - byArray2.length, byArray2.length);
                System.arraycopy(byArray3, 0, byArray, 64 - byArray3.length, byArray3.length);
            } else {
                try {
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    aSN1EncodableVector.add(new ASN1Integer(mPIntegerArray[0].getValue()));
                    aSN1EncodableVector.add(new ASN1Integer(mPIntegerArray[1].getValue()));
                    byArray = new DERSequence(aSN1EncodableVector).getEncoded();
                }
                catch (IOException iOException) {
                    throw new PGPException("exception encoding DSA sig.", iOException);
                }
            }
        } else {
            byArray = this.sigPck.getSignatureBytes();
        }
        return byArray;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.sigPck);
        if (!bl && this.trustPck != null) {
            bCPGOutputStream.writePacket(this.trustPck);
        }
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        byte[] byArray;
        try {
            byArray = pGPPublicKey.publicPk.getEncodedContents();
        }
        catch (IOException iOException) {
            throw new PGPException("exception preparing key.", iOException);
        }
        return byArray;
    }

    public static boolean isCertification(int n) {
        return 16 == n || 17 == n || 18 == n || 19 == n;
    }
}

