/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import org.bouncycastle.openpgp.PGPException;

public class PGPPad {
    private PGPPad() {
    }

    public static byte[] padSessionData(byte[] byArray) {
        return PGPPad.padSessionData(byArray, true);
    }

    public static byte[] padSessionData(byte[] byArray, boolean bl) {
        int n = byArray.length;
        int n2 = (n >>> 3) + 1 << 3;
        if (bl) {
            n2 = Math.max(40, n2);
        }
        int n3 = n2 - n;
        byte by2 = (byte)n3;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        for (int i = n; i < n2; ++i) {
            byArray2[i] = by2;
        }
        return byArray2;
    }

    public static byte[] unpadSessionData(byte[] byArray) throws PGPException {
        int n = byArray.length;
        byte by2 = byArray[n - 1];
        int n2 = by2 & 0xFF;
        int n3 = n - n2;
        int n4 = n3 - 1;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6 = n4 - i >> 31;
            n5 |= (by2 ^ byArray[i]) & n6;
        }
        n5 |= n & 7;
        if ((n5 |= 40 - n >> 31) != 0) {
            throw new PGPException("bad padding found in session data");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }
}

