/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean.producer;

import com.myjeeva.digitalocean.pojo.Delete;
import com.myjeeva.digitalocean.pojo.Tag;
import com.myjeeva.digitalocean.pojo.Tags;
import org.apache.camel.Exchange;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.producer.DigitalOceanProducer;
import org.apache.camel.util.ObjectHelper;

public class DigitalOceanTagsProducer
extends DigitalOceanProducer {
    public DigitalOceanTagsProducer(DigitalOceanEndpoint endpoint, DigitalOceanConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case list: {
                this.getTags(exchange);
                break;
            }
            case create: {
                this.createTag(exchange);
                break;
            }
            case get: {
                this.getTag(exchange);
                break;
            }
            case delete: {
                this.deleteTag(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void createTag(Exchange exchange) throws Exception {
        String name = (String)exchange.getIn().getHeader("CamelDigitalOceanName", String.class);
        if (ObjectHelper.isEmpty((Object)name)) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        Tag tag = this.getEndpoint().getDigitalOceanClient().createTag(name);
        LOG.trace("Create Tag [{}] ", (Object)tag);
        exchange.getOut().setBody((Object)tag);
    }

    private void getTag(Exchange exchange) throws Exception {
        String name = (String)exchange.getIn().getHeader("CamelDigitalOceanName", String.class);
        if (ObjectHelper.isEmpty((Object)name)) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        Tag tag = this.getEndpoint().getDigitalOceanClient().getTag(name);
        LOG.trace("Tag [{}] ", (Object)tag);
        exchange.getOut().setBody((Object)tag);
    }

    private void getTags(Exchange exchange) throws Exception {
        Tags tags = this.getEndpoint().getDigitalOceanClient().getAvailableTags(this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("All Tags : page {} / {} per page [{}] ", new Object[]{this.configuration.getPage(), this.configuration.getPerPage(), tags.getTags()});
        exchange.getOut().setBody(tags.getTags());
    }

    private void deleteTag(Exchange exchange) throws Exception {
        String name = (String)exchange.getIn().getHeader("CamelDigitalOceanName", String.class);
        if (ObjectHelper.isEmpty((Object)name)) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        Delete delete = this.getEndpoint().getDigitalOceanClient().deleteTag(name);
        LOG.trace("Delete Tag [{}] ", (Object)delete);
        exchange.getOut().setBody((Object)delete);
    }
}

