/*
 * Decompiled with CFR 0.152.
 */
package com.myjeeva.digitalocean.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.myjeeva.digitalocean.pojo.Droplet;
import com.myjeeva.digitalocean.pojo.Key;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;

public class DropletSerializer
implements JsonSerializer<Droplet> {
    @Override
    public JsonElement serialize(Droplet droplet, Type paramType, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", droplet.getName());
        if (null != droplet.getNames() && !droplet.getNames().isEmpty()) {
            JsonArray names = new JsonArray();
            for (String name : droplet.getNames()) {
                names.add(context.serialize(name));
            }
            jsonObject.add("names", names);
        }
        jsonObject.addProperty("region", droplet.getRegion().getSlug());
        jsonObject.addProperty("size", droplet.getSize());
        if (null == droplet.getImage().getId()) {
            jsonObject.addProperty("image", droplet.getImage().getSlug());
        } else {
            jsonObject.addProperty("image", droplet.getImage().getId());
        }
        if (null != droplet.getEnableBackup()) {
            jsonObject.addProperty("backups", droplet.getEnableBackup());
        }
        if (null != droplet.getEnableIpv6()) {
            jsonObject.addProperty("ipv6", droplet.getEnableIpv6());
        }
        if (null != droplet.getEnablePrivateNetworking()) {
            jsonObject.addProperty("private_networking", droplet.getEnablePrivateNetworking());
        }
        if (null != droplet.getKeys() && !droplet.getKeys().isEmpty()) {
            JsonArray sshKeys = new JsonArray();
            for (Key k : droplet.getKeys()) {
                if (null != k.getId()) {
                    sshKeys.add(context.serialize(k.getId()));
                }
                if (StringUtils.isBlank(k.getFingerprint())) continue;
                sshKeys.add(context.serialize(k.getFingerprint()));
            }
            jsonObject.add("ssh_keys", sshKeys);
        }
        if (null != droplet.getUserData()) {
            jsonObject.addProperty("user_data", droplet.getUserData());
        }
        if (null != droplet.getVolumeIds() && !droplet.getVolumeIds().isEmpty()) {
            JsonArray volumes = new JsonArray();
            for (String volume : droplet.getVolumeIds()) {
                volumes.add(context.serialize(volume));
            }
            jsonObject.add("volumes", volumes);
        }
        if (null != droplet.getTags() && !droplet.getTags().isEmpty()) {
            JsonArray tags = new JsonArray();
            for (String tag : droplet.getTags()) {
                tags.add(context.serialize(tag));
            }
            jsonObject.add("tags", tags);
        }
        if (null != droplet.getInstallMonitoring()) {
            jsonObject.addProperty("monitoring", droplet.getInstallMonitoring());
        }
        return jsonObject;
    }
}

