/*
 * Decompiled with CFR 0.152.
 */
package com.myjeeva.digitalocean.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.myjeeva.digitalocean.pojo.Volume;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;

public class VolumeSerializer
implements JsonSerializer<Volume> {
    @Override
    public JsonElement serialize(Volume volume, Type paramType, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", volume.getId());
        jsonObject.addProperty("name", volume.getName());
        if (StringUtils.isNotBlank(volume.getDescription())) {
            jsonObject.addProperty("description", volume.getDescription());
        }
        if (StringUtils.isNotBlank(volume.getRegion().getSlug())) {
            jsonObject.addProperty("region", volume.getRegion().getSlug());
        }
        if (StringUtils.isNotBlank(volume.getSnapshotId())) {
            jsonObject.addProperty("snapshot_id", volume.getSnapshotId());
        }
        if (null != volume.getSize()) {
            jsonObject.addProperty("size_gigabytes", volume.getSize());
        }
        if (StringUtils.isNotBlank(volume.getFileSystemType())) {
            jsonObject.addProperty("filesystem_type", volume.getFileSystemType());
        }
        if (StringUtils.isNotBlank(volume.getFileSystemLabel())) {
            jsonObject.addProperty("filesystem_label", volume.getFileSystemLabel());
        }
        if (null != volume.getTags() && !volume.getTags().isEmpty()) {
            JsonArray tags = new JsonArray();
            for (String tag : volume.getTags()) {
                tags.add(context.serialize(tag));
            }
            jsonObject.add("tags", tags);
        }
        return jsonObject;
    }
}

