/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean;

import com.myjeeva.digitalocean.impl.DigitalOceanClient;
import org.apache.camel.CamelContext;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.constants.DigitalOceanResources;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class DigitalOceanEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DigitalOceanEndpoint target = (DigitalOceanEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "digitaloceanclient": 
            case "digitalOceanClient": {
                target.getConfiguration().setDigitalOceanClient(DigitalOceanEndpointConfigurer.property(camelContext, DigitalOceanClient.class, value));
                return true;
            }
            case "httpproxyhost": 
            case "httpProxyHost": {
                target.getConfiguration().setHttpProxyHost(DigitalOceanEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "httpproxypassword": 
            case "httpProxyPassword": {
                target.getConfiguration().setHttpProxyPassword(DigitalOceanEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "httpproxyport": 
            case "httpProxyPort": {
                target.getConfiguration().setHttpProxyPort(DigitalOceanEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "httpproxyuser": 
            case "httpProxyUser": {
                target.getConfiguration().setHttpProxyUser(DigitalOceanEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(DigitalOceanEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "oauthtoken": 
            case "oAuthToken": {
                target.getConfiguration().setOAuthToken(DigitalOceanEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "page": {
                target.getConfiguration().setPage(DigitalOceanEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "perpage": 
            case "perPage": {
                target.getConfiguration().setPerPage(DigitalOceanEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "resource": {
                target.getConfiguration().setResource(DigitalOceanEndpointConfigurer.property(camelContext, DigitalOceanResources.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "digitaloceanclient": 
            case "digitalOceanClient": {
                return DigitalOceanClient.class;
            }
            case "httpproxyhost": 
            case "httpProxyHost": {
                return String.class;
            }
            case "httpproxypassword": 
            case "httpProxyPassword": {
                return String.class;
            }
            case "httpproxyport": 
            case "httpProxyPort": {
                return Integer.class;
            }
            case "httpproxyuser": 
            case "httpProxyUser": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "oauthtoken": 
            case "oAuthToken": {
                return String.class;
            }
            case "page": {
                return Integer.class;
            }
            case "perpage": 
            case "perPage": {
                return Integer.class;
            }
            case "resource": {
                return DigitalOceanResources.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DigitalOceanEndpoint target = (DigitalOceanEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "digitaloceanclient": 
            case "digitalOceanClient": {
                return target.getConfiguration().getDigitalOceanClient();
            }
            case "httpproxyhost": 
            case "httpProxyHost": {
                return target.getConfiguration().getHttpProxyHost();
            }
            case "httpproxypassword": 
            case "httpProxyPassword": {
                return target.getConfiguration().getHttpProxyPassword();
            }
            case "httpproxyport": 
            case "httpProxyPort": {
                return target.getConfiguration().getHttpProxyPort();
            }
            case "httpproxyuser": 
            case "httpProxyUser": {
                return target.getConfiguration().getHttpProxyUser();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "oauthtoken": 
            case "oAuthToken": {
                return target.getConfiguration().getOAuthToken();
            }
            case "page": {
                return target.getConfiguration().getPage();
            }
            case "perpage": 
            case "perPage": {
                return target.getConfiguration().getPerPage();
            }
            case "resource": {
                return target.getConfiguration().getResource();
            }
        }
        return null;
    }
}

