/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.constants.DigitalOceanOperations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DigitalOceanProducer
extends DefaultProducer {
    protected static final Logger LOG = LoggerFactory.getLogger(DigitalOceanProducer.class);
    protected DigitalOceanConfiguration configuration;
    private DigitalOceanEndpoint endpoint;

    public DigitalOceanProducer(DigitalOceanEndpoint endpoint, DigitalOceanConfiguration configuration) {
        super(endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    protected DigitalOceanOperations determineOperation(Exchange exchange) {
        DigitalOceanOperations operation = exchange.getIn().getHeader("CamelDigitalOceanOperation", DigitalOceanOperations.class);
        return ObjectHelper.isNotEmpty(operation) ? operation : this.configuration.getOperation();
    }

    @Override
    public DigitalOceanEndpoint getEndpoint() {
        return this.endpoint;
    }
}

