/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.util.SensitiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMaskingFormatter
implements MaskingFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMaskingFormatter.class);
    private final Set<String> keywords;
    private boolean maskKeyValue;
    private boolean maskXmlElement;
    private boolean maskJson;
    private String maskString = "xxxxx";
    private Pattern keyValueMaskPattern;
    private Pattern xmlElementMaskPattern;
    private Pattern jsonMaskPattern;

    public DefaultMaskingFormatter() {
        this(SensitiveUtils.getSensitiveKeys(), true, true, true);
    }

    public DefaultMaskingFormatter(boolean maskKeyValue, boolean maskXml, boolean maskJson) {
        this(SensitiveUtils.getSensitiveKeys(), maskKeyValue, maskXml, maskJson);
    }

    public DefaultMaskingFormatter(Set<String> keywords, boolean maskKeyValue, boolean maskXmlElement, boolean maskJson) {
        this.keywords = new TreeSet<String>(keywords);
        this.setMaskKeyValue(maskKeyValue);
        this.setMaskXmlElement(maskXmlElement);
        this.setMaskJson(maskJson);
        this.initPatterns();
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
        this.initPatterns();
    }

    public void setCustomKeywords(Set<String> keywords) {
        this.keywords.addAll(keywords);
        this.initPatterns();
    }

    public String getMaskString() {
        return this.maskString;
    }

    public void setMaskString(String maskString) {
        this.maskString = maskString;
    }

    @Override
    public String format(String source) {
        if (this.keywords == null || this.keywords.isEmpty()) {
            return source;
        }
        boolean xml = this.maskXmlElement && source.startsWith("<");
        boolean json = this.maskJson && !xml && (source.startsWith("{") || source.startsWith("["));
        String answer = source;
        if (xml) {
            answer = this.xmlElementMaskPattern.matcher(answer).replaceAll("$1" + this.maskString + "$3");
            if (this.maskKeyValue) {
                answer = this.keyValueMaskPattern.matcher(answer).replaceAll("$1" + this.maskString);
            }
        } else if (json) {
            answer = this.jsonMaskPattern.matcher(answer).replaceAll("\"$1\"$2:$3\"" + this.maskString + "\"");
        } else if (this.maskKeyValue) {
            answer = this.keyValueMaskPattern.matcher(answer).replaceAll("$1" + this.maskString);
        }
        return answer;
    }

    public boolean isMaskKeyValue() {
        return this.maskKeyValue;
    }

    public void setMaskKeyValue(boolean maskKeyValue) {
        this.maskKeyValue = maskKeyValue;
    }

    public boolean isMaskXmlElement() {
        return this.maskXmlElement;
    }

    public void setMaskXmlElement(boolean maskXml) {
        this.maskXmlElement = maskXml;
    }

    public boolean isMaskJson() {
        return this.maskJson;
    }

    public void setMaskJson(boolean maskJson) {
        this.maskJson = maskJson;
    }

    protected void initPatterns() {
        this.keyValueMaskPattern = this.maskKeyValue ? this.createKeyValueMaskPattern(this.keywords) : null;
        this.xmlElementMaskPattern = this.maskXmlElement ? this.createXmlElementMaskPattern(this.keywords) : null;
        this.jsonMaskPattern = this.maskJson ? this.createJsonMaskPattern(this.keywords) : null;
    }

    protected Pattern createKeyValueMaskPattern(Set<String> keywords) {
        StringBuilder regex = this.createOneOfThemRegex(keywords);
        if (regex == null) {
            return null;
        }
        regex.insert(0, "([\\w]*(?:");
        regex.append(")[\\w]*[\\s]*?=[\\s]*?['\"]?)([^'\",]+)");
        if (LOG.isDebugEnabled()) {
            LOG.debug("KeyValue Pattern: {}", (Object)regex);
        }
        return Pattern.compile(regex.toString(), 2);
    }

    protected Pattern createXmlElementMaskPattern(Set<String> keywords) {
        StringBuilder regex = this.createOneOfThemRegex(keywords);
        if (regex == null) {
            return null;
        }
        regex.insert(0, "(<([\\w]*(?:");
        regex.append(")[\\w]*)(?:[\\s]+.+)*?>[\\s]*?)(?:[\\S&&[^<]]+(?:\\s+[\\S&&[^<]]+)*?)([\\s]*?</\\2>)");
        if (LOG.isDebugEnabled()) {
            LOG.debug("XML Pattern: {}", (Object)regex);
        }
        return Pattern.compile(regex.toString(), 2);
    }

    protected Pattern createJsonMaskPattern(Set<String> keywords) {
        StringBuilder regex = this.createOneOfThemRegex(keywords);
        if (regex == null) {
            return null;
        }
        regex.insert(0, "\\\"(");
        regex.append(")\\\"(\\s*?):(\\s*?)\\\"([^\"]*)\\\"");
        if (LOG.isDebugEnabled()) {
            LOG.debug("JSon Pattern: {}", (Object)regex);
        }
        return Pattern.compile(regex.toString(), 2);
    }

    protected StringBuilder createOneOfThemRegex(Set<String> keywords) {
        StringBuilder regex = new StringBuilder();
        if (keywords == null || keywords.isEmpty()) {
            return null;
        }
        String[] strKeywords = keywords.toArray(new String[0]);
        regex.append(Pattern.quote(strKeywords[0]));
        if (strKeywords.length > 1) {
            for (int i = 1; i < strKeywords.length; ++i) {
                regex.append('|');
                regex.append(Pattern.quote(strKeywords[i]));
            }
        }
        return regex;
    }
}

