/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.disruptor.ExchangeEvent;
import org.apache.camel.component.disruptor.LifecycleAwareExchangeEventHandler;

abstract class AbstractLifecycleAwareExchangeEventHandler
implements LifecycleAwareExchangeEventHandler {
    private volatile boolean started;
    private volatile CountDownLatch startedLatch = new CountDownLatch(1);
    private volatile CountDownLatch stoppedLatch = new CountDownLatch(1);

    AbstractLifecycleAwareExchangeEventHandler() {
    }

    @Override
    public abstract void onEvent(ExchangeEvent var1, long var2, boolean var4) throws Exception;

    @Override
    public void awaitStarted() throws InterruptedException {
        if (!this.started) {
            this.startedLatch.await();
        }
    }

    @Override
    public boolean awaitStarted(long timeout, TimeUnit unit) throws InterruptedException {
        return this.started || this.startedLatch.await(timeout, unit);
    }

    @Override
    public void awaitStopped() throws InterruptedException {
        if (this.started) {
            this.stoppedLatch.await();
        }
    }

    @Override
    public boolean awaitStopped(long timeout, TimeUnit unit) throws InterruptedException {
        return !this.started || this.stoppedLatch.await(timeout, unit);
    }

    @Override
    public void onStart() {
        this.stoppedLatch = new CountDownLatch(1);
        this.startedLatch.countDown();
        this.started = true;
    }

    @Override
    public void onShutdown() {
        this.startedLatch = new CountDownLatch(1);
        this.stoppedLatch.countDown();
        this.started = false;
    }
}

