/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns;

import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Type;

public class DnsLookupEndpoint
extends DefaultEndpoint {
    public DnsLookupEndpoint(Component component) {
        super("dns://lookup", component);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Producer createProducer() throws Exception {
        return new DefaultProducer((Endpoint)this){

            public void process(Exchange exchange) throws Exception {
                String dnsName = (String)exchange.getIn().getHeader("dns.name", String.class);
                ObjectHelper.notEmpty((String)dnsName, (String)"Header dns.name");
                Object type = exchange.getIn().getHeader("dns.type");
                Integer dnsType = null;
                if (type != null) {
                    dnsType = Type.value(String.valueOf(type));
                }
                Object dclass = exchange.getIn().getHeader("dns.class");
                Integer dnsClass = null;
                if (dclass != null) {
                    dnsClass = DClass.value(String.valueOf(dclass));
                }
                Lookup lookup2 = dnsClass == null ? (dnsType == null ? new Lookup(dnsName) : new Lookup(dnsName, (int)dnsType)) : new Lookup(dnsName, (int)dnsType, (int)dnsClass);
                lookup2.run();
                if (lookup2.getAnswers() == null) {
                    throw new CamelException(lookup2.getErrorString());
                }
                exchange.getIn().setBody((Object)lookup2.getAnswers());
            }
        };
    }

    public boolean isSingleton() {
        return false;
    }
}

