/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SimpleResolver;

public class WikipediaEndpoint
extends DefaultEndpoint {
    public WikipediaEndpoint(Component component) {
        super("dns:///wikipedia", component);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Producer createProducer() throws Exception {
        return new DefaultProducer((Endpoint)this){

            public void process(Exchange exchange) throws Exception {
                SimpleResolver resolver = new SimpleResolver();
                int type = 16;
                Name name = Name.fromString(String.valueOf(exchange.getIn().getHeader("term")) + ".wp.dg.cx", Name.root);
                Record rec = Record.newRecord(name, type, 1);
                Message query = Message.newQuery(rec);
                Message response = resolver.send(query);
                Record[] records = response.getSectionArray(1);
                if (records.length > 0) {
                    exchange.getIn().setBody((Object)records[0].rdataToString());
                } else {
                    exchange.getIn().setBody(null);
                }
            }
        };
    }

    public boolean isSingleton() {
        return false;
    }
}

