/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.types;

import java.io.IOException;
import org.apache.camel.Converter;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;

@Converter
public final class DnsRecordConverter {
    private DnsRecordConverter() {
    }

    @Converter
    public static Record toRecord(String ip) throws IOException {
        int dclass;
        int type;
        ExtendedResolver res = new ExtendedResolver();
        Name name = ReverseMap.fromAddress(ip);
        Record rec = Record.newRecord(name, type = 12, dclass = 1);
        Message query = Message.newQuery(rec);
        Message response = res.send(query);
        Record[] answers = response.getSectionArray(1);
        if (answers.length == 0) {
            return null;
        }
        return answers[0];
    }
}

