/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.Expression;
import org.apache.camel.model.language.NamespaceAwareExpression;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="1.1.0", label="language,core,xml", title="XPath")
@XmlRootElement(name="xpath")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XPathExpression
extends NamespaceAwareExpression {
    @XmlTransient
    private Class<?> documentType;
    @XmlTransient
    private Class<?> resultType;
    @XmlTransient
    private XPathFactory xpathFactory;
    @XmlAttribute(name="documentType")
    @Metadata(label="advanced")
    private String documentTypeName;
    @XmlAttribute(name="resultType")
    @Metadata(defaultValue="NODESET", enums="NUMBER,STRING,BOOLEAN,NODESET,NODE")
    private String resultTypeName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String saxon;
    @XmlAttribute
    @Metadata(label="advanced")
    private String factoryRef;
    @XmlAttribute
    @Metadata(label="advanced")
    private String objectModel;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String logNamespaces;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String threadSafety;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String preCompile;

    public XPathExpression() {
    }

    public XPathExpression(String expression) {
        super(expression);
    }

    public XPathExpression(Expression expression) {
        this.setExpressionValue(expression);
    }

    private XPathExpression(Builder builder) {
        super(builder);
        this.documentType = builder.documentType;
        this.resultType = builder.resultType;
        this.xpathFactory = builder.xpathFactory;
        this.documentTypeName = builder.documentTypeName;
        this.resultTypeName = builder.resultTypeName;
        this.saxon = builder.saxon;
        this.factoryRef = builder.factoryRef;
        this.objectModel = builder.objectModel;
        this.logNamespaces = builder.logNamespaces;
        this.threadSafety = builder.threadSafety;
        this.preCompile = builder.preCompile;
    }

    @Override
    public String getLanguage() {
        return "xpath";
    }

    public Class<?> getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Class<?> documentType) {
        this.documentType = documentType;
    }

    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    public void setDocumentTypeName(String documentTypeName) {
        this.documentTypeName = documentTypeName;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    public void setResultTypeName(String resultTypeName) {
        this.resultTypeName = resultTypeName;
    }

    public void setSaxon(String saxon) {
        this.saxon = saxon;
    }

    public String getSaxon() {
        return this.saxon;
    }

    public void setFactoryRef(String factoryRef) {
        this.factoryRef = factoryRef;
    }

    public String getFactoryRef() {
        return this.factoryRef;
    }

    public void setObjectModel(String objectModel) {
        this.objectModel = objectModel;
    }

    public String getObjectModel() {
        return this.objectModel;
    }

    public void setLogNamespaces(String logNamespaces) {
        this.logNamespaces = logNamespaces;
    }

    public String getLogNamespaces() {
        return this.logNamespaces;
    }

    public XPathFactory getXPathFactory() {
        return this.xpathFactory;
    }

    public void setXPathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public String getThreadSafety() {
        return this.threadSafety;
    }

    public void setThreadSafety(String threadSafety) {
        this.threadSafety = threadSafety;
    }

    public String getPreCompile() {
        return this.preCompile;
    }

    public void setPreCompile(String preCompile) {
        this.preCompile = preCompile;
    }

    @XmlTransient
    public static class Builder
    extends NamespaceAwareExpression.AbstractNamespaceAwareBuilder<Builder, XPathExpression> {
        private Class<?> documentType;
        private Class<?> resultType;
        private XPathFactory xpathFactory;
        private String documentTypeName;
        private String resultTypeName;
        private String saxon;
        private String factoryRef;
        private String objectModel;
        private String logNamespaces;
        private String threadSafety;
        private String preCompile;

        public Builder documentType(Class<?> documentType) {
            this.documentType = documentType;
            return this;
        }

        public Builder resultType(Class<?> resultType) {
            this.resultType = resultType;
            return this;
        }

        public Builder xpathFactory(XPathFactory xpathFactory) {
            this.xpathFactory = xpathFactory;
            return this;
        }

        public Builder documentTypeName(String documentTypeName) {
            this.documentTypeName = documentTypeName;
            return this;
        }

        public Builder resultTypeName(String resultTypeName) {
            this.resultTypeName = resultTypeName;
            return this;
        }

        public Builder saxon(String saxon) {
            this.saxon = saxon;
            return this;
        }

        public Builder saxon(boolean saxon) {
            this.saxon = Boolean.toString(saxon);
            return this;
        }

        public Builder factoryRef(String factoryRef) {
            this.factoryRef = factoryRef;
            return this;
        }

        public Builder objectModel(String objectModel) {
            this.objectModel = objectModel;
            return this;
        }

        public Builder logNamespaces(String logNamespaces) {
            this.logNamespaces = logNamespaces;
            return this;
        }

        public Builder logNamespaces(boolean logNamespaces) {
            this.logNamespaces = Boolean.toString(logNamespaces);
            return this;
        }

        public Builder threadSafety(String threadSafety) {
            this.threadSafety = threadSafety;
            return this;
        }

        public Builder threadSafety(boolean threadSafety) {
            this.threadSafety = Boolean.toString(threadSafety);
            return this;
        }

        public Builder preCompile(String preCompile) {
            this.preCompile = preCompile;
            return this;
        }

        public Builder preCompile(boolean preCompile) {
            this.preCompile = Boolean.toString(preCompile);
            return this;
        }

        @Override
        public XPathExpression end() {
            return new XPathExpression(this);
        }
    }
}

