/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.producer;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.PushResponseItem;
import com.github.dockerjava.api.model.WaitResponse;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.dockerjava.core.command.PushImageResultCallback;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.component.docker.DockerOperation;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDockerProducer
extends DefaultAsyncProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncDockerProducer.class);
    private DockerConfiguration configuration;
    private DockerComponent component;

    public AsyncDockerProducer(DockerEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getConfiguration();
        this.component = (DockerComponent)endpoint.getComponent();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Message message = exchange.getIn();
            DockerClient client = DockerClientFactory.getDockerClient(this.component, this.configuration, message);
            DockerOperation operation = this.configuration.getOperation();
            Object result = null;
            switch (operation) {
                case BUILD_IMAGE: {
                    result = this.executeBuildImageRequest(client, message).exec(new BuildImageResultCallback(){

                        @Override
                        public void onNext(BuildResponseItem item) {
                            AsyncDockerProducer.this.log.trace("build image callback {}", (Object)item);
                            super.onNext(item);
                        }
                    });
                    if (result == null) break;
                    String imageId = ((BuildImageResultCallback)result).awaitImageId();
                    ((BuildImageResultCallback)result).close();
                    result = imageId;
                    break;
                }
                case PULL_IMAGE: {
                    result = this.executePullImageRequest(client, message).exec(new PullImageResultCallback(){

                        @Override
                        public void onNext(PullResponseItem item) {
                            AsyncDockerProducer.this.log.trace("pull image callback {}", (Object)item);
                            super.onNext(item);
                        }
                    });
                    if (result == null) break;
                    result = ((PullImageResultCallback)result).awaitCompletion();
                    ((PullImageResultCallback)result).close();
                    break;
                }
                case PUSH_IMAGE: {
                    result = this.executePushImageRequest(client, message).exec(new PushImageResultCallback(){

                        @Override
                        public void onNext(PushResponseItem item) {
                            AsyncDockerProducer.this.log.trace("push image callback {}", (Object)item);
                            super.onNext(item);
                        }
                    });
                    if (result == null) break;
                    result = ((PushImageResultCallback)result).awaitCompletion();
                    ((PushImageResultCallback)result).close();
                    break;
                }
                case ATTACH_CONTAINER: {
                    result = this.executeAttachContainerRequest(client, message).exec(new AttachContainerResultCallback(){

                        @Override
                        public void onNext(Frame item) {
                            AsyncDockerProducer.this.log.trace("attach container callback {}", (Object)item);
                            super.onNext(item);
                        }
                    });
                    if (result == null) break;
                    result = ((AttachContainerResultCallback)result).awaitCompletion();
                    ((AttachContainerResultCallback)result).close();
                    break;
                }
                case LOG_CONTAINER: {
                    result = this.executeLogContainerRequest(client, message).exec(new LogContainerResultCallback(){

                        @Override
                        public void onNext(Frame item) {
                            AsyncDockerProducer.this.log.trace("log container callback {}", (Object)item);
                            super.onNext(item);
                        }
                    });
                    if (result == null) break;
                    result = ((LogContainerResultCallback)result).awaitCompletion();
                    ((LogContainerResultCallback)result).close();
                    break;
                }
                case WAIT_CONTAINER: {
                    result = this.executeWaitContainerRequest(client, message).exec(new WaitContainerResultCallback(){

                        @Override
                        public void onNext(WaitResponse item) {
                            AsyncDockerProducer.this.log.trace("wait contanier callback {}", (Object)item);
                            super.onNext(item);
                        }
                    });
                    if (result == null) break;
                    Integer statusCode = ((WaitContainerResultCallback)result).awaitStatusCode();
                    ((WaitContainerResultCallback)result).close();
                    result = statusCode;
                    break;
                }
                case EXEC_START: {
                    result = this.executeExecStartRequest(client, message).exec(new ExecStartResultCallback(){

                        @Override
                        public void onNext(Frame item) {
                            AsyncDockerProducer.this.log.trace("exec start callback {}", (Object)item);
                            super.onNext(item);
                        }
                    });
                    if (result == null) break;
                    result = ((ExecStartResultCallback)result).awaitCompletion();
                    ((ExecStartResultCallback)result).close();
                    break;
                }
                default: {
                    throw new DockerException("Invalid operation: " + (Object)((Object)operation));
                }
            }
            if (result != null) {
                exchange.getIn().setBody(result);
                return true;
            }
        }
        catch (IOException | InterruptedException | DockerException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    private BuildImageCmd executeBuildImageRequest(DockerClient client, Message message) throws DockerException {
        String tag;
        Boolean remove;
        Boolean quiet;
        BuildImageCmd buildImageCmd;
        LOGGER.debug("Executing Docker Build Image Request");
        Object body = message.getBody();
        if (body instanceof InputStream) {
            buildImageCmd = client.buildImageCmd((InputStream)body);
        } else if (body instanceof File) {
            buildImageCmd = client.buildImageCmd((File)body);
        } else {
            throw new DockerException("Unable to location source Image");
        }
        Boolean noCache = DockerHelper.getProperty("CamelDockerNoCache", this.configuration, message, Boolean.class);
        if (noCache != null) {
            buildImageCmd.withNoCache(noCache);
        }
        if ((quiet = DockerHelper.getProperty("CamelDockerQuiet", this.configuration, message, Boolean.class)) != null) {
            buildImageCmd.withQuiet(quiet);
        }
        if ((remove = DockerHelper.getProperty("CamelDockerRemove", this.configuration, message, Boolean.class)) != null) {
            buildImageCmd.withRemove(remove);
        }
        if ((tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class)) != null) {
            buildImageCmd.withTag(tag);
        }
        return buildImageCmd;
    }

    private PullImageCmd executePullImageRequest(DockerClient client, Message message) {
        AuthConfig authConfig;
        String tag;
        LOGGER.debug("Executing Docker Pull Image Request");
        String repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)repository, (String)"Repository must be specified");
        PullImageCmd pullImageCmd = client.pullImageCmd(repository);
        String registry = DockerHelper.getProperty("CamelDockerRegistry", this.configuration, message, String.class);
        if (registry != null) {
            pullImageCmd.withRegistry(registry);
        }
        if ((tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class)) != null) {
            pullImageCmd.withTag(tag);
        }
        if ((authConfig = client.authConfig()) != null) {
            pullImageCmd.withAuthConfig(authConfig);
        }
        return pullImageCmd;
    }

    private PushImageCmd executePushImageRequest(DockerClient client, Message message) {
        AuthConfig authConfig;
        LOGGER.debug("Executing Docker Push Image Request");
        String name = DockerHelper.getProperty("CamelDockerName", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)name, (String)"Image name must be specified");
        PushImageCmd pushImageCmd = client.pushImageCmd(name);
        String tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class);
        if (tag != null) {
            pushImageCmd.withTag(tag);
        }
        if ((authConfig = client.authConfig()) != null) {
            pushImageCmd.withAuthConfig(authConfig);
        }
        return pushImageCmd;
    }

    private AttachContainerCmd executeAttachContainerRequest(DockerClient client, Message message) {
        Boolean timestamps;
        Boolean stdOut;
        Boolean stdErr;
        Boolean logs;
        LOGGER.debug("Executing Docker Attach Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        AttachContainerCmd attachContainerCmd = client.attachContainerCmd(containerId);
        Boolean followStream = DockerHelper.getProperty("CamelDockerFollowStream", this.configuration, message, Boolean.class);
        if (followStream != null) {
            attachContainerCmd.withFollowStream(followStream);
        }
        if ((logs = DockerHelper.getProperty("CamelDockerLogs", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withLogs(logs);
        }
        if ((stdErr = DockerHelper.getProperty("CamelDockerStdErr", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withStdErr(stdErr);
        }
        if ((stdOut = DockerHelper.getProperty("CamelDockerStdOut", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withStdOut(stdOut);
        }
        if ((timestamps = DockerHelper.getProperty("CamelDockerTimestamps", this.configuration, message, Boolean.class)) != null) {
            attachContainerCmd.withTimestamps(timestamps);
        }
        return attachContainerCmd;
    }

    private LogContainerCmd executeLogContainerRequest(DockerClient client, Message message) {
        Boolean timestamps;
        Boolean tailAll;
        Integer tail;
        Boolean stdOut;
        Boolean stdErr;
        LOGGER.debug("Executing Docker Log Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        LogContainerCmd logContainerCmd = client.logContainerCmd(containerId);
        Boolean followStream = DockerHelper.getProperty("CamelDockerFollowStream", this.configuration, message, Boolean.class);
        if (followStream != null) {
            logContainerCmd.withFollowStream(followStream);
        }
        if ((stdErr = DockerHelper.getProperty("CamelDockerStdErr", this.configuration, message, Boolean.class)) != null) {
            logContainerCmd.withStdErr(stdErr);
        }
        if ((stdOut = DockerHelper.getProperty("CamelDockerStdOut", this.configuration, message, Boolean.class)) != null) {
            logContainerCmd.withStdOut(stdOut);
        }
        if ((tail = DockerHelper.getProperty("CamelDockerTail", this.configuration, message, Integer.class)) != null) {
            logContainerCmd.withTail(tail);
        }
        if ((tailAll = DockerHelper.getProperty("CamelDockerTailAll", this.configuration, message, Boolean.class)) != null && tailAll.booleanValue()) {
            logContainerCmd.withTailAll();
        }
        if ((timestamps = DockerHelper.getProperty("CamelDockerTimestamps", this.configuration, message, Boolean.class)) != null) {
            logContainerCmd.withTimestamps(timestamps);
        }
        return logContainerCmd;
    }

    private WaitContainerCmd executeWaitContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Wait Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)containerId, (String)"Container ID must be specified");
        WaitContainerCmd waitContainerCmd = client.waitContainerCmd(containerId);
        return waitContainerCmd;
    }

    private ExecStartCmd executeExecStartRequest(DockerClient client, Message message) {
        Boolean tty;
        LOGGER.debug("Executing Docker Exec Create Request");
        String execId = DockerHelper.getProperty("CamelDockerExecId", this.configuration, message, String.class);
        ObjectHelper.notNull((Object)execId, (String)"Exec ID must be specified");
        ExecStartCmd execStartCmd = client.execStartCmd(execId);
        Boolean detach = DockerHelper.getProperty("CamelDockerDetach", this.configuration, message, Boolean.class);
        if (detach != null) {
            execStartCmd.withDetach(detach);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            execStartCmd.withTty(tty);
        }
        return execStartCmd;
    }
}

