/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class LogConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="Type")
    public LoggingType type = null;
    @JsonProperty(value="Config")
    public Map<String, String> config;

    public LogConfig(LoggingType type, Map<String, String> config) {
        this.type = type;
        this.config = config;
    }

    public LogConfig(LoggingType type) {
        this(type, null);
    }

    public LogConfig() {
    }

    public LoggingType getType() {
        return this.type;
    }

    public LogConfig setType(LoggingType type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public Map<String, String> getConfig() {
        return this.config;
    }

    @JsonIgnore
    public LogConfig setConfig(Map<String, String> config) {
        this.config = config;
        return this;
    }

    @JsonDeserialize(using=Deserializer.class)
    @JsonSerialize(using=Serializer.class)
    public static enum LoggingType {
        DEFAULT("json-file"),
        JSON_FILE("json-file"),
        NONE("none"),
        SYSLOG("syslog"),
        JOURNALD("journald"),
        GELF("gelf"),
        FLUENTD("fluentd"),
        AWSLOGS("awslogs"),
        DB("db"),
        SPLUNK("splunk");

        private String type;

        private LoggingType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static final class Deserializer
        extends JsonDeserializer<LoggingType> {
            @Override
            public LoggingType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                ObjectCodec oc = jsonParser.getCodec();
                JsonNode node = (JsonNode)oc.readTree(jsonParser);
                for (LoggingType loggingType : LoggingType.values()) {
                    if (!loggingType.getType().equals(node.asText())) continue;
                    return loggingType;
                }
                throw new IllegalArgumentException("No enum constant " + LoggingType.class + "." + node.asText());
            }
        }

        public static final class Serializer
        extends JsonSerializer<LoggingType> {
            @Override
            public void serialize(LoggingType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(value.getType());
            }
        }
    }
}

