/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.Limits;
import io.netty.channel.unix.SocketWritableByteChannel;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractKQueueStreamChannel
extends AbstractKQueueChannel
implements DuplexChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final ClosedChannelException DO_CLOSE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractKQueueStreamChannel.class, "doClose()");
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ')';
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private WritableByteChannel byteChannel;

    AbstractKQueueStreamChannel(Channel parent, BsdSocket fd, boolean active) {
        super(parent, fd, active, true);
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueStreamUnsafe();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    private boolean writeBytes(ChannelOutboundBuffer in, ByteBuf buf, int writeSpinCount) throws Exception {
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            in.remove();
            return true;
        }
        if (buf.hasMemoryAddress() || buf.nioBufferCount() == 1) {
            int writtenBytes = this.doWriteBytes(buf, writeSpinCount);
            in.removeBytes(writtenBytes);
            return writtenBytes == readableBytes;
        }
        ByteBuffer[] nioBuffers = buf.nioBuffers();
        return this.writeBytesMultiple(in, nioBuffers, nioBuffers.length, readableBytes, writeSpinCount);
    }

    private boolean writeBytesMultiple(ChannelOutboundBuffer in, IovArray array, int writeSpinCount) throws IOException {
        long localWrittenBytes;
        long expectedWrittenBytes;
        long initialExpectedWrittenBytes = expectedWrittenBytes = array.size();
        int cnt = array.count();
        assert (expectedWrittenBytes != 0L);
        assert (cnt != 0);
        boolean done = false;
        int offset = 0;
        int end = offset + cnt;
        for (int i = writeSpinCount; i > 0 && (localWrittenBytes = this.socket.writevAddresses(array.memoryAddress(offset), cnt)) != 0L; --i) {
            long bytes;
            if ((expectedWrittenBytes -= localWrittenBytes) == 0L) {
                done = true;
                break;
            }
            while ((bytes = array.processWritten(offset, localWrittenBytes)) != -1L) {
                --cnt;
                if (++offset < end && (localWrittenBytes -= bytes) > 0L) continue;
            }
        }
        in.removeBytes(initialExpectedWrittenBytes - expectedWrittenBytes);
        return done;
    }

    private boolean writeBytesMultiple(ChannelOutboundBuffer in, ByteBuffer[] nioBuffers, int nioBufferCnt, long expectedWrittenBytes, int writeSpinCount) throws IOException {
        long localWrittenBytes;
        assert (expectedWrittenBytes != 0L);
        long initialExpectedWrittenBytes = expectedWrittenBytes;
        boolean done = false;
        int offset = 0;
        int end = offset + nioBufferCnt;
        block0: for (int i = writeSpinCount; i > 0 && (localWrittenBytes = this.socket.writev(nioBuffers, offset, nioBufferCnt)) != 0L; --i) {
            int bytes;
            if ((expectedWrittenBytes -= localWrittenBytes) == 0L) {
                done = true;
                break;
            }
            do {
                ByteBuffer buffer = nioBuffers[offset];
                int pos = buffer.position();
                bytes = buffer.limit() - pos;
                if ((long)bytes > localWrittenBytes) {
                    buffer.position(pos + (int)localWrittenBytes);
                    continue block0;
                }
                --nioBufferCnt;
            } while (++offset < end && (localWrittenBytes -= (long)bytes) > 0L);
        }
        in.removeBytes(initialExpectedWrittenBytes - expectedWrittenBytes);
        return done;
    }

    private boolean writeDefaultFileRegion(ChannelOutboundBuffer in, DefaultFileRegion region, int writeSpinCount) throws Exception {
        long offset;
        long localFlushedAmount;
        long regionCount = region.count();
        if (region.transferred() >= regionCount) {
            in.remove();
            return true;
        }
        long baseOffset = region.position();
        boolean done = false;
        long flushedAmount = 0L;
        for (int i = writeSpinCount; i > 0 && (localFlushedAmount = this.socket.sendFile(region, baseOffset, offset = region.transferred(), regionCount - offset)) != 0L; --i) {
            flushedAmount += localFlushedAmount;
            if (region.transferred() < regionCount) continue;
            done = true;
            break;
        }
        if (flushedAmount > 0L) {
            in.progress(flushedAmount);
        }
        if (done) {
            in.remove();
        }
        return done;
    }

    private boolean writeFileRegion(ChannelOutboundBuffer in, FileRegion region, int writeSpinCount) throws Exception {
        long localFlushedAmount;
        if (region.transferred() >= region.count()) {
            in.remove();
            return true;
        }
        boolean done = false;
        long flushedAmount = 0L;
        if (this.byteChannel == null) {
            this.byteChannel = new KQueueSocketWritableByteChannel();
        }
        for (int i = writeSpinCount; i > 0 && (localFlushedAmount = region.transferTo(this.byteChannel, region.transferred())) != 0L; --i) {
            flushedAmount += localFlushedAmount;
            if (region.transferred() < region.count()) continue;
            done = true;
            break;
        }
        if (flushedAmount > 0L) {
            in.progress(flushedAmount);
        }
        if (done) {
            in.remove();
        }
        return done;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        int msgCount;
        int writeSpinCount = this.config().getWriteSpinCount();
        do {
            if ((msgCount = in.size()) != 0) continue;
            this.writeFilter(false);
            return;
        } while (!(msgCount > 1 && in.current() instanceof ByteBuf ? !this.doWriteMultiple(in, writeSpinCount) : !this.doWriteSingle(in, writeSpinCount)));
        this.writeFilter(true);
    }

    protected boolean doWriteSingle(ChannelOutboundBuffer in, int writeSpinCount) throws Exception {
        Object msg = in.current();
        if (msg instanceof ByteBuf) {
            if (!this.writeBytes(in, (ByteBuf)msg, writeSpinCount)) {
                return false;
            }
        } else if (msg instanceof DefaultFileRegion) {
            if (!this.writeDefaultFileRegion(in, (DefaultFileRegion)msg, writeSpinCount)) {
                return false;
            }
        } else if (msg instanceof FileRegion) {
            if (!this.writeFileRegion(in, (FileRegion)msg, writeSpinCount)) {
                return false;
            }
        } else {
            throw new Error();
        }
        return true;
    }

    private boolean doWriteMultiple(ChannelOutboundBuffer in, int writeSpinCount) throws Exception {
        if (PlatformDependent.hasUnsafe()) {
            IovArray array = ((KQueueEventLoop)this.eventLoop()).cleanArray();
            in.forEachFlushedMessage(array);
            int cnt = array.count();
            if (cnt >= 1) {
                if (!this.writeBytesMultiple(in, array, writeSpinCount)) {
                    return false;
                }
            } else {
                in.removeBytes(0L);
            }
        } else {
            ByteBuffer[] buffers = in.nioBuffers();
            int cnt = in.nioBufferCount();
            if (cnt >= 1) {
                if (!this.writeBytesMultiple(in, buffers, cnt, in.nioBufferSize(), writeSpinCount)) {
                    return false;
                }
            } else {
                in.removeBytes(0L);
            }
        }
        return true;
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (!(buf.hasMemoryAddress() || !PlatformDependent.hasUnsafe() && buf.isDirect())) {
                if (buf instanceof CompositeByteBuf) {
                    CompositeByteBuf comp = (CompositeByteBuf)buf;
                    if (!comp.isDirect() || comp.nioBufferCount() > Limits.IOV_MAX) {
                        buf = this.newDirectBuffer(buf);
                        assert (buf.hasMemoryAddress());
                    }
                } else {
                    buf = this.newDirectBuffer(buf);
                    assert (buf.hasMemoryAddress());
                }
            }
            return buf;
        }
        if (msg instanceof FileRegion) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + EXPECTED_TYPES);
    }

    private void shutdownOutput0(ChannelPromise promise) {
        try {
            this.socket.shutdown(false, true);
            promise.setSuccess();
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    private void shutdownInput0(ChannelPromise promise) {
        try {
            this.socket.shutdown(true, false);
            promise.setSuccess();
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    private void shutdown0(ChannelPromise promise) {
        try {
            this.socket.shutdown(true, true);
            promise.setSuccess();
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.socket.isShutdown();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise promise) {
        Executor closeExecutor = ((KQueueStreamUnsafe)this.unsafe()).prepareToClose();
        if (closeExecutor != null) {
            closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractKQueueStreamChannel.this.shutdownOutput0(promise);
                }
            });
        } else {
            EventLoop loop = this.eventLoop();
            if (loop.inEventLoop()) {
                this.shutdownOutput0(promise);
            } else {
                loop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractKQueueStreamChannel.this.shutdownOutput0(promise);
                    }
                });
            }
        }
        return promise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownInput(final ChannelPromise promise) {
        Executor closeExecutor = ((KQueueStreamUnsafe)this.unsafe()).prepareToClose();
        if (closeExecutor != null) {
            closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractKQueueStreamChannel.this.shutdownInput0(promise);
                }
            });
        } else {
            EventLoop loop = this.eventLoop();
            if (loop.inEventLoop()) {
                this.shutdownInput0(promise);
            } else {
                loop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractKQueueStreamChannel.this.shutdownInput0(promise);
                    }
                });
            }
        }
        return promise;
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown(final ChannelPromise promise) {
        Executor closeExecutor = ((KQueueStreamUnsafe)this.unsafe()).prepareToClose();
        if (closeExecutor != null) {
            closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractKQueueStreamChannel.this.shutdown0(promise);
                }
            });
        } else {
            EventLoop loop = this.eventLoop();
            if (loop.inEventLoop()) {
                this.shutdown0(promise);
            } else {
                loop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractKQueueStreamChannel.this.shutdown0(promise);
                    }
                });
            }
        }
        return promise;
    }

    @Override
    protected void doClose() throws Exception {
        ScheduledFuture<?> future;
        ChannelPromise promise = this.connectPromise;
        if (promise != null) {
            promise.tryFailure(DO_CLOSE_CLOSED_CHANNEL_EXCEPTION);
            this.connectPromise = null;
        }
        if ((future = this.connectTimeoutFuture) != null) {
            future.cancel(false);
            this.connectTimeoutFuture = null;
        }
        super.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (localAddress != null) {
            this.socket.bind(localAddress);
        }
        boolean success = false;
        try {
            boolean connected = this.socket.connect(remoteAddress);
            if (!connected) {
                this.writeFilter(true);
            }
            success = true;
            boolean bl = connected;
            return bl;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    private final class KQueueSocketWritableByteChannel
    extends SocketWritableByteChannel {
        KQueueSocketWritableByteChannel() {
            super(AbstractKQueueStreamChannel.this.socket);
        }

        @Override
        protected ByteBufAllocator alloc() {
            return AbstractKQueueStreamChannel.this.alloc();
        }
    }

    class KQueueStreamUnsafe
    extends AbstractKQueueChannel.AbstractKQueueUnsafe {
        KQueueStreamUnsafe() {
            super(AbstractKQueueStreamChannel.this);
        }

        @Override
        protected Executor prepareToClose() {
            return super.prepareToClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void readReady(KQueueRecvByteAllocatorHandle allocHandle) {
            KQueueChannelConfig config = AbstractKQueueStreamChannel.this.config();
            if (AbstractKQueueStreamChannel.this.shouldBreakReadReady(config)) {
                this.clearReadFilter0();
                return;
            }
            ChannelPipeline pipeline = AbstractKQueueStreamChannel.this.pipeline();
            ByteBufAllocator allocator = config.getAllocator();
            allocHandle.reset(config);
            this.readReadyBefore();
            ByteBuf byteBuf = null;
            boolean close = false;
            try {
                do {
                    byteBuf = allocHandle.allocate(allocator);
                    allocHandle.lastBytesRead(AbstractKQueueStreamChannel.this.doReadBytes(byteBuf));
                    if (allocHandle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        close = allocHandle.lastBytesRead() < 0;
                        break;
                    }
                    allocHandle.incMessagesRead(1);
                    this.readPending = false;
                    pipeline.fireChannelRead(byteBuf);
                    byteBuf = null;
                } while (!AbstractKQueueStreamChannel.this.shouldBreakReadReady(config) && allocHandle.continueReading());
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                if (close) {
                    this.shutdownInput(false);
                }
            }
            catch (Throwable t) {
                this.handleReadException(pipeline, byteBuf, t, close, allocHandle);
            }
            finally {
                this.readReadyFinally(config);
            }
        }

        @Override
        void writeReady() {
            if (AbstractKQueueStreamChannel.this.connectPromise != null) {
                this.finishConnect();
            } else {
                super.writeReady();
            }
        }

        @Override
        public void connect(final SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            try {
                if (AbstractKQueueStreamChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean wasActive = AbstractKQueueStreamChannel.this.isActive();
                if (AbstractKQueueStreamChannel.this.doConnect(remoteAddress, localAddress)) {
                    this.fulfillConnectPromise(promise, wasActive);
                } else {
                    AbstractKQueueStreamChannel.this.connectPromise = promise;
                    AbstractKQueueStreamChannel.this.requestedRemoteAddress = remoteAddress;
                    int connectTimeoutMillis = AbstractKQueueStreamChannel.this.config().getConnectTimeoutMillis();
                    if (connectTimeoutMillis > 0) {
                        AbstractKQueueStreamChannel.this.connectTimeoutFuture = AbstractKQueueStreamChannel.this.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ChannelPromise connectPromise = AbstractKQueueStreamChannel.this.connectPromise;
                                ConnectTimeoutException cause = new ConnectTimeoutException("connection timed out: " + remoteAddress);
                                if (connectPromise != null && connectPromise.tryFailure(cause)) {
                                    KQueueStreamUnsafe.this.close(KQueueStreamUnsafe.this.voidPromise());
                                }
                            }
                        }, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    promise.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isCancelled()) {
                                if (AbstractKQueueStreamChannel.this.connectTimeoutFuture != null) {
                                    AbstractKQueueStreamChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractKQueueStreamChannel.this.connectPromise = null;
                                KQueueStreamUnsafe.this.close(KQueueStreamUnsafe.this.voidPromise());
                            }
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.closeIfClosed();
                promise.tryFailure(this.annotateConnectException(t, remoteAddress));
            }
        }

        private void fulfillConnectPromise(ChannelPromise promise, boolean wasActive) {
            if (promise == null) {
                return;
            }
            AbstractKQueueStreamChannel.this.active = true;
            boolean active = AbstractKQueueStreamChannel.this.isActive();
            boolean promiseSet = promise.trySuccess();
            if (!wasActive && active) {
                AbstractKQueueStreamChannel.this.pipeline().fireChannelActive();
            }
            if (!promiseSet) {
                this.close(this.voidPromise());
            }
        }

        private void fulfillConnectPromise(ChannelPromise promise, Throwable cause) {
            if (promise == null) {
                return;
            }
            promise.tryFailure(cause);
            this.closeIfClosed();
        }

        private void finishConnect() {
            assert (AbstractKQueueStreamChannel.this.eventLoop().inEventLoop());
            boolean connectStillInProgress = false;
            try {
                boolean wasActive = AbstractKQueueStreamChannel.this.isActive();
                if (!this.doFinishConnect()) {
                    connectStillInProgress = true;
                    return;
                }
                this.fulfillConnectPromise(AbstractKQueueStreamChannel.this.connectPromise, wasActive);
            }
            catch (Throwable t) {
                this.fulfillConnectPromise(AbstractKQueueStreamChannel.this.connectPromise, this.annotateConnectException(t, AbstractKQueueStreamChannel.this.requestedRemoteAddress));
            }
            finally {
                if (!connectStillInProgress) {
                    if (AbstractKQueueStreamChannel.this.connectTimeoutFuture != null) {
                        AbstractKQueueStreamChannel.this.connectTimeoutFuture.cancel(false);
                    }
                    AbstractKQueueStreamChannel.this.connectPromise = null;
                }
            }
        }

        boolean doFinishConnect() throws Exception {
            if (AbstractKQueueStreamChannel.this.socket.finishConnect()) {
                AbstractKQueueStreamChannel.this.writeFilter(false);
                return true;
            }
            AbstractKQueueStreamChannel.this.writeFilter(true);
            return false;
        }

        private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close, KQueueRecvByteAllocatorHandle allocHandle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    pipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            allocHandle.readComplete();
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (close || cause instanceof IOException) {
                this.shutdownInput(false);
            }
        }
    }
}

