/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DockerEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":operation";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    @Override
    public boolean isEnabled(String scheme) {
        return "docker".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "operation", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(22);
        props.add("followRedirectFilter");
        props.add("cmdExecFactory");
        props.add("tlsVerify");
        props.add("exchangePattern");
        props.add("maxTotalConnections");
        props.add("serverAddress");
        props.add("secure");
        props.add("lazyStartProducer");
        props.add("maxPerRouteConnections");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("certPath");
        props.add("port");
        props.add("loggingFilter");
        props.add("host");
        props.add("socket");
        props.add("operation");
        props.add("exceptionHandler");
        props.add("parameters");
        props.add("email");
        props.add("requestTimeout");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

