/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import java.lang.reflect.Array;
import org.apache.camel.Message;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.util.StringHelper;
import org.apache.commons.lang.BooleanUtils;

public final class DockerHelper {
    private static final String STRING_DELIMITER = ";";

    private DockerHelper() {
    }

    public static String transformFromHeaderName(String name) {
        StringHelper.notEmpty(name, "name");
        StringBuilder formattedName = new StringBuilder();
        String nameSubstring = name.substring("CamelDocker".length());
        if (nameSubstring.length() > 0) {
            formattedName.append(nameSubstring.substring(0, 1).toLowerCase());
            formattedName.append(nameSubstring, 1, nameSubstring.length());
        }
        return formattedName.toString();
    }

    public static <T> T getProperty(String name, DockerConfiguration configuration, Message message, Class<T> clazz) {
        return DockerHelper.getProperty(name, configuration, message, clazz, null);
    }

    public static <T> T getProperty(String name, DockerConfiguration configuration, Message message, Class<T> clazz, T defaultValue) {
        T headerProperty;
        if (message != null && (headerProperty = message.getHeader(name, clazz)) != null) {
            return headerProperty;
        }
        Object prop = configuration.getParameters().get(DockerHelper.transformFromHeaderName(name));
        if (prop != null) {
            if (prop.getClass().isAssignableFrom(clazz)) {
                return (T)prop;
            }
            if (Integer.class == clazz) {
                return (T)Integer.valueOf((String)prop);
            }
            if (Boolean.class == clazz) {
                return (T)BooleanUtils.toBooleanObject((String)((String)prop), (String)"true", (String)"false", (String)"null");
            }
        } else if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    public static <T> T[] getArrayProperty(String name, Message message, Class<T> clazz) {
        Object header;
        if (message != null && (header = message.getHeader(name)) != null) {
            if (header.getClass().isAssignableFrom(clazz)) {
                Object[] headerArray = (Object[])Array.newInstance(clazz, 1);
                headerArray[0] = header;
                return headerArray;
            }
            if (header.getClass().isArray() && (header.getClass().getComponentType().isAssignableFrom(clazz) || header.getClass().getDeclaringClass().isAssignableFrom(clazz))) {
                return (Object[])header;
            }
        }
        return null;
    }

    public static String[] parseDelimitedStringHeader(String headerName, Message message) {
        Object header = message.getHeader(headerName);
        if (header != null) {
            if (header instanceof String) {
                return ((String)header).split(STRING_DELIMITER);
            }
            if (header instanceof String[]) {
                return (String[])header;
            }
        }
        return null;
    }
}

