/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.producer;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ConnectToNetworkCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RemoveNetworkCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.ExposedPorts;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.Volumes;
import com.github.dockerjava.api.model.VolumesFrom;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerProducer
extends DefaultProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerProducer.class);
    private DockerConfiguration configuration;
    private DockerComponent component;

    public DockerProducer(DockerEndpoint endpoint) {
        super(endpoint);
        this.configuration = endpoint.getConfiguration();
        this.component = (DockerComponent)endpoint.getComponent();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        message = exchange.getIn();
        client = DockerClientFactory.getDockerClient(this.component, this.configuration, message);
        operation = this.configuration.getOperation();
        result = null;
        switch (1.$SwitchMap$org$apache$camel$component$docker$DockerOperation[operation.ordinal()]) {
            case 1: {
                cmd = this.executeAuthRequest(client);
                var7_34 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_34 == null) ** GOTO lbl19
                try {
                    cmd.close();
                }
                catch (Throwable var8_62) {
                    var7_34.addSuppressed(var8_62);
                }
                break;
lbl19:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_63) {
                    try {
                        var7_34 = var8_63;
                        throw var8_63;
                    }
                    catch (Throwable var9_118) {
                        if (cmd != null) {
                            if (var7_34 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var10_119) {
                                    var7_34.addSuppressed(var10_119);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var9_118;
                    }
                }
            }
            case 2: {
                cmd = this.executeInfoRequest(client);
                var7_35 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_35 == null) ** GOTO lbl49
                try {
                    cmd.close();
                }
                catch (Throwable var8_64) {
                    var7_35.addSuppressed(var8_64);
                }
                break;
lbl49:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_65) {
                    try {
                        var7_35 = var8_65;
                        throw var8_65;
                    }
                    catch (Throwable var11_120) {
                        if (cmd != null) {
                            if (var7_35 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var12_121) {
                                    var7_35.addSuppressed(var12_121);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var11_120;
                    }
                }
            }
            case 3: {
                cmd = this.executePingRequest(client);
                var7_36 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_36 == null) ** GOTO lbl79
                try {
                    cmd.close();
                }
                catch (Throwable var8_66) {
                    var7_36.addSuppressed(var8_66);
                }
                break;
lbl79:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_67) {
                    try {
                        var7_36 = var8_67;
                        throw var8_67;
                    }
                    catch (Throwable var13_122) {
                        if (cmd != null) {
                            if (var7_36 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var14_123) {
                                    var7_36.addSuppressed(var14_123);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var13_122;
                    }
                }
            }
            case 4: {
                cmd = this.executeVersionRequest(client);
                var7_37 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_37 == null) ** GOTO lbl109
                try {
                    cmd.close();
                }
                catch (Throwable var8_68) {
                    var7_37.addSuppressed(var8_68);
                }
                break;
lbl109:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_69) {
                    try {
                        var7_37 = var8_69;
                        throw var8_69;
                    }
                    catch (Throwable var15_124) {
                        if (cmd != null) {
                            if (var7_37 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var16_125) {
                                    var7_37.addSuppressed(var16_125);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var15_124;
                    }
                }
            }
            case 5: {
                cmd = this.executeCreateImageRequest(client, message);
                var7_38 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_38 == null) ** GOTO lbl139
                try {
                    cmd.close();
                }
                catch (Throwable var8_70) {
                    var7_38.addSuppressed(var8_70);
                }
                break;
lbl139:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_71) {
                    try {
                        var7_38 = var8_71;
                        throw var8_71;
                    }
                    catch (Throwable var17_126) {
                        if (cmd != null) {
                            if (var7_38 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var18_127) {
                                    var7_38.addSuppressed(var18_127);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var17_126;
                    }
                }
            }
            case 6: {
                cmd = this.executeInspectImageRequest(client, message);
                var7_39 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_39 == null) ** GOTO lbl169
                try {
                    cmd.close();
                }
                catch (Throwable var8_72) {
                    var7_39.addSuppressed(var8_72);
                }
                break;
lbl169:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_73) {
                    try {
                        var7_39 = var8_73;
                        throw var8_73;
                    }
                    catch (Throwable var19_128) {
                        if (cmd != null) {
                            if (var7_39 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var20_129) {
                                    var7_39.addSuppressed(var20_129);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var19_128;
                    }
                }
            }
            case 7: {
                cmd = this.executeListImagesRequest(client, message);
                var7_40 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_40 == null) ** GOTO lbl199
                try {
                    cmd.close();
                }
                catch (Throwable var8_74) {
                    var7_40.addSuppressed(var8_74);
                }
                break;
lbl199:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_75) {
                    try {
                        var7_40 = var8_75;
                        throw var8_75;
                    }
                    catch (Throwable var21_130) {
                        if (cmd != null) {
                            if (var7_40 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var22_131) {
                                    var7_40.addSuppressed(var22_131);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var21_130;
                    }
                }
            }
            case 8: {
                cmd = this.executeRemoveImageRequest(client, message);
                var7_41 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_41 == null) ** GOTO lbl229
                try {
                    cmd.close();
                }
                catch (Throwable var8_76) {
                    var7_41.addSuppressed(var8_76);
                }
                break;
lbl229:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_77) {
                    try {
                        var7_41 = var8_77;
                        throw var8_77;
                    }
                    catch (Throwable var23_132) {
                        if (cmd != null) {
                            if (var7_41 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var24_133) {
                                    var7_41.addSuppressed(var24_133);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var23_132;
                    }
                }
            }
            case 9: {
                cmd = this.executeSearchImageRequest(client, message);
                var7_42 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_42 == null) ** GOTO lbl259
                try {
                    cmd.close();
                }
                catch (Throwable var8_78) {
                    var7_42.addSuppressed(var8_78);
                }
                break;
lbl259:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_79) {
                    try {
                        var7_42 = var8_79;
                        throw var8_79;
                    }
                    catch (Throwable var25_134) {
                        if (cmd != null) {
                            if (var7_42 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var26_135) {
                                    var7_42.addSuppressed(var26_135);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var25_134;
                    }
                }
            }
            case 10: {
                cmd = this.executeTagImageRequest(client, message);
                var7_43 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_43 == null) ** GOTO lbl289
                try {
                    cmd.close();
                }
                catch (Throwable var8_80) {
                    var7_43.addSuppressed(var8_80);
                }
                break;
lbl289:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_81) {
                    try {
                        var7_43 = var8_81;
                        throw var8_81;
                    }
                    catch (Throwable var27_136) {
                        if (cmd != null) {
                            if (var7_43 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var28_137) {
                                    var7_43.addSuppressed(var28_137);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var27_136;
                    }
                }
            }
            case 11: {
                cmd = this.executeCommitContainerRequest(client, message);
                var7_44 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_44 == null) ** GOTO lbl319
                try {
                    cmd.close();
                }
                catch (Throwable var8_82) {
                    var7_44.addSuppressed(var8_82);
                }
                break;
lbl319:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_83) {
                    try {
                        var7_44 = var8_83;
                        throw var8_83;
                    }
                    catch (Throwable var29_138) {
                        if (cmd != null) {
                            if (var7_44 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var30_139) {
                                    var7_44.addSuppressed(var30_139);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var29_138;
                    }
                }
            }
            case 12: {
                cmd = this.executeCopyFileContainerRequest(client, message);
                var7_45 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_45 == null) ** GOTO lbl349
                try {
                    cmd.close();
                }
                catch (Throwable var8_84) {
                    var7_45.addSuppressed(var8_84);
                }
                break;
lbl349:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_85) {
                    try {
                        var7_45 = var8_85;
                        throw var8_85;
                    }
                    catch (Throwable var31_140) {
                        if (cmd != null) {
                            if (var7_45 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var32_141) {
                                    var7_45.addSuppressed(var32_141);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var31_140;
                    }
                }
            }
            case 13: {
                cmd = this.executeCreateContainerRequest(client, message);
                var7_46 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_46 == null) ** GOTO lbl379
                try {
                    cmd.close();
                }
                catch (Throwable var8_86) {
                    var7_46.addSuppressed(var8_86);
                }
                break;
lbl379:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_87) {
                    try {
                        var7_46 = var8_87;
                        throw var8_87;
                    }
                    catch (Throwable var33_142) {
                        if (cmd != null) {
                            if (var7_46 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var34_143) {
                                    var7_46.addSuppressed(var34_143);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var33_142;
                    }
                }
            }
            case 14: {
                cmd = this.executeDiffContainerRequest(client, message);
                var7_47 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_47 == null) ** GOTO lbl409
                try {
                    cmd.close();
                }
                catch (Throwable var8_88) {
                    var7_47.addSuppressed(var8_88);
                }
                break;
lbl409:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_89) {
                    try {
                        var7_47 = var8_89;
                        throw var8_89;
                    }
                    catch (Throwable var35_144) {
                        if (cmd != null) {
                            if (var7_47 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var36_145) {
                                    var7_47.addSuppressed(var36_145);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var35_144;
                    }
                }
            }
            case 15: {
                cmd = this.executeInspectContainerRequest(client, message);
                var7_48 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_48 == null) ** GOTO lbl439
                try {
                    cmd.close();
                }
                catch (Throwable var8_90) {
                    var7_48.addSuppressed(var8_90);
                }
                break;
lbl439:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_91) {
                    try {
                        var7_48 = var8_91;
                        throw var8_91;
                    }
                    catch (Throwable var37_146) {
                        if (cmd != null) {
                            if (var7_48 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var38_147) {
                                    var7_48.addSuppressed(var38_147);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var37_146;
                    }
                }
            }
            case 16: {
                cmd = this.executeListContainersRequest(client, message);
                var7_49 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_49 == null) ** GOTO lbl469
                try {
                    cmd.close();
                }
                catch (Throwable var8_92) {
                    var7_49.addSuppressed(var8_92);
                }
                break;
lbl469:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_93) {
                    try {
                        var7_49 = var8_93;
                        throw var8_93;
                    }
                    catch (Throwable var39_148) {
                        if (cmd != null) {
                            if (var7_49 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var40_149) {
                                    var7_49.addSuppressed(var40_149);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var39_148;
                    }
                }
            }
            case 17: {
                cmd = this.executeKillContainerRequest(client, message);
                var7_50 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_50 == null) ** GOTO lbl499
                try {
                    cmd.close();
                }
                catch (Throwable var8_94) {
                    var7_50.addSuppressed(var8_94);
                }
                break;
lbl499:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_95) {
                    try {
                        var7_50 = var8_95;
                        throw var8_95;
                    }
                    catch (Throwable var41_150) {
                        if (cmd != null) {
                            if (var7_50 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var42_151) {
                                    var7_50.addSuppressed(var42_151);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var41_150;
                    }
                }
            }
            case 18: {
                cmd = this.executePauseContainerRequest(client, message);
                var7_51 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_51 == null) ** GOTO lbl529
                try {
                    cmd.close();
                }
                catch (Throwable var8_96) {
                    var7_51.addSuppressed(var8_96);
                }
                break;
lbl529:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_97) {
                    try {
                        var7_51 = var8_97;
                        throw var8_97;
                    }
                    catch (Throwable var43_152) {
                        if (cmd != null) {
                            if (var7_51 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var44_153) {
                                    var7_51.addSuppressed(var44_153);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var43_152;
                    }
                }
            }
            case 19: {
                cmd = this.executeRemoveContainerRequest(client, message);
                var7_52 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_52 == null) ** GOTO lbl559
                try {
                    cmd.close();
                }
                catch (Throwable var8_98) {
                    var7_52.addSuppressed(var8_98);
                }
                break;
lbl559:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_99) {
                    try {
                        var7_52 = var8_99;
                        throw var8_99;
                    }
                    catch (Throwable var45_154) {
                        if (cmd != null) {
                            if (var7_52 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var46_155) {
                                    var7_52.addSuppressed(var46_155);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var45_154;
                    }
                }
            }
            case 20: {
                cmd = this.executeRestartContainerRequest(client, message);
                var7_53 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_53 == null) ** GOTO lbl589
                try {
                    cmd.close();
                }
                catch (Throwable var8_100) {
                    var7_53.addSuppressed(var8_100);
                }
                break;
lbl589:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_101) {
                    try {
                        var7_53 = var8_101;
                        throw var8_101;
                    }
                    catch (Throwable var47_156) {
                        if (cmd != null) {
                            if (var7_53 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var48_157) {
                                    var7_53.addSuppressed(var48_157);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var47_156;
                    }
                }
            }
            case 21: {
                cmd = this.executeStartContainerRequest(client, message);
                var7_54 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_54 == null) ** GOTO lbl619
                try {
                    cmd.close();
                }
                catch (Throwable var8_102) {
                    var7_54.addSuppressed(var8_102);
                }
                break;
lbl619:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_103) {
                    try {
                        var7_54 = var8_103;
                        throw var8_103;
                    }
                    catch (Throwable var49_158) {
                        if (cmd != null) {
                            if (var7_54 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var50_159) {
                                    var7_54.addSuppressed(var50_159);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var49_158;
                    }
                }
            }
            case 22: {
                cmd = this.executeStopContainerRequest(client, message);
                var7_55 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_55 == null) ** GOTO lbl649
                try {
                    cmd.close();
                }
                catch (Throwable var8_104) {
                    var7_55.addSuppressed(var8_104);
                }
                break;
lbl649:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_105) {
                    try {
                        var7_55 = var8_105;
                        throw var8_105;
                    }
                    catch (Throwable var51_160) {
                        if (cmd != null) {
                            if (var7_55 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var52_161) {
                                    var7_55.addSuppressed(var52_161);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var51_160;
                    }
                }
            }
            case 23: {
                cmd = this.executeTopContainerRequest(client, message);
                var7_56 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_56 == null) ** GOTO lbl679
                try {
                    cmd.close();
                }
                catch (Throwable var8_106) {
                    var7_56.addSuppressed(var8_106);
                }
                break;
lbl679:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_107) {
                    try {
                        var7_56 = var8_107;
                        throw var8_107;
                    }
                    catch (Throwable var53_162) {
                        if (cmd != null) {
                            if (var7_56 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var54_163) {
                                    var7_56.addSuppressed(var54_163);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var53_162;
                    }
                }
            }
            case 24: {
                cmd = this.executeUnpauseContainerRequest(client, message);
                var7_57 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_57 == null) ** GOTO lbl709
                try {
                    cmd.close();
                }
                catch (Throwable var8_108) {
                    var7_57.addSuppressed(var8_108);
                }
                break;
lbl709:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_109) {
                    try {
                        var7_57 = var8_109;
                        throw var8_109;
                    }
                    catch (Throwable var55_164) {
                        if (cmd != null) {
                            if (var7_57 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var56_165) {
                                    var7_57.addSuppressed(var56_165);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var55_164;
                    }
                }
            }
            case 25: {
                cmd = this.executeCreateNetworkRequest(client, message);
                var7_58 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_58 == null) ** GOTO lbl739
                try {
                    cmd.close();
                }
                catch (Throwable var8_110) {
                    var7_58.addSuppressed(var8_110);
                }
                break;
lbl739:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_111) {
                    try {
                        var7_58 = var8_111;
                        throw var8_111;
                    }
                    catch (Throwable var57_166) {
                        if (cmd != null) {
                            if (var7_58 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var58_167) {
                                    var7_58.addSuppressed(var58_167);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var57_166;
                    }
                }
            }
            case 26: {
                cmd = this.executeRemoveNetworkRequest(client, message);
                var7_59 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_59 == null) ** GOTO lbl769
                try {
                    cmd.close();
                }
                catch (Throwable var8_112) {
                    var7_59.addSuppressed(var8_112);
                }
                break;
lbl769:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_113) {
                    try {
                        var7_59 = var8_113;
                        throw var8_113;
                    }
                    catch (Throwable var59_168) {
                        if (cmd != null) {
                            if (var7_59 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var60_169) {
                                    var7_59.addSuppressed(var60_169);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var59_168;
                    }
                }
            }
            case 27: {
                cmd = this.executeConnectToNetworkRequest(client, message);
                var7_60 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_60 == null) ** GOTO lbl799
                try {
                    cmd.close();
                }
                catch (Throwable var8_114) {
                    var7_60.addSuppressed(var8_114);
                }
                break;
lbl799:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_115) {
                    try {
                        var7_60 = var8_115;
                        throw var8_115;
                    }
                    catch (Throwable var61_170) {
                        if (cmd != null) {
                            if (var7_60 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var62_171) {
                                    var7_60.addSuppressed(var62_171);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var61_170;
                    }
                }
            }
            case 28: {
                cmd = this.executeExecCreateRequest(client, message);
                var7_61 = null;
                result = this.safeExec(cmd);
                if (cmd == null) break;
                if (var7_61 == null) ** GOTO lbl829
                try {
                    cmd.close();
                }
                catch (Throwable var8_116) {
                    var7_61.addSuppressed(var8_116);
                }
                break;
lbl829:
                // 1 sources

                cmd.close();
                break;
                catch (Throwable var8_117) {
                    try {
                        var7_61 = var8_117;
                        throw var8_117;
                    }
                    catch (Throwable var63_172) {
                        if (cmd != null) {
                            if (var7_61 != null) {
                                try {
                                    cmd.close();
                                }
                                catch (Throwable var64_173) {
                                    var7_61.addSuppressed(var64_173);
                                }
                            } else {
                                cmd.close();
                            }
                        }
                        throw var63_172;
                    }
                }
            }
            default: {
                throw new DockerException("Invalid operation: " + (Object)operation);
            }
        }
        if (result != null) {
            exchange.getIn().setBody(result);
        }
    }

    private Object safeExec(SyncDockerCmd<?> cmd) {
        if (cmd == null) {
            LOGGER.warn("Trying to execute a docker command but the requested object is null");
            return null;
        }
        return cmd.exec();
    }

    private AuthCmd executeAuthRequest(DockerClient client) {
        LOGGER.debug("Executing Docker Auth Request");
        AuthCmd authCmd = client.authCmd();
        if (authCmd != null) {
            AuthConfig authConfig = client.authConfig();
            authCmd.withAuthConfig(authConfig);
        }
        return authCmd;
    }

    private InfoCmd executeInfoRequest(DockerClient client) {
        LOGGER.debug("Executing Docker Info Request");
        return client.infoCmd();
    }

    private PingCmd executePingRequest(DockerClient client) {
        LOGGER.debug("Executing Docker Ping Request");
        return client.pingCmd();
    }

    private VersionCmd executeVersionRequest(DockerClient client) {
        LOGGER.debug("Executing Docker Version Request");
        return client.versionCmd();
    }

    private CreateImageCmd executeCreateImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Create Image Request");
        String repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class);
        InputStream inputStream = message.getBody(InputStream.class);
        if (repository == null || inputStream == null) {
            throw new IllegalArgumentException("Inputstream must be present on message body and repository must be specified");
        }
        return client.createImageCmd(repository, inputStream);
    }

    private InspectImageCmd executeInspectImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Inspect Image Request");
        String imageId = DockerHelper.getProperty("CamelDockerImageId", this.configuration, message, String.class);
        ObjectHelper.notNull(imageId, "Image ID must be specified");
        return client.inspectImageCmd(imageId);
    }

    private ListImagesCmd executeListImagesRequest(DockerClient client, Message message) {
        Boolean showAll;
        LOGGER.debug("Executing Docker Images List Request");
        ListImagesCmd listImagesCmd = client.listImagesCmd();
        String filter = DockerHelper.getProperty("CamelDockerFilter", this.configuration, message, String.class);
        if (filter != null) {
            listImagesCmd.withLabelFilter(filter);
        }
        if ((showAll = DockerHelper.getProperty("CamelDockerShowAll", this.configuration, message, Boolean.class)) != null) {
            listImagesCmd.withShowAll(showAll);
        }
        return listImagesCmd;
    }

    private RemoveImageCmd executeRemoveImageRequest(DockerClient client, Message message) {
        Boolean noPrune;
        LOGGER.debug("Executing Docker Remove Image Request");
        String imageId = DockerHelper.getProperty("CamelDockerImageId", this.configuration, message, String.class);
        ObjectHelper.notNull(imageId, "Image ID must be specified");
        RemoveImageCmd removeImagesCmd = client.removeImageCmd(imageId);
        Boolean force = DockerHelper.getProperty("CamelDockerForce", this.configuration, message, Boolean.class);
        if (force != null) {
            removeImagesCmd.withForce(force);
        }
        if ((noPrune = DockerHelper.getProperty("CamelDockerNoPrune", this.configuration, message, Boolean.class)) != null) {
            removeImagesCmd.withNoPrune(noPrune);
        }
        return removeImagesCmd;
    }

    private SearchImagesCmd executeSearchImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Search Image Request");
        String term = DockerHelper.getProperty("CamelDockerTerm", this.configuration, message, String.class);
        ObjectHelper.notNull(term, "Term must be specified");
        return client.searchImagesCmd(term);
    }

    private TagImageCmd executeTagImageRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Tag Image Request");
        String imageId = DockerHelper.getProperty("CamelDockerImageId", this.configuration, message, String.class);
        String repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class);
        String tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class);
        if (imageId == null || repository == null || tag == null) {
            throw new IllegalArgumentException("ImageId, repository and tag must be specified");
        }
        TagImageCmd tagImageCmd = client.tagImageCmd(imageId, repository, tag);
        Boolean force = DockerHelper.getProperty("CamelDockerForce", this.configuration, message, Boolean.class);
        if (force != null) {
            tagImageCmd.withForce(force);
        }
        return tagImageCmd;
    }

    private CommitCmd executeCommitContainerRequest(DockerClient client, Message message) {
        String workingDir;
        Volumes volumes;
        String user;
        Boolean tty;
        String tag;
        Boolean stdInOnce;
        String repository;
        String[] portSpecs;
        Boolean pause;
        Boolean openStdIn;
        String msg;
        Integer memorySwap;
        Integer memory;
        String hostname;
        ExposedPorts exposedPorts;
        String[] envs;
        Boolean disableNetwork;
        String[] cmds;
        Boolean attachStdOut;
        Boolean attachStdIn;
        Boolean attachStdErr;
        LOGGER.debug("Executing Docker Commit Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        CommitCmd commitCmd = client.commitCmd(containerId);
        String author = DockerHelper.getProperty("CamelDockerAuthor", this.configuration, message, String.class);
        if (author != null) {
            commitCmd.withAuthor(author);
        }
        if ((attachStdErr = DockerHelper.getProperty("CamelDockerAttachStdErr", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withAttachStderr(attachStdErr);
        }
        if ((attachStdIn = DockerHelper.getProperty("CamelDockerAttachStdIn", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withAttachStdin(attachStdIn);
        }
        if ((attachStdOut = DockerHelper.getProperty("CamelDockerAttachStdOut", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withAttachStdout(attachStdOut);
        }
        if ((cmds = DockerHelper.parseDelimitedStringHeader("CamelDockerCmd", message)) != null) {
            commitCmd.withCmd(cmds);
        }
        if ((disableNetwork = DockerHelper.getProperty("CamelDockerDisableNetwork", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withDisableNetwork(disableNetwork);
        }
        if ((envs = DockerHelper.parseDelimitedStringHeader("CamelDockerEnv", message)) != null) {
            commitCmd.withEnv(envs);
        }
        if ((exposedPorts = DockerHelper.getProperty("CamelDockerExposedPorts", this.configuration, message, ExposedPorts.class)) != null) {
            commitCmd.withExposedPorts(exposedPorts);
        }
        if ((hostname = DockerHelper.getProperty("CamelDockerHostname", this.configuration, message, String.class)) != null) {
            commitCmd.withHostname(hostname);
        }
        if ((memory = DockerHelper.getProperty("CamelDockerMemory", this.configuration, message, Integer.class)) != null) {
            commitCmd.withMemory(memory);
        }
        if ((memorySwap = DockerHelper.getProperty("CamelDockerMemorySwap", this.configuration, message, Integer.class)) != null) {
            commitCmd.withMemorySwap(memorySwap);
        }
        if ((msg = DockerHelper.getProperty("CamelDockerMessage", this.configuration, message, String.class)) != null) {
            commitCmd.withMessage(msg);
        }
        if ((openStdIn = DockerHelper.getProperty("CamelDockerOpenStdIn", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withOpenStdin(openStdIn);
        }
        if ((pause = DockerHelper.getProperty("CamelDockerPause", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withPause(pause);
        }
        if ((portSpecs = DockerHelper.parseDelimitedStringHeader("CamelDockerPortSpecs", message)) != null) {
            commitCmd.withPortSpecs(portSpecs);
        }
        if ((repository = DockerHelper.getProperty("CamelDockerRepository", this.configuration, message, String.class)) != null) {
            commitCmd.withRepository(repository);
        }
        if ((stdInOnce = DockerHelper.getProperty("CamelDockerStdInOnce", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withStdinOnce(stdInOnce);
        }
        if ((tag = DockerHelper.getProperty("CamelDockerTag", this.configuration, message, String.class)) != null) {
            commitCmd.withTag(tag);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            commitCmd.withTty(tty);
        }
        if ((user = DockerHelper.getProperty("CamelDockerUser", this.configuration, message, String.class)) != null) {
            commitCmd.withUser(user);
        }
        if ((volumes = DockerHelper.getProperty("CamelDockerVolumes", this.configuration, message, Volumes.class)) != null) {
            commitCmd.withVolumes(volumes);
        }
        if ((workingDir = DockerHelper.getProperty("CamelDockerWorkingDir", this.configuration, message, String.class)) != null) {
            commitCmd.withWorkingDir(workingDir);
        }
        return commitCmd;
    }

    private CopyArchiveFromContainerCmd executeCopyFileContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Copy File/Folder Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        String resource = DockerHelper.getProperty("CamelDockerResource", this.configuration, message, String.class);
        if (containerId == null || resource == null) {
            throw new IllegalArgumentException("Container ID and Resource must be specified");
        }
        CopyArchiveFromContainerCmd copyArchiveFromContainerCmd = client.copyArchiveFromContainerCmd(containerId, resource);
        String hostPath = DockerHelper.getProperty("CamelDockerHostPath", this.configuration, message, String.class);
        if (hostPath != null) {
            copyArchiveFromContainerCmd.withHostPath(hostPath);
        }
        return copyArchiveFromContainerCmd;
    }

    private CreateContainerCmd executeCreateContainerRequest(DockerClient client, Message message) {
        String workingDir;
        VolumesFrom[] volumesFrom;
        Volume[] volume;
        String user;
        Boolean tty;
        Boolean stdInOnce;
        Boolean stdInOpen;
        String[] portSpecs;
        String name;
        Long memorySwap;
        Long memoryLimit;
        String hostName;
        HostConfig hostConfig;
        ExposedPort[] exposedPorts;
        String[] entrypoint;
        String[] env;
        String domainName;
        String[] dns;
        Boolean disableNetwork;
        Integer cpuShares;
        String[] cmd;
        Capability[] capDrop;
        Capability[] capAdd;
        Boolean attachStdOut;
        Boolean attachStdIn;
        LOGGER.debug("Executing Docker Create Container Request");
        String image = DockerHelper.getProperty("CamelDockerImage", this.configuration, message, String.class);
        ObjectHelper.notNull(image, "Image must be specified");
        CreateContainerCmd createContainerCmd = client.createContainerCmd(image);
        createContainerCmd.withHostConfig(HostConfig.newHostConfig());
        Boolean attachStdErr = DockerHelper.getProperty("CamelDockerAttachStdErr", this.configuration, message, Boolean.class);
        if (attachStdErr != null) {
            createContainerCmd.withAttachStderr(attachStdErr);
        }
        if ((attachStdIn = DockerHelper.getProperty("CamelDockerAttachStdIn", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withAttachStdin(attachStdIn);
        }
        if ((attachStdOut = DockerHelper.getProperty("CamelDockerAttachStdOut", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withAttachStdout(attachStdOut);
        }
        if ((capAdd = DockerHelper.getArrayProperty("CamelDockerCapAdd", message, Capability.class)) != null) {
            createContainerCmd.getHostConfig().withCapAdd(capAdd);
        }
        if ((capDrop = DockerHelper.getArrayProperty("CamelDockerCapDrop", message, Capability.class)) != null) {
            createContainerCmd.getHostConfig().withCapDrop(capDrop);
        }
        if ((cmd = DockerHelper.parseDelimitedStringHeader("CamelDockerCmd", message)) != null) {
            createContainerCmd.withCmd(cmd);
        }
        if ((cpuShares = DockerHelper.getProperty("CamelDockerCpuShares", this.configuration, message, Integer.class)) != null) {
            createContainerCmd.getHostConfig().withCpuShares(cpuShares);
        }
        if ((disableNetwork = DockerHelper.getProperty("CamelDockerDisableNetwork", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withNetworkDisabled(disableNetwork);
        }
        if ((dns = DockerHelper.parseDelimitedStringHeader("CamelDockerDns", message)) != null) {
            createContainerCmd.getHostConfig().withDns(dns);
        }
        if ((domainName = DockerHelper.getProperty("CamelDockerDomainName", this.configuration, message, String.class)) != null) {
            createContainerCmd.withDomainName(domainName);
        }
        if ((env = DockerHelper.parseDelimitedStringHeader("CamelDockerEnv", message)) != null) {
            createContainerCmd.withEnv(env);
        }
        if ((entrypoint = DockerHelper.getArrayProperty("CamelDockerEntryPoint", message, String.class)) != null) {
            createContainerCmd.withEntrypoint(entrypoint);
        }
        if ((exposedPorts = DockerHelper.getArrayProperty("CamelDockerExposedPorts", message, ExposedPort.class)) != null) {
            createContainerCmd.withExposedPorts(exposedPorts);
        }
        if ((hostConfig = DockerHelper.getProperty("CamelDockerHostConfig", this.configuration, message, HostConfig.class)) != null) {
            createContainerCmd.withHostConfig(hostConfig);
        }
        if ((hostName = DockerHelper.getProperty("CamelDockerHostname", this.configuration, message, String.class)) != null) {
            createContainerCmd.withHostName(hostName);
        }
        if ((memoryLimit = DockerHelper.getProperty("CamelDockerMemoryLimit", this.configuration, message, Long.class)) != null) {
            createContainerCmd.getHostConfig().withMemory(memoryLimit);
        }
        if ((memorySwap = DockerHelper.getProperty("CamelDockerMemorySwap", this.configuration, message, Long.class)) != null) {
            createContainerCmd.getHostConfig().withMemorySwap(memorySwap);
        }
        if ((name = DockerHelper.getProperty("CamelDockerName", this.configuration, message, String.class)) != null) {
            createContainerCmd.withName(name);
        }
        if ((portSpecs = DockerHelper.parseDelimitedStringHeader("CamelDockerPortSpecs", message)) != null) {
            createContainerCmd.withPortSpecs(portSpecs);
        }
        if ((stdInOpen = DockerHelper.getProperty("CamelDockerStdInOpen", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withStdinOpen(stdInOpen);
        }
        if ((stdInOnce = DockerHelper.getProperty("CamelDockerStdInOnce", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withStdInOnce(stdInOnce);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            createContainerCmd.withTty(tty);
        }
        if ((user = DockerHelper.getProperty("CamelDockerUser", this.configuration, message, String.class)) != null) {
            createContainerCmd.withUser(user);
        }
        if ((volume = DockerHelper.getArrayProperty("CamelDockerVolumes", message, Volume.class)) != null) {
            createContainerCmd.withVolumes(volume);
        }
        if ((volumesFrom = DockerHelper.getArrayProperty("CamelDockerVolumesFrom", message, VolumesFrom.class)) != null) {
            createContainerCmd.getHostConfig().withVolumesFrom(volumesFrom);
        }
        if ((workingDir = DockerHelper.getProperty("CamelDockerWorkingDir", this.configuration, message, String.class)) != null) {
            createContainerCmd.withWorkingDir(workingDir);
        }
        return createContainerCmd;
    }

    private ContainerDiffCmd executeDiffContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Diff Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        ContainerDiffCmd diffContainerCmd = client.containerDiffCmd(containerId);
        String containerIdDiff = DockerHelper.getProperty("CamelDockerContainerIdDiff", this.configuration, message, String.class);
        if (containerIdDiff != null) {
            diffContainerCmd.withContainerId(containerIdDiff);
        }
        return diffContainerCmd;
    }

    private InspectContainerCmd executeInspectContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Inspect Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        return client.inspectContainerCmd(containerId);
    }

    private KillContainerCmd executeKillContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Kill Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        KillContainerCmd killContainerCmd = client.killContainerCmd(containerId);
        String signal = DockerHelper.getProperty("CamelDockerSignal", this.configuration, message, String.class);
        if (signal != null) {
            killContainerCmd.withSignal(signal);
        }
        return killContainerCmd;
    }

    private ListContainersCmd executeListContainersRequest(DockerClient client, Message message) {
        String since;
        Boolean showSize;
        Boolean showAll;
        Integer limit;
        LOGGER.debug("Executing Docker List Container Request");
        ListContainersCmd listContainersCmd = client.listContainersCmd();
        String before = DockerHelper.getProperty("CamelDockerBefore", this.configuration, message, String.class);
        if (before != null) {
            listContainersCmd.withBefore(before);
        }
        if ((limit = DockerHelper.getProperty("CamelDockerLimit", this.configuration, message, Integer.class)) != null) {
            listContainersCmd.withLimit(limit);
        }
        if ((showAll = DockerHelper.getProperty("CamelDockerShowAll", this.configuration, message, Boolean.class)) != null) {
            listContainersCmd.withShowAll(showAll);
        }
        if ((showSize = DockerHelper.getProperty("CamelDockerShowSize", this.configuration, message, Boolean.class)) != null) {
            listContainersCmd.withShowSize(showSize);
        }
        if ((since = DockerHelper.getProperty("CamelDockerSince", this.configuration, message, String.class)) != null) {
            listContainersCmd.withSince(since);
        }
        return listContainersCmd;
    }

    private PauseContainerCmd executePauseContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Pause Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        return client.pauseContainerCmd(containerId);
    }

    private RemoveContainerCmd executeRemoveContainerRequest(DockerClient client, Message message) {
        Boolean removeVolumes;
        LOGGER.debug("Executing Docker Remove Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        RemoveContainerCmd removeContainerCmd = client.removeContainerCmd(containerId);
        Boolean force = DockerHelper.getProperty("CamelDockerForce", this.configuration, message, Boolean.class);
        if (force != null) {
            removeContainerCmd.withForce(force);
        }
        if ((removeVolumes = DockerHelper.getProperty("CamelDockerRemoveVolumes", this.configuration, message, Boolean.class)) != null) {
            removeContainerCmd.withRemoveVolumes(removeVolumes);
        }
        return removeContainerCmd;
    }

    private RestartContainerCmd executeRestartContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Restart Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        RestartContainerCmd restartContainerCmd = client.restartContainerCmd(containerId);
        Integer timeout = DockerHelper.getProperty("CamelDockerTimeout", this.configuration, message, Integer.class);
        if (timeout != null) {
            restartContainerCmd.withtTimeout(timeout);
        }
        return restartContainerCmd;
    }

    private StartContainerCmd executeStartContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Start Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        return client.startContainerCmd(containerId);
    }

    private StopContainerCmd executeStopContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Stop Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        StopContainerCmd stopContainerCmd = client.stopContainerCmd(containerId);
        Integer timeout = DockerHelper.getProperty("CamelDockerTimeout", this.configuration, message, Integer.class);
        if (timeout != null) {
            stopContainerCmd.withTimeout(timeout);
        }
        return stopContainerCmd;
    }

    private TopContainerCmd executeTopContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Top Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        TopContainerCmd topContainerCmd = client.topContainerCmd(containerId);
        String psArgs = DockerHelper.getProperty("CamelDockerPsArgs", this.configuration, message, String.class);
        if (psArgs != null) {
            topContainerCmd.withPsArgs(psArgs);
        }
        return topContainerCmd;
    }

    private UnpauseContainerCmd executeUnpauseContainerRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Unpause Container Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        return client.unpauseContainerCmd(containerId);
    }

    private CreateNetworkCmd executeCreateNetworkRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Network Create Request");
        String networkName = DockerHelper.getProperty("CamelDockerNetwork", this.configuration, message, String.class);
        ObjectHelper.notNull(networkName, "Network Name must be specified");
        return client.createNetworkCmd().withName(networkName);
    }

    private RemoveNetworkCmd executeRemoveNetworkRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Network Remove Request");
        String networkId = DockerHelper.getProperty("CamelDockerNetwork", this.configuration, message, String.class);
        ObjectHelper.notNull(networkId, "Network ID must be specified");
        return client.removeNetworkCmd(networkId);
    }

    private ConnectToNetworkCmd executeConnectToNetworkRequest(DockerClient client, Message message) {
        LOGGER.debug("Executing Docker Network Connect Request");
        String networkId = DockerHelper.getProperty("CamelDockerNetwork", this.configuration, message, String.class);
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(networkId, "Network ID must be specified");
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        return client.connectToNetworkCmd().withNetworkId(networkId).withContainerId(containerId);
    }

    private ExecCreateCmd executeExecCreateRequest(DockerClient client, Message message) {
        Boolean tty;
        String[] cmd;
        Boolean attachStdOut;
        LOGGER.debug("Executing Docker Exec Create Request");
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.configuration, message, String.class);
        ObjectHelper.notNull(containerId, "Container ID must be specified");
        ExecCreateCmd execCreateCmd = client.execCreateCmd(containerId);
        Boolean attachStdIn = DockerHelper.getProperty("CamelDockerAttachStdIn", this.configuration, message, Boolean.class);
        Boolean attachStdErr = DockerHelper.getProperty("CamelDockerAttachStdErr", this.configuration, message, Boolean.class);
        if (attachStdErr != null) {
            execCreateCmd.withAttachStderr(attachStdErr);
        }
        if (attachStdIn != null) {
            execCreateCmd.withAttachStdin(attachStdIn);
        }
        if ((attachStdOut = DockerHelper.getProperty("CamelDockerAttachStdOut", this.configuration, message, Boolean.class)) != null) {
            execCreateCmd.withAttachStdout(attachStdOut);
        }
        if ((cmd = DockerHelper.parseDelimitedStringHeader("CamelDockerCmd", message)) != null) {
            execCreateCmd.withCmd(cmd);
        }
        if ((tty = DockerHelper.getProperty("CamelDockerTty", this.configuration, message, Boolean.class)) != null) {
            execCreateCmd.withTty(tty);
        }
        return execCreateCmd;
    }
}

