/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class DockerComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private DockerConfiguration getOrCreateConfiguration(DockerComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new DockerConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DockerComponent target = (DockerComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(DockerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(DockerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "certpath": 
            case "certPath": {
                this.getOrCreateConfiguration(target).setCertPath(DockerComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "cmdexecfactory": 
            case "cmdExecFactory": {
                this.getOrCreateConfiguration(target).setCmdExecFactory(DockerComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(DockerComponentConfigurer.property(camelContext, DockerConfiguration.class, value));
                return true;
            }
            case "email": {
                this.getOrCreateConfiguration(target).setEmail(DockerComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "followredirectfilter": 
            case "followRedirectFilter": {
                this.getOrCreateConfiguration(target).setFollowRedirectFilter(DockerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "host": {
                this.getOrCreateConfiguration(target).setHost(DockerComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(DockerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "loggingfilter": 
            case "loggingFilter": {
                this.getOrCreateConfiguration(target).setLoggingFilter(DockerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxperrouteconnections": 
            case "maxPerRouteConnections": {
                this.getOrCreateConfiguration(target).setMaxPerRouteConnections(DockerComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "maxtotalconnections": 
            case "maxTotalConnections": {
                this.getOrCreateConfiguration(target).setMaxTotalConnections(DockerComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "parameters": {
                this.getOrCreateConfiguration(target).setParameters(DockerComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword(DockerComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "port": {
                this.getOrCreateConfiguration(target).setPort(DockerComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                this.getOrCreateConfiguration(target).setRequestTimeout(DockerComponentConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "secure": {
                this.getOrCreateConfiguration(target).setSecure(DockerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "serveraddress": 
            case "serverAddress": {
                this.getOrCreateConfiguration(target).setServerAddress(DockerComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "socket": {
                this.getOrCreateConfiguration(target).setSocket(DockerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "tlsverify": 
            case "tlsVerify": {
                this.getOrCreateConfiguration(target).setTlsVerify(DockerComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername(DockerComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "certpath": 
            case "certPath": {
                return String.class;
            }
            case "cmdexecfactory": 
            case "cmdExecFactory": {
                return String.class;
            }
            case "configuration": {
                return DockerConfiguration.class;
            }
            case "email": {
                return String.class;
            }
            case "followredirectfilter": 
            case "followRedirectFilter": {
                return Boolean.TYPE;
            }
            case "host": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "loggingfilter": 
            case "loggingFilter": {
                return Boolean.TYPE;
            }
            case "maxperrouteconnections": 
            case "maxPerRouteConnections": {
                return Integer.class;
            }
            case "maxtotalconnections": 
            case "maxTotalConnections": {
                return Integer.class;
            }
            case "parameters": {
                return Map.class;
            }
            case "password": {
                return String.class;
            }
            case "port": {
                return Integer.class;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return Integer.class;
            }
            case "secure": {
                return Boolean.TYPE;
            }
            case "serveraddress": 
            case "serverAddress": {
                return String.class;
            }
            case "socket": {
                return Boolean.TYPE;
            }
            case "tlsverify": 
            case "tlsVerify": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DockerComponent target = (DockerComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "certpath": 
            case "certPath": {
                return this.getOrCreateConfiguration(target).getCertPath();
            }
            case "cmdexecfactory": 
            case "cmdExecFactory": {
                return this.getOrCreateConfiguration(target).getCmdExecFactory();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "email": {
                return this.getOrCreateConfiguration(target).getEmail();
            }
            case "followredirectfilter": 
            case "followRedirectFilter": {
                return this.getOrCreateConfiguration(target).isFollowRedirectFilter();
            }
            case "host": {
                return this.getOrCreateConfiguration(target).getHost();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "loggingfilter": 
            case "loggingFilter": {
                return this.getOrCreateConfiguration(target).isLoggingFilter();
            }
            case "maxperrouteconnections": 
            case "maxPerRouteConnections": {
                return this.getOrCreateConfiguration(target).getMaxPerRouteConnections();
            }
            case "maxtotalconnections": 
            case "maxTotalConnections": {
                return this.getOrCreateConfiguration(target).getMaxTotalConnections();
            }
            case "parameters": {
                return this.getOrCreateConfiguration(target).getParameters();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "port": {
                return this.getOrCreateConfiguration(target).getPort();
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return this.getOrCreateConfiguration(target).getRequestTimeout();
            }
            case "secure": {
                return this.getOrCreateConfiguration(target).isSecure();
            }
            case "serveraddress": 
            case "serverAddress": {
                return this.getOrCreateConfiguration(target).getServerAddress();
            }
            case "socket": {
                return this.getOrCreateConfiguration(target).isSocket();
            }
            case "tlsverify": 
            case "tlsVerify": {
                return this.getOrCreateConfiguration(target).isTlsVerify();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "parameters": {
                return Object.class;
            }
        }
        return null;
    }
}

