/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap;

import org.apache.commons.lang3.StringUtils;
import org.dozer.util.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassMapKeyFactory {
    public String createKey(Class<?> srcClass, Class<?> destClass) {
        return this.createKey(srcClass, destClass, null);
    }

    public String createKey(Class<?> srcClass, Class<?> destClass, String mapId) {
        Class<?> srcRealClass = MappingUtils.getRealClass(srcClass);
        Class<?> destRealClass = MappingUtils.getRealClass(destClass);
        StringBuilder result = new StringBuilder(140);
        result.append("SRC-CLASS->");
        result.append(srcRealClass.getName());
        result.append(" DST-CLASS->");
        result.append(destRealClass.getName());
        if (StringUtils.isNotEmpty(mapId)) {
            result.append(" MAP-ID->");
            result.append(mapId);
        }
        return result.toString();
    }
}

